/*
 * Decompiled with CFR 0.152.
 */
package com.moments.landscapevideocapture;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.ThumbnailUtils;
import android.os.Bundle;
import android.util.Log;
import android.view.OrientationEventListener;
import android.widget.Toast;
import com.moments.landscapevideocapture.CLog;
import com.moments.landscapevideocapture.R;
import com.moments.landscapevideocapture.Utils;
import com.moments.landscapevideocapture.VideoFile;
import com.moments.landscapevideocapture.camera.CameraWrapper;
import com.moments.landscapevideocapture.configuration.CaptureConfiguration;
import com.moments.landscapevideocapture.configuration.PredefinedCaptureConfigurations;
import com.moments.landscapevideocapture.recorder.VideoRecorder;
import com.moments.landscapevideocapture.recorder.VideoRecorderInterface;
import com.moments.landscapevideocapture.view.RecordingButtonInterface;
import com.moments.landscapevideocapture.view.VideoCaptureView;
import java.io.File;

public class VideoCaptureActivity
extends Activity
implements RecordingButtonInterface,
VideoRecorderInterface {
    public static final String TAG = "VideoCaptureActivity";
    public static final int RESULT_ERROR = 753245;
    private static String kB_UNIT_NAME = "KB";
    private static String B_UNIT_NAME = "B";
    private static String MB_UNIT_NAME = "MB";
    public static final String EXTRA_OUTPUT_FILENAME = "com.jmolsmobile.extraoutputfilename";
    public static final String EXTRA_CAPTURE_CONFIGURATION = "com.jmolsmobile.extracaptureconfiguration";
    public static final String EXTRA_ERROR_MESSAGE = "com.jmolsmobile.extraerrormessage";
    private static final String SAVED_RECORDED_BOOLEAN = "com.jmolsmobile.savedrecordedboolean";
    protected static final String SAVED_OUTPUT_FILENAME = "com.jmolsmobile.savedoutputfilename";
    private boolean mVideoRecorded = false;
    VideoFile mVideoFile = null;
    private CaptureConfiguration mCaptureConfiguration;
    private VideoCaptureView mVideoCaptureView;
    private VideoRecorder mVideoRecorder;
    private static final int mFileDuration = 30;
    private static final int mFilesize = 10;
    private MyOrientationEventListener mOrientationListener;
    private int mOrientation = -1;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        CLog.toggleLogging((Context)this);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.moments_videocapture_activity_videocapture);
        this.initializeCaptureConfiguration(savedInstanceState);
        this.mVideoCaptureView = (VideoCaptureView)this.findViewById(R.id.videocapture_videocaptureview_vcv);
        if (this.mVideoCaptureView == null) {
            return;
        }
        this.mOrientationListener = new MyOrientationEventListener((Context)this);
    }

    protected void onResume() {
        this.mOrientationListener.enable();
        super.onResume();
        this.initializeRecordingUI();
    }

    private CaptureConfiguration createCaptureConfiguration() {
        PredefinedCaptureConfigurations.CaptureResolution resolution = PredefinedCaptureConfigurations.CaptureResolution.RES_1080P;
        PredefinedCaptureConfigurations.CaptureQuality quality = PredefinedCaptureConfigurations.CaptureQuality.LOW;
        CaptureConfiguration config = new CaptureConfiguration(resolution, quality, 30, 10);
        return config;
    }

    private void initializeCaptureConfiguration(Bundle savedInstanceState) {
        this.mCaptureConfiguration = this.generateCaptureConfiguration();
        this.mVideoRecorded = this.generateVideoRecorded(savedInstanceState);
        this.mVideoFile = this.generateOutputFile(savedInstanceState);
    }

    private void initializeRecordingUI() {
        this.mVideoRecorder = new VideoRecorder(this, this.mCaptureConfiguration, this.mVideoFile, new CameraWrapper(), this.mVideoCaptureView.getPreviewSurfaceHolder());
        this.mVideoCaptureView.setRecordingButtonInterface(this);
        Log.e((String)TAG, (String)("initializeRecordingUI=========>" + this.mVideoRecorded));
        if (this.mVideoRecorded) {
            this.mVideoCaptureView.updateUIRecordingFinished(this.getVideoThumbnail());
        } else {
            this.mVideoCaptureView.updateUINotRecording();
        }
    }

    protected void onPause() {
        this.mOrientationListener.disable();
        if (this.mVideoRecorder != null) {
            this.mVideoRecorder.stopRecording(null);
        }
        this.mVideoCaptureView.hideSurfaceView();
        this.releaseAllResources();
        super.onPause();
    }

    public void onBackPressed() {
        if (this.mVideoRecorder.isRecording()) {
            this.mVideoCaptureView.stopTimer();
            this.mVideoRecorder.toggleRecording();
            Log.e((String)TAG, (String)"\u505c\u6b62\u5f55\u5236===========>");
        } else {
            this.finishCancelled();
        }
    }

    @Override
    public void onRecordButtonClicked() {
        this.mVideoRecorder.toggleRecording();
    }

    @Override
    public void onAcceptButtonClicked() {
        this.finishCompleted();
    }

    @Override
    public void onDeclineButtonClicked() {
        this.finishCancelled();
    }

    @Override
    public void onRecordingStarted() {
        this.mVideoCaptureView.updateUIRecordingOngoing();
        this.mVideoCaptureView.startTimerTask();
        Log.e((String)TAG, (String)"\u5f00\u59cb\u5f55\u5236===========>");
    }

    @Override
    public void onPreviewButtonClicked() {
        this.mVideoCaptureView.updateUIVideoPreview(this.mVideoFile.getFullPath());
    }

    @Override
    public void onExchangewButtonClicked() {
        this.mVideoRecorder.openFindBackOrFrontCamera();
    }

    @Override
    public void onRecordingStopped(String message) {
        if (message != null) {
            Toast.makeText((Context)this, (CharSequence)message, (int)1).show();
        }
        this.mVideoCaptureView.stopTimer();
        Log.e((String)TAG, (String)"\u505c\u6b62\u5f55\u5236===========>");
        this.mVideoCaptureView.updateVideoSize(this.getSizeString(this.getFileSize(this.mVideoFile.getFullPath())));
        this.mVideoCaptureView.updateUIRecordingFinished(this.getVideoThumbnail());
    }

    @Override
    public void onRecordingSuccess() {
        this.mVideoRecorded = true;
    }

    @Override
    public void onRecordingFailed(String message) {
        this.finishError(message);
    }

    private void finishCompleted() {
        Intent result = new Intent();
        result.putExtra(EXTRA_OUTPUT_FILENAME, this.mVideoFile.getFullPath());
        this.setResult(-1, result);
        this.finish();
    }

    protected void onStop() {
        super.onStop();
        this.mVideoCaptureView.stopTimer();
    }

    private void finishError(String message) {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)("\u65e0\u6cd5\u6355\u6349\u89c6\u9891: " + message), (int)1).show();
        Intent result = new Intent();
        result.putExtra(EXTRA_ERROR_MESSAGE, message);
        this.setResult(753245, result);
        this.finish();
    }

    private void finishCancelled() {
        this.setResult(0);
        this.finish();
    }

    private void releaseAllResources() {
        if (this.mVideoRecorder != null) {
            this.mVideoRecorder.releaseAllResources();
        }
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putBoolean(SAVED_RECORDED_BOOLEAN, this.mVideoRecorded);
        savedInstanceState.putString(SAVED_OUTPUT_FILENAME, this.mVideoFile.getFullPath());
        super.onSaveInstanceState(savedInstanceState);
    }

    protected CaptureConfiguration generateCaptureConfiguration() {
        CaptureConfiguration returnConfiguration = this.createCaptureConfiguration();
        if (returnConfiguration == null) {
            returnConfiguration = new CaptureConfiguration();
            CLog.d("VideoCapture_Activity", "No captureconfiguration passed - using default configuration");
        }
        return returnConfiguration;
    }

    private boolean generateVideoRecorded(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return false;
        }
        return savedInstanceState.getBoolean(SAVED_RECORDED_BOOLEAN, false);
    }

    protected VideoFile generateOutputFile(Bundle savedInstanceState) {
        VideoFile returnFile = null;
        returnFile = savedInstanceState != null ? new VideoFile(savedInstanceState.getString(SAVED_OUTPUT_FILENAME)) : new VideoFile("");
        return returnFile;
    }

    public Bitmap getVideoThumbnail() {
        Bitmap thumbnail = ThumbnailUtils.createVideoThumbnail((String)this.mVideoFile.getFullPath(), (int)2);
        if (thumbnail == null) {
            CLog.d("VideoCapture_Activity", "Failed to generate video preview");
        }
        return thumbnail;
    }

    public int getFileSize(String filePath) {
        int length = -1;
        File file = new File(filePath);
        if (file.exists()) {
            length = (int)file.length();
        }
        file = null;
        return length;
    }

    public String getSizeString(long size) {
        if (size == -1L) {
            return "";
        }
        if (size < 1024L) {
            return String.valueOf(size) + B_UNIT_NAME;
        }
        if ((size /= 1024L) < 1024L) {
            return String.valueOf(size) + kB_UNIT_NAME;
        }
        size = size * 100L / 1024L;
        return String.valueOf(size / 100L) + "." + (size % 100L < 10L ? "0" : "") + String.valueOf(size % 100L) + MB_UNIT_NAME;
    }

    private class MyOrientationEventListener
    extends OrientationEventListener {
        public MyOrientationEventListener(Context context) {
            super(context);
        }

        public void onOrientationChanged(int orientation) {
            if (orientation == -1) {
                return;
            }
            int newOrientation = Utils.roundOrientation(orientation, VideoCaptureActivity.this.mOrientation);
            if (VideoCaptureActivity.this.mOrientation != newOrientation) {
                VideoCaptureActivity.this.mOrientation = newOrientation;
                if (VideoCaptureActivity.this.mVideoRecorder != null) {
                    VideoCaptureActivity.this.mVideoRecorder.setmOrientation(VideoCaptureActivity.this.mOrientation);
                }
            }
        }
    }
}

