/*
 * Decompiled with CFR 0.152.
 */
package com.moments.landscapevideocapture.configuration;

public class PredefinedCaptureConfigurations {
    public static final int BITRATE_LQ_360P = 300000;
    public static final int BITRATE_MQ_360P = 700000;
    public static final int BITRATE_HQ_360P = 1000000;
    public static final int HEIGHT_360P = 360;
    public static final int WIDTH_360P = 640;
    public static final int BITRATE_LQ_480P = 750000;
    public static final int BITRATE_MQ_480P = 1750000;
    public static final int BITRATE_HQ_480P = 2500000;
    public static final int HEIGHT_480P = 480;
    public static final int WIDTH_480P = 640;
    public static final int BITRATE_LQ_720P = 1500000;
    public static final int BITRATE_MQ_720P = 3500000;
    public static final int BITRATE_HQ_720P = 5000000;
    public static final int HEIGHT_720P = 720;
    public static final int WIDTH_720P = 1280;
    public static final int BITRATE_LQ_1080P = 2400000;
    public static final int BITRATE_MQ_1080P = 5600000;
    public static final int BITRATE_HQ_1080P = 8000000;
    public static final int HEIGHT_1080P = 1080;
    public static final int WIDTH_1080P = 1920;
    public static final int BITRATE_LQ_1440P = 3000000;
    public static final int BITRATE_MQ_1440P = 7000000;
    public static final int BITRATE_HQ_1440P = 10000000;
    public static final int HEIGHT_1440P = 1440;
    public static final int WIDTH_1440P = 2560;
    public static final int BITRATE_LQ_2160P = 12000000;
    public static final int BITRATE_MQ_2160P = 28000000;
    public static final int BITRATE_HQ_2160P = 40000000;
    public static final int HEIGHT_2160P = 2160;
    public static final int WIDTH_2160P = 3840;

    public static enum CaptureResolution {
        RES_360P(640, 360, 1000000, 700000, 300000),
        RES_480P(640, 480, 2500000, 1750000, 750000),
        RES_720P(1280, 720, 5000000, 3500000, 1500000),
        RES_1080P(1920, 1080, 8000000, 5600000, 2400000),
        RES_1440P(2560, 1440, 10000000, 7000000, 3000000),
        RES_2160P(3840, 2160, 40000000, 28000000, 12000000);

        public int width;
        public int height;
        private final int lowBitrate;
        private final int medBitrate;
        private final int highBitrate;

        private CaptureResolution(int width, int height, int highBitrate, int medBitrate, int lowBitrate) {
            this.width = width;
            this.height = height;
            this.highBitrate = highBitrate;
            this.medBitrate = medBitrate;
            this.lowBitrate = lowBitrate;
        }

        public int getBitrate(CaptureQuality quality) {
            switch (quality) {
                case HIGH: {
                    return this.highBitrate;
                }
                case MEDIUM: {
                    return this.medBitrate;
                }
                case LOW: {
                    return this.lowBitrate;
                }
            }
            return this.highBitrate;
        }
    }

    public static enum CaptureQuality {
        LOW,
        MEDIUM,
        HIGH;

    }
}

