/*
 * Decompiled with CFR 0.152.
 */
package com.moments.landscapevideocapture.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.MediaController;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.VideoView;
import com.moments.landscapevideocapture.R;
import com.moments.landscapevideocapture.view.RecordingButtonInterface;
import java.util.Timer;
import java.util.TimerTask;

public class VideoCaptureView
extends FrameLayout
implements View.OnClickListener,
MediaPlayer.OnCompletionListener {
    private static final String TAG = "VideoCaptureView";
    private TextView mDeclineBtnIv;
    private TextView mAcceptBtnIv;
    private ImageView mRecordBtnIv;
    private SurfaceView mSurfaceView;
    private VideoView mVideoView;
    private MediaController mMediaController;
    private ImageView mThumbnailIv;
    private ImageView mPreviImgBtnIv;
    private TextView mTimeTxt;
    private TextView mRetake;
    private TextView mExchangeBtnIv;
    private RelativeLayout mTopCoverLayout;
    private TextView mSizeTv;
    private TextView mDurationTv;
    protected static Timer mTimer;
    protected static TimerTask mTimerTask;
    protected static final int mTimeRefresh = 1000;
    protected Handler mHandler;
    protected static final int BACK_TIME = 11002;
    private static boolean isloop;
    private static int num;
    private RecordingButtonInterface mRecordingInterface;

    public VideoCaptureView(Context context) {
        super(context);
        this.initialize(context);
    }

    public VideoCaptureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context);
    }

    public VideoCaptureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    private void initialize(Context context) {
        View videoCapture = View.inflate((Context)context, (int)R.layout.moments_videocapture_view_videocapture, (ViewGroup)this);
        this.mRecordBtnIv = (ImageView)videoCapture.findViewById(R.id.videocapture_recordbtn_iv);
        this.mAcceptBtnIv = (TextView)videoCapture.findViewById(R.id.videocapture_acceptbtn_iv);
        this.mDeclineBtnIv = (TextView)videoCapture.findViewById(R.id.videocapture_declinebtn_iv);
        this.mPreviImgBtnIv = (ImageView)videoCapture.findViewById(R.id.videocapture_previImg_iv);
        this.mTimeTxt = (TextView)videoCapture.findViewById(R.id.videocapture_preview_tv);
        this.mExchangeBtnIv = (TextView)videoCapture.findViewById(R.id.videocapture_exchangebtn_iv);
        this.mRetake = (TextView)videoCapture.findViewById(R.id.videocapture_retake_iv);
        this.mTopCoverLayout = (RelativeLayout)videoCapture.findViewById(R.id.topCover_layout);
        this.mSizeTv = (TextView)videoCapture.findViewById(R.id.size_tv);
        this.mDurationTv = (TextView)videoCapture.findViewById(R.id.duration_tv);
        this.mRecordBtnIv.setOnClickListener((View.OnClickListener)this);
        this.mAcceptBtnIv.setOnClickListener((View.OnClickListener)this);
        this.mDeclineBtnIv.setOnClickListener((View.OnClickListener)this);
        this.mPreviImgBtnIv.setOnClickListener((View.OnClickListener)this);
        this.mExchangeBtnIv.setOnClickListener((View.OnClickListener)this);
        this.mRetake.setOnClickListener((View.OnClickListener)this);
        this.mThumbnailIv = (ImageView)videoCapture.findViewById(R.id.videocapture_preview_iv);
        this.mVideoView = (VideoView)videoCapture.findViewById(R.id.videocapture_previewVideo_iv);
        this.mMediaController = new MediaController(context);
        this.mVideoView.setMediaController(this.mMediaController);
        this.mMediaController.setMediaPlayer((MediaController.MediaPlayerControl)this.mVideoView);
        this.mVideoView.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mSurfaceView = (SurfaceView)videoCapture.findViewById(R.id.videocapture_preview_sv);
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                VideoCaptureView.this.handleMsg(msg);
            }
        };
    }

    public void setRecordingButtonInterface(RecordingButtonInterface mBtnInterface) {
        this.mRecordingInterface = mBtnInterface;
    }

    public SurfaceHolder getPreviewSurfaceHolder() {
        return this.mSurfaceView.getHolder();
    }

    public void hideSurfaceView() {
        this.mSurfaceView.setVisibility(8);
    }

    public void updateUINotRecording() {
        this.mRecordBtnIv.setSelected(false);
        this.mRecordBtnIv.setVisibility(0);
        this.mAcceptBtnIv.setVisibility(8);
        this.mDeclineBtnIv.setVisibility(0);
        this.mThumbnailIv.setVisibility(8);
        this.mPreviImgBtnIv.setVisibility(8);
        this.mVideoView.setVisibility(8);
        this.mSurfaceView.setVisibility(0);
        this.mExchangeBtnIv.setVisibility(0);
        this.mRetake.setVisibility(8);
        this.mTimeTxt.setVisibility(0);
        this.mTimeTxt.setText((CharSequence)"0/30s");
        this.mTopCoverLayout.setVisibility(8);
    }

    public void updateUIRecordingOngoing() {
        this.mRecordBtnIv.setSelected(true);
        this.mRecordBtnIv.setVisibility(0);
        this.mAcceptBtnIv.setVisibility(8);
        this.mDeclineBtnIv.setVisibility(8);
        this.mThumbnailIv.setVisibility(8);
        this.mPreviImgBtnIv.setVisibility(8);
        this.mVideoView.setVisibility(8);
        this.mExchangeBtnIv.setVisibility(8);
        this.mRetake.setVisibility(8);
        this.mSurfaceView.setVisibility(0);
    }

    public void updateUIRecordingFinished(Bitmap videoThumbnail) {
        Log.i((String)"renjw", (String)"updateUIRecordingFinished");
        this.mRecordBtnIv.setVisibility(4);
        this.mAcceptBtnIv.setVisibility(0);
        this.mDeclineBtnIv.setVisibility(0);
        this.mThumbnailIv.setVisibility(0);
        this.mRetake.setVisibility(0);
        this.mPreviImgBtnIv.setVisibility(0);
        this.mSurfaceView.setVisibility(8);
        this.mTimeTxt.setVisibility(8);
        this.mVideoView.setVisibility(8);
        this.mExchangeBtnIv.setVisibility(8);
        this.mTopCoverLayout.setVisibility(0);
        Bitmap thumbnail = videoThumbnail;
        if (thumbnail != null) {
            this.mThumbnailIv.setScaleType(ImageView.ScaleType.FIT_CENTER);
            this.mThumbnailIv.setImageBitmap(videoThumbnail);
        }
    }

    public void updateUIVideoPreview(String filepath) {
        Log.i((String)"renjw", (String)"updateUIVideoPreview");
        this.mRecordBtnIv.setVisibility(4);
        this.mAcceptBtnIv.setVisibility(0);
        this.mDeclineBtnIv.setVisibility(0);
        this.mRetake.setVisibility(0);
        this.mThumbnailIv.setVisibility(8);
        this.mPreviImgBtnIv.setVisibility(8);
        this.mSurfaceView.setVisibility(8);
        this.mTimeTxt.setVisibility(8);
        this.mVideoView.setVisibility(0);
        this.mExchangeBtnIv.setVisibility(8);
        this.mTopCoverLayout.setVisibility(8);
        if (filepath != null) {
            Log.e((String)TAG, (String)("\u6587\u4ef6\u8def\u5f84======>" + filepath));
            this.mVideoView.setVideoPath(filepath);
            this.mVideoView.start();
        }
    }

    public void updateUIVideoPreviewFinish() {
        Log.i((String)"renjw", (String)"updateUIVideoPreviewFinish");
        this.mRecordBtnIv.setVisibility(4);
        this.mAcceptBtnIv.setVisibility(0);
        this.mDeclineBtnIv.setVisibility(0);
        this.mThumbnailIv.setVisibility(0);
        this.mPreviImgBtnIv.setVisibility(0);
        this.mRetake.setVisibility(0);
        this.mSurfaceView.setVisibility(8);
        this.mTimeTxt.setVisibility(8);
        this.mVideoView.setVisibility(8);
        this.mExchangeBtnIv.setVisibility(8);
        this.mTopCoverLayout.setVisibility(0);
    }

    public void updateVideoSize(String sizeStr) {
        this.mSizeTv.setText((CharSequence)sizeStr);
    }

    public void startTimerTask() {
        mTimer = new Timer();
        isloop = true;
        num = 0;
        mTimerTask = new TimerTask(){

            @Override
            public void run() {
                Message msg = VideoCaptureView.this.mHandler.obtainMessage(11002);
                if (isloop) {
                    num++;
                    if (num >= 30) {
                        isloop = false;
                    }
                    msg.arg1 = num;
                    msg.sendToTarget();
                } else {
                    num = 0;
                    Log.e((String)"mTimerTask", (String)"\u5012\u8ba1\u65f6\u9519\u8bef===>");
                }
            }
        };
        mTimer.schedule(mTimerTask, 1300L, 1000L);
    }

    protected void handleMsg(Message msg) {
        switch (msg.what) {
            case 11002: {
                this.mTimeTxt.setText((CharSequence)(msg.arg1 + "/30s"));
                this.mDurationTv.setText((CharSequence)(msg.arg1 + "s"));
                break;
            }
        }
    }

    public void stopTimer() {
        if (mTimer != null) {
            mTimer.cancel();
            mTimer = null;
        }
        if (mTimerTask != null) {
            mTimerTask.cancel();
            mTimerTask = null;
        }
    }

    public void onClick(View v) {
        if (this.mRecordingInterface == null) {
            return;
        }
        if (v.getId() == this.mRecordBtnIv.getId()) {
            this.mRecordingInterface.onRecordButtonClicked();
        } else if (v.getId() == this.mAcceptBtnIv.getId()) {
            this.mRecordingInterface.onAcceptButtonClicked();
        } else if (v.getId() == this.mDeclineBtnIv.getId()) {
            this.mRecordingInterface.onDeclineButtonClicked();
        } else if (v.getId() == this.mPreviImgBtnIv.getId()) {
            this.mRecordingInterface.onPreviewButtonClicked();
        } else if (v.getId() == this.mExchangeBtnIv.getId()) {
            this.mRecordingInterface.onExchangewButtonClicked();
        } else if (v.getId() == R.id.videocapture_retake_iv) {
            this.updateUINotRecording();
        }
    }

    public void onCompletion(MediaPlayer mp) {
        this.updateUIVideoPreviewFinish();
    }

    static {
        isloop = true;
        num = 0;
    }
}

