/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.newticketclient.client.common;

import com.alibaba.fastjson.JSONObject;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static Logger m_logger = LoggerFactory.getLogger(Utils.class);
    private static final int MIN_PORT = 1024;
    private static final int MAX_PORT = 65535;

    public static boolean checkString(String param) {
        return param != null && param.length() > 0;
    }

    public static boolean checkStringValue(String param, String regExString) throws PatternSyntaxException {
        Pattern p = Pattern.compile(regExString);
        Matcher m = p.matcher(param);
        return m.matches();
    }

    public static boolean checkPort(int port) {
        return port >= 1024 && port <= 65535;
    }

    public static JSONObject str2Json(long logIndex, String str) {
        String logFlag = "Utils.str2Json";
        try {
            return JSONObject.parseObject((String)str);
        }
        catch (Exception ex) {
            m_logger.warn(String.format("<lid:%d> [%s] exception! String: \n%s\n detail ", logIndex, logFlag, str), (Throwable)ex);
            return null;
        }
    }

    public static int getMin(int firstVal, int secVal) {
        return firstVal > secVal ? secVal : firstVal;
    }

    public static String getHostName(long logIndex) {
        String logFlag = "Utils.getHostName";
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            m_logger.warn("<lid:{}>[{}] exception happened! detail {}", new Object[]{logIndex, logFlag, e});
            return "";
        }
    }

    public static class SendMode {
        public static final int PUSH_WITH_BACKUP = 1;
        public static final int PULL = 2;
        public static final int SWITCH_MOSQUITTO = 3;
        public static final int PUSH_WITHOUT_BACKUP = 4;

        public static boolean checkSendMode(int nMode) {
            return 1 == nMode || 2 == nMode || 3 == nMode || 4 == nMode;
        }
    }
}

