/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.newticketclient.client.start;

import com.xdja.newticketclient.client.common.ReturnValues;
import com.xdja.newticketclient.client.start.NewTicketService;
import com.xdja.newticketclient.rpcstubpool.RpcClientInfo;
import com.xdja.newticketclient.rpcstubpool.RpcStubNewTicketFactory;
import com.xdja.newticketclient.rpcstubpool.RpcStubPool;
import com.xdja.newticketclient.rpcstubpool.RpcStubPoolConfig;
import com.xdja.newticketclient.thrift.datatype.ResBool;
import com.xdja.newticketclient.thrift.datatype.ResStr;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewTicketClient {
    private static Logger logger = LoggerFactory.getLogger(NewTicketClient.class);
    private RpcStubNewTicketFactory rpcfactory = null;
    private RpcStubPool<RpcClientInfo<NewTicketService.Client>> rpcstubpool = null;
    private RpcStubPoolConfig config = new RpcStubPoolConfig();
    private int timeout = 2000;
    private int serverMode = 3;
    private String sHost = "";
    private int sPort = -1;
    public static AtomicLong logIndex = new AtomicLong(0L);

    private String getClassName() {
        return "NewTicketClient";
    }

    public NewTicketClient(String serverHost, int serverPort) {
        this.sHost = serverHost;
        this.sPort = serverPort;
        this.config.setMaxActive(100);
        this.config.setMaxIdle(100);
        this.config.setMaxWait(3000L);
        this.config.setTestWhileIdle(false);
        this.config.setMinEvictableIdleTimeMillis(3600000L);
        this.config.setTestOnBorrow(true);
        this.config.setTestOnReturn(false);
    }

    public NewTicketClient(String serverHost, int serverPort, int serverMode, RpcStubPoolConfig config, int timeout) {
        this.timeout = timeout;
        this.config = config;
        this.serverMode = serverMode;
        this.sHost = serverHost;
        this.sPort = serverPort;
    }

    public boolean init() {
        String logFlag = String.valueOf(this.getClassName()) + ".init";
        logger.info("[lid:{}] [{}] serverHost:{} serverPort:{} serverMode:{}", new Object[]{logIndex.getAndDecrement(), logFlag, this.sHost, this.sPort, this.serverMode});
        this.rpcfactory = new RpcStubNewTicketFactory(this.sHost, this.sPort, this.serverMode, this.timeout);
        this.rpcstubpool = new RpcStubPool();
        if (!this.rpcstubpool.init(logIndex.get(), this.config, (PoolableObjectFactory<RpcClientInfo<NewTicketService.Client>>)this.rpcfactory)) {
            logger.warn("[lid:{}] rpcpool init failed!", (Object)logIndex);
            return false;
        }
        return true;
    }

    public RpcClientInfo<NewTicketService.Client> getServiceClient(long logIndex) {
        String logFlag = String.valueOf(this.getClassName()) + ".getServiceClient";
        RpcClientInfo<NewTicketService.Client> rpcconnect = null;
        try {
            rpcconnect = this.rpcstubpool.getResource(logIndex);
            return rpcconnect;
        }
        catch (Exception e) {
            logger.warn("[lid:{}] [{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcstubpool.returnBrokenResource(logIndex, rpcconnect);
            return null;
        }
    }

    public String createTicket(long logIndex, String caller, String serviceCode, String data) {
        RpcClientInfo<NewTicketService.Client> ci;
        String logFlag;
        block5: {
            logFlag = String.valueOf(this.getClassName()) + ".createTicket";
            logger.debug("[lid:{}] [{}] caller:{}, serviceCode:{}, data:{}", new Object[]{logIndex, logFlag, caller, serviceCode, data});
            ci = null;
            try {
                ci = this.getServiceClient(logIndex);
                if (ci != null) break block5;
                logger.warn("[lid:{}] [{}] id:{} cann't get NewTicket Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            catch (TException e) {
                logger.warn("[lid:{}] [{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
                this.rpcstubpool.returnBrokenResource(logIndex, ci);
                return null;
            }
        }
        ResStr res = ci.getClient().createTicket(logIndex, caller, serviceCode, data, null);
        if (res.res == ReturnValues.SUCCESS) {
            logger.debug("[lid:{}] [{}] result:{}", new Object[]{logIndex, logFlag, res.value});
        } else {
            logger.warn("[lid:{}] [{}] Create Ticket fail!, result:{}", new Object[]{logIndex, logFlag, res.res});
        }
        this.rpcstubpool.returnResource(logIndex, ci);
        return res.value;
    }

    public boolean destoryTicket(long logIndex, String caller, String ticket) {
        RpcClientInfo<NewTicketService.Client> ci;
        String logFlag;
        block5: {
            logFlag = String.valueOf(this.getClassName()) + ".destoryTicket";
            logger.debug("[lid:{}] [{}] caller:{}, ticket:{}", new Object[]{logIndex, logFlag, caller, ticket});
            ci = null;
            try {
                ci = this.getServiceClient(logIndex);
                if (ci != null) break block5;
                logger.warn("[lid:{}] [{}] id:{} cann't get NewTicket Client", (Object)logIndex, (Object)logFlag);
                return false;
            }
            catch (TException e) {
                logger.warn("[lid:{}] [{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
                this.rpcstubpool.returnBrokenResource(logIndex, ci);
                return false;
            }
        }
        ResBool res = ci.getClient().destoryTicket(logIndex, caller, ticket, null);
        if (res.res == ReturnValues.SUCCESS) {
            logger.debug("[lid:{}] [{}] result:{}", new Object[]{logIndex, logFlag, res.value});
        } else {
            logger.warn("[lid:{}] [{}] Destory Ticket fail!, result:{}", new Object[]{logIndex, logFlag, res.res});
        }
        this.rpcstubpool.returnResource(logIndex, ci);
        return res.value;
    }

    public boolean refreshTicket(long logIndex, String caller, String ticket, String serviceCode) {
        RpcClientInfo<NewTicketService.Client> ci;
        String logFlag;
        block5: {
            logFlag = String.valueOf(this.getClassName()) + ".refreshTicket";
            logger.debug("[lid:{}] [{}] caller:{}, ticket:{}, serviceCode:{}", new Object[]{logIndex, logFlag, caller, ticket, serviceCode});
            ci = null;
            try {
                ci = this.getServiceClient(logIndex);
                if (ci != null) break block5;
                logger.warn("[lid:{}] [{}] id:{} cann't get NewTicket Client", (Object)logIndex, (Object)logFlag);
                return false;
            }
            catch (TException e) {
                logger.warn("[lid:{}] [{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
                this.rpcstubpool.returnBrokenResource(logIndex, ci);
                return false;
            }
        }
        ResBool res = ci.getClient().refreshTicket(logIndex, caller, ticket, serviceCode, null);
        if (res.res == ReturnValues.SUCCESS) {
            logger.debug("[lid:{}] [{}] result:{}", new Object[]{logIndex, logFlag, res.value});
        } else {
            logger.warn("[lid:{}] [{}] Refresh ticket fail!, result:{}", new Object[]{logIndex, logFlag, res.res});
        }
        this.rpcstubpool.returnResource(logIndex, ci);
        return res.value;
    }

    public String getTicketInfo(long logIndex, String caller, String ticket) {
        RpcClientInfo<NewTicketService.Client> ci;
        String logFlag;
        block5: {
            logFlag = String.valueOf(this.getClassName()) + ".getTicketInfo";
            logger.debug("[lid:{}] [{}] caller:{}, ticket:{}", new Object[]{logIndex, logFlag, caller, ticket});
            ci = null;
            try {
                ci = this.getServiceClient(logIndex);
                if (ci != null) break block5;
                logger.warn("[lid:{}] [{}] id:{} cann't get NewTicket Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            catch (TException e) {
                logger.warn("[lid:{}] [{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
                this.rpcstubpool.returnBrokenResource(logIndex, ci);
                return null;
            }
        }
        ResStr res = ci.getClient().getTicketInfo(logIndex, caller, ticket, null);
        if (res.res == ReturnValues.SUCCESS) {
            logger.debug("[lid:{}] [{}] result:{}", new Object[]{logIndex, logFlag, res.value});
        } else {
            logger.warn("[lid:{}] [{}] Get Ticket Info fail!, result:{}", new Object[]{logIndex, logFlag, res.res});
        }
        this.rpcstubpool.returnResource(logIndex, ci);
        return res.value;
    }

    public String echo(long logIndex, String caller, String srcStr) {
        RpcClientInfo<NewTicketService.Client> ci;
        String logFlag;
        block5: {
            logFlag = String.valueOf(this.getClassName()) + ".echo";
            logger.debug("[lid:{}] [{}] caller:{}, srcStr:{}", new Object[]{logIndex, logFlag, caller, srcStr});
            ci = null;
            try {
                ci = this.getServiceClient(logIndex);
                if (ci != null) break block5;
                logger.warn("[lid:{}] [{}] id:{} cann't get NewTicket Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            catch (TException e) {
                logger.warn("[lid:{}] [{}] exception happened while echo(caller:{}, srcStr:{}})  exception detailed:{}...", new Object[]{logIndex, logFlag, caller, srcStr, e});
                this.rpcstubpool.returnBrokenResource(logIndex, ci);
                return null;
            }
        }
        ResStr res = ci.getClient().echo(logIndex, caller, srcStr, null);
        if (res.res == ReturnValues.SUCCESS) {
            logger.debug("[lid:{}] [{}] success! result:{}", new Object[]{logIndex, logFlag, res.value});
        } else {
            logger.warn("[lid:{}] [{}] get echo failed! result:{}", new Object[]{logIndex, logFlag, res.res});
        }
        this.rpcstubpool.returnResource(logIndex, ci);
        return res.value;
    }

    public void shutDown() {
        String logFlag = String.valueOf(this.getClassName()) + ".shutDown";
        if (this.rpcstubpool == null) {
            return;
        }
        try {
            this.rpcstubpool.destroy(logIndex.getAndDecrement());
            this.rpcstubpool = null;
        }
        catch (Exception ex) {
            logger.error("[lid:{}] [{}] exception happened while shutting down rpcstubpool...", (Object)logIndex.get(), (Object)logFlag);
        }
    }
}

