/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.newticketclient.client.start;

import com.alibaba.fastjson.JSONObject;
import com.xdja.newticketclient.client.common.Utils;
import com.xdja.newticketclient.client.start.NewTicketClient;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewTicketClientTest {
    private static Logger logger = LoggerFactory.getLogger(NewTicketClient.class);
    private static final String THRIFT_HOST = "11.12.112.215";
    private static final int THRIFT_PORT = 9810;
    int serverMode = 3;
    private long logIndex = -1L;
    private NewTicketClient newTicketClient = null;

    public boolean init() {
        String logFlag = "NewTicketClientTest.init";
        logger.debug("[lid:{}] [{}] serverHost:{} serverPort:{} serverMode:{}", new Object[]{-1, logFlag, THRIFT_HOST, 9810, this.serverMode});
        this.newTicketClient = new NewTicketClient(THRIFT_HOST, 9810);
        return this.newTicketClient.init();
    }

    @Test
    public void test_init() {
        String logFlag = "NewTicketClientTest.test_init";
        logger.debug("[lid:{}] [{}] serverHost:{} serverPort:{} serverMode:{}", new Object[]{-1, logFlag, THRIFT_HOST, 9810, this.serverMode});
        this.newTicketClient = new NewTicketClient(THRIFT_HOST, 9810);
        Assert.assertTrue((boolean)this.newTicketClient.init());
    }

    @Test
    public void test_echo() {
        String logFlag = "NewTicketClientTest.test_echo";
        if (!this.init()) {
            logger.warn("[lid:{}] [{}] init fail!", (Object)this.logIndex, (Object)logFlag);
        }
        String returnStr = this.newTicketClient.echo(this.logIndex, "test_caller", "test echo string");
        System.out.println("echo: " + returnStr);
        Assert.assertTrue((returnStr.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_createTicket() {
        String logFlag = "NewTicketClientTest.test_createTicket";
        if (!this.init()) {
            logger.warn("[lid:{}] [{}] init fail!", (Object)this.logIndex, (Object)logFlag);
        }
        String ticketInfo = this.newTicketClient.createTicket(this.logIndex, "tester", "app_id1", "sn111112222211111");
        System.out.println("ticketInfo: " + ticketInfo);
        Assert.assertTrue((ticketInfo.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_destoryTicket() {
        String logFlag = "NewTicketClientTest.test_destoryTicket";
        if (!this.init()) {
            logger.warn("[lid:{}] [{}] init fail!", (Object)this.logIndex, (Object)logFlag);
        }
        String ticketInfo = this.newTicketClient.createTicket(this.logIndex, "tester", "app_id2", "sn111112222211112");
        JSONObject jsonObject = new JSONObject();
        jsonObject = Utils.str2Json(this.logIndex, ticketInfo);
        String ticket = jsonObject.getString("ticket");
        boolean isTrue = this.newTicketClient.destoryTicket(this.logIndex, "tester", ticket);
        System.out.println("ticket:" + ticket + " | isTrue: " + isTrue);
        Assert.assertTrue((boolean)isTrue);
    }

    @Test
    public void test_refreshTicket() {
        String logFlag = "NewTicketClientTest.test_refreshTicket";
        if (!this.init()) {
            logger.warn("[lid:{}] [{}] init fail!", (Object)this.logIndex, (Object)logFlag);
        }
        String ticketInfo = this.newTicketClient.createTicket(this.logIndex, "tester", "app_id3", "sn111112222211112");
        JSONObject jsonObject = new JSONObject();
        jsonObject = Utils.str2Json(this.logIndex, ticketInfo);
        String ticket = jsonObject.getString("ticket");
        boolean isTrue = this.newTicketClient.refreshTicket(this.logIndex, logFlag, ticket, "sn123");
        System.out.println("ticket:" + ticket + " | isTrue: " + isTrue);
        Assert.assertTrue((boolean)isTrue);
    }

    @Test
    public void test_getTicketInfo() {
        String logFlag = "NewTicketClientTest.test_getTicketInfo";
        if (!this.init()) {
            logger.warn("[lid:{}] [{}] init fail!", (Object)this.logIndex, (Object)logFlag);
        }
        String ticketInfo = this.newTicketClient.createTicket(this.logIndex, "tester", "app_id4", "sn111112222211112");
        JSONObject jsonObject = new JSONObject();
        jsonObject = Utils.str2Json(this.logIndex, ticketInfo);
        String ticket = jsonObject.getString("ticket");
        String ticketInfo1 = this.newTicketClient.getTicketInfo(this.logIndex, "tester", ticket);
        System.out.println("ticketInfo1: " + ticketInfo1);
        Assert.assertTrue((ticketInfo1.length() > 0 ? 1 : 0) != 0);
    }
}

