/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cache.retrofit.generator;

import android.content.Context;
import com.xdja.cache.common.interceptor.CacheInterceptor;
import com.xdja.cache.common.utils.SdUtils;
import java.io.File;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class RetrofitCacheGenerator {
    private Retrofit.Builder builder;
    private static OkHttpClient client = null;
    private static Context mContext;

    public RetrofitCacheGenerator() {
        this.initOkHttp();
        this.initRetrofit();
    }

    public static void init(Context context) {
        mContext = context.getApplicationContext();
    }

    private void initRetrofit() {
        this.builder = new Retrofit.Builder().baseUrl("https://api.github.com").client(client).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create());
    }

    public <S> S createService(Class<S> serviceClass) {
        Retrofit retrofit = this.builder.build();
        return (S)retrofit.create(serviceClass);
    }

    private void initOkHttp() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        File cacheFile = new File(SdUtils.getDiskCacheDir((Context)mContext));
        Cache cache = new Cache(cacheFile, 0x3200000L);
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        builder.cache(cache).addInterceptor((Interceptor)loggingInterceptor).addInterceptor((Interceptor)new CacheInterceptor());
        builder.connectTimeout(15L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).retryOnConnectionFailure(true);
        client = builder.build();
    }
}

