/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cache.retrofit.interceptor;

import android.support.annotation.NonNull;
import android.util.Log;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RetryIntercepter
implements Interceptor {
    public int maxRetry;
    private static String TAG = "RetryIntercepter";

    public RetryIntercepter(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long t1 = System.nanoTime();
        Log.i((String)"RetryIntercepter", (String)String.format("Sending request %s on %s%n%s", request.url(), chain.connection(), request.headers()));
        Response response = chain.proceed(request);
        long t2 = System.nanoTime();
        Log.i((String)"RetryIntercepter", (String)String.format("Received response for %s in %.1fms%n%s", response.request().url(), (double)(t2 - t1) / 1000000.0, response.headers()));
        for (int tryCount = 0; !response.isSuccessful() && tryCount < this.maxRetry; ++tryCount) {
            response = chain.proceed(request);
        }
        return response;
    }
}

