/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xdja.pams.common.data.RequestBean;
import com.xdja.pams.common.data.RequestData;
import com.xdja.pams.common.data.RequestDataList;
import com.xdja.pams.common.data.RequestDataMap;
import com.xdja.pams.common.data.RequestDataObject;
import com.xdja.pams.util.JsonParserUtils;
import java.util.HashMap;

public class RequestParserUtils {
    public static RequestBean toRequestBean(String json) {
        RequestBean data = new RequestBean();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(json).getAsJsonObject();
        data.setAction(jsonObject.get("action").getAsString());
        data.setKey(jsonObject.get("key").getAsString());
        JsonElement element = jsonObject.get("rows");
        if (element != null) {
            data.setRows(element.toString());
        }
        data.setContent(json);
        return data;
    }

    public static <T> RequestData<T> fromJson(String json, Class<T> clazz) {
        RequestData<T> data = new RequestData<T>();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(json).getAsJsonObject();
        JsonElement dataJson = jsonObject.get("rows");
        if (dataJson == null) {
            RequestDataObject dataObject = new RequestDataObject();
            dataObject.setAction(jsonObject.get("action").getAsString());
            dataObject.setKey(jsonObject.get("key").getAsString());
            data.setDataObject(dataObject);
            return data;
        }
        if (dataJson.isJsonArray()) {
            RequestDataList<T> list = RequestParserUtils.fromJsonList(json, clazz);
            data.setList(true);
            data.setDataList(list);
        } else if (dataJson.isJsonObject()) {
            RequestDataObject<T> object = RequestParserUtils.fromJsonObject(json, clazz);
            data.setDataObject(object);
        }
        return data;
    }

    public static RequestDataMap fromJsonToMap(String json) {
        RequestData<HashMap> data = RequestParserUtils.fromJson(json, HashMap.class);
        return new RequestDataMap(data);
    }

    public static <T> RequestDataList<T> fromJsonList(String json, Class<T> clazz) {
        return (RequestDataList)JsonParserUtils.fromJson(json, RequestDataList.class, clazz);
    }

    public static <T> RequestDataObject<T> fromJsonObject(String json, Class<T> clazz) {
        return (RequestDataObject)JsonParserUtils.fromJson(json, RequestDataObject.class, clazz);
    }

    public static <T> String toJson(Object json, Class<T> clazz, boolean isList) {
        if (isList) {
            return RequestParserUtils.toJsonList(json, clazz);
        }
        return RequestParserUtils.toJsonObject(json, clazz);
    }

    public static <T> String toJson(RequestData<T> json, Class<T> clazz) {
        if (json.isList()) {
            return RequestParserUtils.toJsonList(json.getDataList(), clazz);
        }
        return RequestParserUtils.toJsonObject(json.getDataObject(), clazz);
    }

    public static <T> String toJsonList(Object json, Class<T> clazz) {
        return JsonParserUtils.toJson(json, RequestDataList.class, clazz);
    }

    public static <T> String toJsonObject(Object json, Class<T> clazz) {
        return JsonParserUtils.toJson(json, RequestDataObject.class, clazz);
    }
}

