/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.http;

import com.xdja.pams.common.data.ResponseBean;
import com.xdja.pams.common.data.ResponseData;
import com.xdja.pams.common.util.Response;
import com.xdja.pams.common.util.ResponseParserUtils;
import com.xdja.pams.exception.CommonException;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseApi {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseApi.class);

    public static void write(HttpServletResponse response, Response result) {
        String json = ResponseApi.toJson(result);
        ResponseApi.writeJson(response, json);
    }

    public static String toJson(Response response) {
        ResponseData responseData = response.build();
        return ResponseParserUtils.toJson(responseData, response.getDataType());
    }

    public static void writeJson(HttpServletResponse response, String text) {
        response.setContentType("application/json;charset=UTF-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        try {
            LOG.info("result:  " + text);
            response.getWriter().write(text);
            response.getWriter().flush();
            response.getWriter().close();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            new CommonException(-1, "\u65e0\u6cd5\u5199\u5165\u6570\u636e", e);
        }
    }

    public static ResponseBean toResponseBean(String json) {
        return ResponseParserUtils.toResponseBean(json);
    }
}

