/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.util;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class JsonParserUtils {
    private static String[] SKIP_FIELDS = new String[0];

    public static Gson gson() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").registerTypeAdapter(String.class, (Object)new StringNullAdapter()).setExclusionStrategies(new ExclusionStrategy[]{new FieldExclusionStrategy()}).create();
    }

    public static <T> Object fromJson(String json, Class<?> container, Class<T> clazz) {
        Gson gson = JsonParserUtils.gson();
        ParameterizedType objectType = JsonParserUtils.type(container, clazz);
        return gson.fromJson(json, (Type)objectType);
    }

    public static <T> String toJson(Object json, Class<?> container, Class<T> clazz) {
        Gson gson = JsonParserUtils.gson();
        ParameterizedType objectType = JsonParserUtils.type(container, clazz);
        return gson.toJson(json, (Type)objectType);
    }

    private static ParameterizedType type(final Class<?> raw, final Type ... args) {
        return new ParameterizedType(){

            @Override
            public Type getRawType() {
                return raw;
            }

            @Override
            public Type[] getActualTypeArguments() {
                return args;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    public static class FieldExclusionStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipField(FieldAttributes f) {
            for (String skipField : SKIP_FIELDS) {
                if (!skipField.equals(f.getName())) continue;
                return true;
            }
            return false;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }

    public static class StringNullAdapter
    extends TypeAdapter<String> {
        public String read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return "";
            }
            return reader.nextString();
        }

        public void write(JsonWriter writer, String value) throws IOException {
            if (value == null) {
                writer.value("");
                return;
            }
            writer.value(value);
        }
    }
}

