/*
 * Decompiled with CFR 0.152.
 */
package pams.function.common.util;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static ObjectMapper mapper = new ObjectMapper();

    public static String toJsonStr(Object value) {
        try {
            return mapper.writeValueAsString(value);
        }
        catch (JsonGenerationException e) {
            log.error(e.getMessage());
        }
        catch (JsonMappingException e) {
            log.error(e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return "";
    }

    public static <T> T readValue(String context, Class<T> valueType) {
        try {
            return (T)mapper.readValue(context, valueType);
        }
        catch (JsonParseException e) {
            log.error(e.getMessage());
        }
        catch (JsonMappingException e) {
            log.error(e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return null;
    }

    public static <T> T readValue(String context, Class<?> collectionClass, Class<?> ... elementCLasses) {
        try {
            return (T)mapper.readValue(context, JsonUtils.getCollectionJavaType(collectionClass, elementCLasses));
        }
        catch (Exception e) {
            log.error("\u8f6c\u5316json\u5b57\u7b26\u4e32\u4e3a\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private static JavaType getCollectionJavaType(Class<?> collectionClass, Class<?> ... elementCLasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementCLasses);
    }
}

