/*
 * Decompiled with CFR 0.152.
 */
package pams.function.gls.controller;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.gls.bean.AdditionLocationInfoBean;
import pams.function.gls.bean.LocationQueryBean;
import pams.function.gls.service.LocationInfoService;

@Controller
@Scope(value="session")
public class LocationInfoController
extends BaseControler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocationInfoController.class);
    @Autowired
    private LocationInfoService locationInfoService;

    @RequestMapping(value={"/gls/locationInfo/index.do"})
    public String toIndex(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            LOGGER.error("\u8df3\u8f6c\u5230\u4f4d\u7f6e\u4fe1\u606f\u9875\u9762\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        return sendUrl;
    }

    @RequestMapping(value={"/gls/locationInfo/detail.do"})
    public String toDetail(String type) {
        if ("detail".equals(type)) {
            return "gls/default/detail";
        }
        return "gls/default/addition";
    }

    @RequestMapping(value={"/gls/locationInfo/query.do"})
    public void queryLocationInfo(LocationQueryBean bean, HttpServletResponse response) {
        try {
            Map<String, Object> map = this.locationInfoService.pageLocationInfos(bean);
            map.put("flag", "1");
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u4f4d\u7f6e\u5217\u8868\u5f02\u5e38:{}", (Object)e.getMessage());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("total", 0);
            map.put("rows", new ArrayList());
            map.put("flag", "0");
            map.put("msg", e.getMessage());
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
        }
    }

    @RequestMapping(value={"/gls/locationInfo/add.do"})
    public void addLocation(String id1, String id2, Integer num, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flag", true);
        try {
            if (Strings.isEmpty((String)id1) || Strings.isEmpty((String)id2) || num == null) {
                throw new Exception("\u53c2\u6570\u5f02\u5e38");
            }
            AdditionLocationInfoBean bean = new AdditionLocationInfoBean();
            bean.setStartLocationInfoId(id1);
            bean.setEndLocationInfoId(id2);
            bean.setNum(num);
            this.locationInfoService.addLocation(bean);
        }
        catch (Exception e) {
            LOGGER.error("\u4f4d\u7f6e\u4fe1\u606f\u8865\u507f\u5931\u8d25:{}", (Object)e.getMessage());
            map.put("flag", false);
            map.put("msg", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }
}

