/*
 * Decompiled with CFR 0.152.
 */
package pams.function.guangzhou.port.control;

import com.xdja.agreement.config.SystemConfig;
import com.xdja.pams.common.util.FastDfsUtils;
import com.xdja.pams.syms.service.SystemConfigService;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import pams.function.guangzhou.common.control.CommonControl;
import pams.function.guangzhou.port.service.FileService;

@Controller
@Scope(value="session")
public class FileControl
extends CommonControl {
    @Autowired
    private FileService fileService;
    @Autowired
    private FastDfsUtils fastDfsUtils;
    @Autowired
    private SystemConfigService systemConfigService;
    private static Logger log = LoggerFactory.getLogger(FileControl.class);

    @RequestMapping(value={"/port/portControl/uploadFile.do"})
    public void uploadFile(HttpServletRequest request, HttpServletResponse response, @RequestParam MultipartFile multipartFile) {
        if (multipartFile == null) {
            log.error("\u4e0a\u4f20\u7684\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            super.writeResponseBeanWrong(response, log, "\u4e0a\u4f20\u7684\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        String attachmentId = null;
        if ("0".equals(SystemConfig.getInstance().getString("cluster.switch"))) {
            InputStream inputStream = null;
            try {
                inputStream = multipartFile.getInputStream();
            }
            catch (IOException e) {
                log.error("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u7684\u8f93\u5165\u6d41\u5931\u8d25", (Throwable)e);
                super.writeResponseBeanWrong(response, log, "\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u7684\u8f93\u5165\u6d41\u5931\u8d25");
                return;
            }
            try {
                attachmentId = this.fileService.uplaodFile(inputStream, multipartFile.getOriginalFilename());
            }
            catch (Exception e) {
                super.writeResponseBeanWrong(response, log, e.getMessage());
                return;
            }
        }
        try {
            attachmentId = this.fastDfsUtils.uploadToFASTDFS(multipartFile.getBytes(), multipartFile.getOriginalFilename());
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5230fastdfs\u5931\u8d25", (Throwable)e);
            super.writeResponseBeanWrong(response, log, "\u4e0a\u4f20\u6587\u4ef6\u5230fastdfs\u5931\u8d25");
            return;
        }
        log.debug("\u4e0a\u4f20\u6587\u4ef6\u6210\u529f, attachmentId:{}", (Object)attachmentId);
        super.writeResponseBeanSuccess(response, log, attachmentId);
    }

    @RequestMapping(value={"/port/portControl/downloadFile.do"})
    public void downloadFile(HttpServletRequest request, HttpServletResponse response, String attachmentId) {
        if (StringUtils.isBlank((CharSequence)attachmentId)) {
            super.writeResponseBeanWrong(response, log, "attachmentId\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        try {
            this.fileService.downlaodFile(response, attachmentId);
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,attachmentId:" + attachmentId, (Throwable)e);
            super.writeResponseBeanWrong(response, log, "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25:" + e.getMessage());
        }
    }
}

