/*
 * Decompiled with CFR 0.152.
 */
package pams.function.guangzhou.port.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import pams.function.guangzhou.port.bean.PortInfoBean;
import pams.function.guangzhou.port.bean.QueryApplyBean;
import pams.function.guangzhou.port.bean.QueryPortBean;
import pams.function.guangzhou.port.bean.RolePerson;
import pams.function.guangzhou.port.dao.PortDao;
import pams.function.guangzhou.port.entity.ApplyInfo;
import pams.function.guangzhou.port.entity.AttachmentInfo;
import pams.function.guangzhou.port.entity.PortInfo;

@Repository
public class PortDaoImpl
implements PortDao {
    @Autowired
    private BaseDao baseDao;
    private static Logger log = LoggerFactory.getLogger(PortDaoImpl.class);

    @Override
    public ApplyInfo getApplyInfo(String applyId) {
        return (ApplyInfo)this.baseDao.getObjectById(ApplyInfo.class, (Serializable)((Object)applyId));
    }

    @Override
    public String addApplyInfo(ApplyInfo applyInfo) {
        return (String)this.baseDao.create((Object)applyInfo);
    }

    @Override
    public void updateApplyInfo(ApplyInfo applyInfo) {
        this.baseDao.update((Object)applyInfo);
    }

    @Override
    public void deleteApplyInfo(ApplyInfo applyInfo) {
        this.baseDao.delete((Object)applyInfo);
    }

    @Override
    public String addAttachmentInfo(AttachmentInfo attachmentInfo) {
        return (String)this.baseDao.create((Object)attachmentInfo);
    }

    @Override
    public void updateAttachmentInfo(AttachmentInfo attachmentInfo) {
        this.baseDao.update((Object)attachmentInfo);
    }

    @Override
    public AttachmentInfo getAttachmentInfo(String attachmentId) {
        return (AttachmentInfo)this.baseDao.getObjectById(AttachmentInfo.class, (Serializable)((Object)attachmentId));
    }

    @Override
    public void deleteAttachmentInfoByApplyId(String applyId) {
        String hql = "delete t_port_attachment where apply_id = ?";
        Object[] values = new Object[]{applyId};
        this.baseDao.updateBySql(hql, values);
    }

    @Override
    public List<AttachmentInfo> queryAttachmentInfoList(String applyId) {
        String hql = "from AttachmentInfo where applyId = ?";
        Object[] values = new Object[]{applyId};
        return this.baseDao.getListByHQL(hql, values);
    }

    @Override
    public String addPortInfo(PortInfo portInfo) {
        return (String)this.baseDao.create((Object)portInfo);
    }

    @Override
    public void updatePortInfo(PortInfo portInfo) {
        this.baseDao.update((Object)portInfo);
    }

    @Override
    public void deletePortInfoByApplyId(String applyId) {
        String hql = "delete t_port_info where apply_id = ?";
        Object[] values = new Object[]{applyId};
        this.baseDao.updateBySql(hql, values);
    }

    @Override
    public List<PortInfo> queryPortInfoList(String applyId) {
        String hql = "from PortInfo where applyId = ?";
        Object[] values = new Object[]{applyId};
        return this.baseDao.getListByHQL(hql, values);
    }

    @Override
    public List<ApplyInfo> queryApplyInfoList(QueryApplyBean queryApplyBean, Page page) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        StringBuffer hql = new StringBuffer("from ApplyInfo where 1 = 1 ");
        if (StringUtils.isNotBlank((CharSequence)queryApplyBean.getAppName())) {
            hql.append(" and appName like CONCAT('%',?,'%')");
            valueList.add(queryApplyBean.getAppName());
        }
        if (queryApplyBean.getAppType() != null) {
            hql.append(" and appType = ?");
            valueList.add(queryApplyBean.getAppType());
        }
        if (StringUtils.isNotBlank((CharSequence)queryApplyBean.getFactory())) {
            hql.append(" and factory like CONCAT('%',?,'%')");
            valueList.add(queryApplyBean.getFactory());
        }
        if (StringUtils.isNotBlank((CharSequence)queryApplyBean.getPersonName())) {
            hql.append(" and personName like CONCAT('%',?,'%')");
            valueList.add(queryApplyBean.getPersonName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryApplyBean.getDepName())) {
            hql.append(" and depName like CONCAT('%',?,'%')");
            valueList.add(queryApplyBean.getDepName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryApplyBean.getCity())) {
            hql.append(" and city like CONCAT('%',?,'%')");
            valueList.add(queryApplyBean.getCity());
        }
        if (queryApplyBean.getAuditStatus() != null) {
            hql.append(" and auditStatus = ?");
            valueList.add(queryApplyBean.getAuditStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)queryApplyBean.getCreatorId())) {
            hql.append(" and creatorId = ?");
            valueList.add(queryApplyBean.getCreatorId());
        }
        if (StringUtils.isNotBlank((CharSequence)queryApplyBean.getApplyBeginDate())) {
            Date applyBeginDate = null;
            try {
                applyBeginDate = DateUtils.parseDate((String)queryApplyBean.getApplyBeginDate(), (String[])new String[]{"yyyy-MM-dd"});
            }
            catch (ParseException e) {
                applyBeginDate = null;
                log.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef,\u65e5\u671f:{}", (Object)queryApplyBean.getApplyBeginDate());
            }
            if (applyBeginDate != null) {
                hql.append(" and applyTime >= ?");
                valueList.add(applyBeginDate.getTime());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)queryApplyBean.getApplyEndDate())) {
            Date applyEndDate = null;
            try {
                applyEndDate = DateUtils.parseDate((String)queryApplyBean.getApplyEndDate(), (String[])new String[]{"yyyy-MM-dd"});
                applyEndDate = DateUtils.addDays((Date)applyEndDate, (int)1);
            }
            catch (ParseException e) {
                applyEndDate = null;
                log.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef,\u65e5\u671f:{}", (Object)queryApplyBean.getApplyEndDate());
            }
            if (applyEndDate != null) {
                hql.append(" and applyTime < ?");
                valueList.add(applyEndDate.getTime());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)queryApplyBean.getAuditBeginDate())) {
            Date auditBeginDate = null;
            try {
                auditBeginDate = DateUtils.parseDate((String)queryApplyBean.getAuditBeginDate(), (String[])new String[]{"yyyy-MM-dd"});
            }
            catch (ParseException e) {
                auditBeginDate = null;
                log.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef,\u65e5\u671f:{}", (Object)queryApplyBean.getAuditBeginDate());
            }
            if (auditBeginDate != null) {
                hql.append(" and auditTime >= ?");
                valueList.add(auditBeginDate.getTime());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)queryApplyBean.getAuditEndDate())) {
            Date auditEndDate = null;
            try {
                auditEndDate = DateUtils.parseDate((String)queryApplyBean.getAuditEndDate(), (String[])new String[]{"yyyy-MM-dd"});
                auditEndDate = DateUtils.addDays((Date)auditEndDate, (int)1);
            }
            catch (ParseException e) {
                auditEndDate = null;
                log.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef,\u65e5\u671f:{}", (Object)queryApplyBean.getAuditEndDate());
            }
            if (auditEndDate != null) {
                hql.append(" and auditTime < ?");
                valueList.add(auditEndDate.getTime());
            }
        }
        String countHql = " select count(applyId) " + hql.toString();
        hql.append(" order by applyTime desc");
        return this.baseDao.getListByHQL(countHql, hql.toString(), valueList.toArray(), page);
    }

    @Override
    public List<PortInfoBean> queryPortInfoBeanList(QueryPortBean queryPortBean, Page page) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        StringBuffer hql = new StringBuffer("from ApplyInfo a, PortInfo p where a.applyId = p.applyId ");
        if (StringUtils.isNotBlank((CharSequence)queryPortBean.getAppName())) {
            hql.append(" and a.appName like CONCAT('%',?,'%')");
            valueList.add(queryPortBean.getAppName());
        }
        if (queryPortBean.getAppType() != null) {
            hql.append(" and a.appType = ?");
            valueList.add(queryPortBean.getAppType());
        }
        if (StringUtils.isNotBlank((CharSequence)queryPortBean.getProtocol())) {
            hql.append(" and p.protocol = ?");
            valueList.add(queryPortBean.getProtocol());
        }
        if (StringUtils.isNotBlank((CharSequence)queryPortBean.getIp())) {
            hql.append(" and p.ip like CONCAT('%',?,'%')");
            valueList.add(queryPortBean.getIp());
        }
        if (StringUtils.isNotBlank((CharSequence)queryPortBean.getPort())) {
            hql.append(" and p.port like CONCAT('%',?,'%')");
            valueList.add(queryPortBean.getPort());
        }
        if (StringUtils.isNotBlank((CharSequence)queryPortBean.getMapIp())) {
            hql.append(" and p.mapIp like CONCAT('%',?,'%')");
            valueList.add(queryPortBean.getMapIp());
        }
        if (StringUtils.isNotBlank((CharSequence)queryPortBean.getMapPort())) {
            hql.append(" and p.mapPort like CONCAT('%',?,'%')");
            valueList.add(queryPortBean.getMapPort());
        }
        if (StringUtils.isNotBlank((CharSequence)queryPortBean.getCity())) {
            hql.append(" and a.city like CONCAT('%',?,'%')");
            valueList.add(queryPortBean.getCity());
        }
        if (StringUtils.isNotBlank((CharSequence)queryPortBean.getCreatorId())) {
            hql.append(" and a.creatorId = ? ");
            valueList.add(queryPortBean.getCreatorId());
        }
        if (StringUtils.isNotBlank((CharSequence)queryPortBean.getApplyBeginDate())) {
            Date applyBeginDate = null;
            try {
                applyBeginDate = DateUtils.parseDate((String)queryPortBean.getApplyBeginDate(), (String[])new String[]{"yyyy-MM-dd"});
            }
            catch (ParseException e) {
                applyBeginDate = null;
                log.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef,\u65e5\u671f:{}", (Object)queryPortBean.getApplyBeginDate());
            }
            if (applyBeginDate != null) {
                hql.append(" and a.applyTime >= ?");
                valueList.add(applyBeginDate.getTime());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)queryPortBean.getApplyEndDate())) {
            Date applyEndDate = null;
            try {
                applyEndDate = DateUtils.parseDate((String)queryPortBean.getApplyEndDate(), (String[])new String[]{"yyyy-MM-dd"});
                applyEndDate = DateUtils.addDays((Date)applyEndDate, (int)1);
            }
            catch (ParseException e) {
                applyEndDate = null;
                log.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef,\u65e5\u671f:{}", (Object)queryPortBean.getApplyEndDate());
            }
            if (applyEndDate != null) {
                hql.append(" and a.applyTime < ?");
                valueList.add(applyEndDate.getTime());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)queryPortBean.getAuditBeginDate())) {
            Date auditBeginDate = null;
            try {
                auditBeginDate = DateUtils.parseDate((String)queryPortBean.getAuditBeginDate(), (String[])new String[]{"yyyy-MM-dd"});
            }
            catch (ParseException e) {
                auditBeginDate = null;
                log.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef,\u65e5\u671f:{}", (Object)queryPortBean.getAuditBeginDate());
            }
            if (auditBeginDate != null) {
                hql.append(" and a.auditTime >= ?");
                valueList.add(auditBeginDate.getTime());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)queryPortBean.getAuditEndDate())) {
            Date auditEndDate = null;
            try {
                auditEndDate = DateUtils.parseDate((String)queryPortBean.getAuditEndDate(), (String[])new String[]{"yyyy-MM-dd"});
                auditEndDate = DateUtils.addDays((Date)auditEndDate, (int)1);
            }
            catch (ParseException e) {
                auditEndDate = null;
                log.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef,\u65e5\u671f:{}", (Object)queryPortBean.getAuditEndDate());
            }
            if (auditEndDate != null) {
                hql.append(" and a.auditTime < ?");
                valueList.add(auditEndDate.getTime());
            }
        }
        String countHql = " select count(p.portId) " + hql.toString();
        hql.append(" order by a.applyTime desc");
        List resultList = this.baseDao.getListByHQL(countHql, hql.toString(), valueList.toArray(), page);
        ArrayList<PortInfoBean> portInfoBeanList = new ArrayList<PortInfoBean>();
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return portInfoBeanList;
        }
        for (Object object : resultList) {
            Object[] objectArray = (Object[])object;
            ApplyInfo applyInfo = (ApplyInfo)objectArray[0];
            PortInfo portInfo = (PortInfo)objectArray[1];
            PortInfoBean portInfoBean = new PortInfoBean();
            BeanUtils.copyProperties((Object)portInfo, (Object)portInfoBean);
            BeanUtils.copyProperties((Object)applyInfo, (Object)portInfoBean);
            portInfoBeanList.add(portInfoBean);
        }
        return portInfoBeanList;
    }

    @Override
    public List<RolePerson> getRolePersonList(String personId) {
        String sql = "select sys_role_id \"roleId\", person_id \"personId\" from t_upms_person_role where person_id = ?";
        return this.baseDao.getListBySQL(sql, (Object[])new String[]{personId}, RolePerson.class);
    }
}

