/*
 * Decompiled with CFR 0.152.
 */
package pams.function.guangzhou.port.service.impl;

import com.xdja.agreement.config.SystemConfig;
import com.xdja.pams.common.util.FastDfsUtils;
import com.xdja.pams.syms.service.SystemConfigService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Date;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.guangzhou.common.exception.GuangzhouException;
import pams.function.guangzhou.port.dao.PortDao;
import pams.function.guangzhou.port.entity.AttachmentInfo;
import pams.function.guangzhou.port.service.FileService;

@Service
public class FileServiceImpl
implements FileService {
    @Autowired
    private PortDao portDao;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private FastDfsUtils fastDfsUtils;
    private static Logger log = LoggerFactory.getLogger(FileServiceImpl.class);

    @Override
    public String uplaodFile(InputStream inputStream, String fileName) throws IOException, GuangzhouException {
        String portFilePath = this.getPortFilePath();
        String date = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
        String datePath = portFilePath + File.separator + date;
        File datePathFile = new File(datePath);
        if (!datePathFile.exists() || !datePathFile.isDirectory()) {
            datePathFile.mkdir();
        }
        String uuid = UUID.randomUUID().toString();
        String fullPath = datePath + File.separator + uuid;
        int pos = fileName.lastIndexOf(".");
        if (pos > 0 && pos < fileName.length() - 1) {
            String fileExtName = fileName.substring(pos + 1, fileName.length());
            fullPath = fullPath + "." + fileExtName;
        }
        log.debug("\u4e0a\u4f20\u6587\u4ef6\u4fdd\u5b58\u7684\u7edd\u5bf9\u8def\u5f84\u4e3a\uff1a{}", (Object)fullPath);
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)new File(fullPath));
        return date + "_" + uuid;
    }

    @Override
    public String getPortFilePath() throws GuangzhouException {
        String portFilePath = this.systemConfigService.getValueByCode("PORT_AUDIT_FILE_PATH");
        log.debug("\u7aef\u53e3\u5ba1\u6279\u6587\u4ef6\u76ee\u5f55\u4e3a:{}", (Object)portFilePath);
        if (StringUtils.isBlank((CharSequence)portFilePath)) {
            log.error("\u7aef\u53e3\u5ba1\u6279\u6587\u4ef6\u76ee\u5f55\u672a\u5728\u6570\u636e\u5e93\u4e2d\u6709\u6548\u914d\u7f6e");
            throw new GuangzhouException("\u7aef\u53e3\u5ba1\u6279\u6587\u4ef6\u76ee\u5f55\u672a\u5728\u6570\u636e\u5e93\u4e2d\u6709\u6548\u914d\u7f6e");
        }
        File portFile = new File(portFilePath);
        if (!portFile.exists()) {
            log.error("\u7aef\u53e3\u5ba1\u6279\u6587\u4ef6\u76ee\u5f55\u5728\u670d\u52a1\u7aef\u4e2d\u4e0d\u5b58\u5728:{}", (Object)portFilePath);
            throw new GuangzhouException("\u7aef\u53e3\u5ba1\u6279\u6587\u4ef6\u76ee\u5f55\u5728\u670d\u52a1\u7aef\u4e2d\u4e0d\u5b58\u5728");
        }
        return portFilePath;
    }

    @Override
    public void downlaodFile(HttpServletResponse response, String attachmentId) throws Exception {
        AttachmentInfo attachmentInfo = this.portDao.getAttachmentInfo(attachmentId);
        if (attachmentInfo == null) {
            log.error("\u6570\u636e\u5e93\u4e2d\u67e5\u627e\u4e0d\u5230\u9644\u4ef6\u4fe1\u606f\u3002attachmentId:{}", (Object)attachmentId);
            throw new GuangzhouException("\u6570\u636e\u5e93\u4e2d\u67e5\u627e\u4e0d\u5230\u9644\u4ef6\u4fe1\u606f");
        }
        if ("0".equals(SystemConfig.getInstance().getString("cluster.switch"))) {
            String portFilePath = this.getPortFilePath();
            String[] attachmentIdArray = attachmentId.split("_");
            String fullFilePath = portFilePath + File.separator + attachmentIdArray[0] + File.separator + attachmentIdArray[1];
            int pos = attachmentInfo.getAttachmentName().lastIndexOf(".");
            if (pos > 0 && pos < attachmentInfo.getAttachmentName().length() - 1) {
                String fileExtName = attachmentInfo.getAttachmentName().substring(pos + 1, attachmentInfo.getAttachmentName().length());
                fullFilePath = fullFilePath + "." + fileExtName;
            }
            log.debug("\u5f85\u4e0b\u8f7d\u7684\u6587\u4ef6\u8def\u5f84\u4e3a:{}", (Object)fullFilePath);
            File fullFile = new File(fullFilePath);
            if (!fullFile.exists()) {
                log.error("\u5f85\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728:{}", (Object)fullFilePath);
                throw new GuangzhouException("\u5f85\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            response.setContentType("application/octet-stream;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(attachmentInfo.getAttachmentName(), "UTF-8"));
            FileInputStream inputStream = new FileInputStream(fullFile);
            byte[] buffer = new byte[4096];
            ServletOutputStream outputStream = response.getOutputStream();
            boolean endFlag = false;
            while (!endFlag) {
                int length = ((InputStream)inputStream).read(buffer);
                if (length != -1) {
                    outputStream.write(buffer, 0, length);
                    continue;
                }
                endFlag = true;
            }
        } else {
            byte[] bytes = this.fastDfsUtils.downloadFromFASTDFS(attachmentId);
            response.setContentType("application/octet-stream;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(attachmentInfo.getAttachmentName(), "UTF-8"));
            response.getOutputStream().write(bytes);
        }
    }
}

