/*
 * Decompiled with CFR 0.152.
 */
package pams.function.lasa.controller;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.token.TokenFactory;
import com.xdja.pams.common.util.CookieUtils;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.upms.service.UserPowerService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.lasa.service.TokenCheckService;

@Controller
@Scope(value="session")
public class LasaLoginController
extends BaseControler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LasaLoginController.class);
    @Autowired
    private UserPowerService userPowerService;
    @Autowired
    private TokenCheckService tokenCheckService;
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private UserManageService userManage;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private TokenFactory tokenFactory;

    @RequestMapping(value={"/LasaLoginController/toLsCheckLogin.do"})
    public String toCheckToken(String serverip, String token, ModelMap modelMap) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u7b2c\u4e09\u65b9\u53c2\u6570serverip:{}, token:{}", (Object)serverip, (Object)token);
        }
        modelMap.addAttribute("serverIp", (Object)serverip);
        modelMap.addAttribute("token", (Object)token);
        return "lasa/default/login_redirect";
    }

    @RequestMapping(value={"/LasaLoginController/lsCheckLogin.do"})
    public void checkToken(String serverip, String token, HttpServletRequest request, HttpServletResponse response) {
        ReturnResult rtnResult = new ReturnResult();
        Map<String, Object> map = this.tokenCheckService.checkToken(serverip, token);
        Person person = (Person)map.get("p");
        int operateResult = 1;
        String sendUrl = "/error/error";
        if (person == null) {
            LOGGER.info("\u9a8c\u8bc1\u5931\u8d25,\u8df3\u8f6c\u5230\u767b\u5f55\u9875");
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg((String)map.get("msg"));
            sendUrl = "/login/loginControler/toLoginPage.do";
        } else {
            Map mapPower = this.userPowerService.queryPersonRoleList(person.getId());
            if (mapPower == null) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"login.error.msg.power"));
                operateResult = 0;
                LOGGER.info("\u8be5\u4eba\u5458\u6ca1\u6709\u6743\u9650, \u8df3\u8f6c\u5230\u5f02\u5e38\u9875\u9762");
            } else {
                String key;
                person.setLoginErrorTimes(0);
                this.userManage.updateUserNotUpdateLastupdatetime(person);
                Operator operator = new Operator();
                operator.setPerson(person);
                operator.setLoginIp(Util.getRemortIP((HttpServletRequest)request));
                operator.setTopFunctions(mapPower);
                this.setControls(person, operator);
                if ("1".equals(this.systemConfigPbService.getValueByCode("isOtherLogin"))) {
                    key = (String)this.tokenFactory.getOperator().get(person.getId());
                    this.tokenFactory.getOperator().invalidate(person.getId());
                    if (StringUtils.isNotBlank((CharSequence)key)) {
                        this.tokenFactory.getOperator().invalidate(key);
                    }
                }
                CookieUtils.removeCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"operator");
                key = this.tokenFactory.getOperator().add((Object)operator);
                this.tokenFactory.getOperator().add(person.getId(), key);
                CookieUtils.addCookie((HttpServletResponse)response, (String)"operator", (Object)key);
                sendUrl = "/login/loginControler/index.do";
            }
            this.systemLogService.saveLoginLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), Util.getRemortIP((HttpServletRequest)request), Integer.valueOf(operateResult), "", "", "");
        }
        rtnResult.setUrl(sendUrl);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }
}

