/*
 * Decompiled with CFR 0.152.
 */
package pams.function.lkyw.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pams.function.lkyw.bean.ClhcParamBean;
import pams.function.lkyw.bean.RyhcParamBean;
import pams.function.lkyw.bean.XlrzParamBean;
import pams.function.lkyw.dao.LkywDao;
import pams.function.lkyw.entity.Clhc;
import pams.function.lkyw.entity.CljcHc;
import pams.function.lkyw.entity.CljcHcWj;
import pams.function.lkyw.entity.CljcKc;
import pams.function.lkyw.entity.CljcKcWj;
import pams.function.lkyw.entity.Czrz;
import pams.function.lkyw.entity.Ryhc;
import pams.function.lkyw.entity.Xlrz;
import pams.function.lkyw.entity.XlrzWj;

@Repository
public class LkywDaoImpl
implements LkywDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(LkywDaoImpl.class);
    @Autowired
    private BaseDao baseDao;

    @Override
    public List<Clhc> listClhc(ClhcParamBean param, Page page) {
        try {
            StringBuilder sb = new StringBuilder();
            ArrayList<Object> list = new ArrayList<Object>();
            sb.append(" from T_LKYW_CLHC cl ").append(" left join T_LKYW_CLJC_HC hc on cl.ID = hc.CLHC_ID ").append(" left join T_LKYW_CLJC_KC kc on cl.ID = kc.CLHC_ID ");
            sb.append(" where 1=1 ");
            if (Strings.isNotEmpty((String)param.getCphm())) {
                sb.append(" and cl.CPHM = ? ");
                list.add(param.getCphm());
            }
            if (Strings.isNotEmpty((String)param.getSyxz())) {
                sb.append(" and cl.SYXZ = ?");
                list.add(param.getSyxz());
            }
            if (Strings.isNotEmpty((String)param.getHcrq())) {
                Date s = Util.parseDate((String)(param.getHcrq() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
                Date e = Util.parseDate((String)(param.getHcrq() + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
                sb.append(" and cl.CJSJ >= ?").append(" and cl.CJSJ <= ?");
                list.add(s.getTime());
                list.add(e.getTime());
            }
            if (Strings.isNotEmpty((String)param.getHcjg())) {
                sb.append(" and cl.HCJG = ?");
                list.add(param.getHcjg());
            }
            if (Strings.isNotEmpty((String)param.getZqjj())) {
                sb.append(" and JYXM like ?");
                list.add("%" + param.getZqjj() + "%");
            }
            if ("1".equals(param.getIslv())) {
                sb.append(" and kc.SFLYC = '1'");
            }
            if ("1".equals(param.getIsxy())) {
                sb.append(" and (hc.SFXYCL = '1' or kc.SFXYCL = '1')");
            }
            sb.append(" order by cl.CJSJ desc ");
            String sql = sb.toString();
            String count = "select count(cl.ID) " + sql;
            StringBuilder filed = new StringBuilder();
            filed.append("cl.ID as \"id\",");
            filed.append("cl.CPHM as \"cphm\",");
            filed.append("cl.HPZL as \"hpzl\",");
            filed.append("cl.CLLX as \"cllx\",");
            filed.append("cl.SYXZ as \"syxz\",");
            filed.append("cl.CLPP as \"clpp\",");
            filed.append("cl.CCDJRQ as \"ccdjrq\",");
            filed.append("cl.WFCS as \"wfcs\",");
            filed.append("cl.CLZT as \"clzt\",");
            filed.append("cl.YQWJY as \"yqwjy\",");
            filed.append("cl.YQWBF as \"yqwbf\",");
            filed.append("cl.WFWCL as \"wfwcl\",");
            filed.append("cl.FZJG as \"fzjg\",");
            filed.append("cl.SYR as \"syr\",");
            filed.append("cl.LXDH as \"lxdh\",");
            filed.append("cl.LXDZ as \"lxdz\",");
            filed.append("cl.JYHM as \"jyhm\",");
            filed.append("cl.JYXM as \"jyxm\",");
            filed.append("cl.HCJG as \"hcjg\",");
            filed.append("cl.CLJCZT as \"cljczt\",");
            filed.append("cl.RYHCZT as \"ryhczt\",");
            filed.append("cl.CJSJ as \"cjsj\",");
            filed.append("cl.HCDD as \"hcdd\", ");
            filed.append("cl.HCLX as \"hclx\" ");
            String select = "select " + filed.toString() + sql;
            List r = this.baseDao.getListBySQL(count, select, list.toArray(new Object[list.size()]), page, Clhc.class);
            return r == null || r.isEmpty() ? new ArrayList() : r;
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Throwable)e);
            } else {
                LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
            }
            return new ArrayList<Clhc>();
        }
    }

    @Override
    public List<Ryhc> listRyhc(RyhcParamBean param, Page page) {
        try {
            StringBuilder sb = new StringBuilder();
            ArrayList<Object> list = new ArrayList<Object>();
            sb.append(" from T_LKYW_RYHC ry, T_LKYW_CLHC cl").append(" where ry.CLHZ_ID = cl.ID");
            if (Strings.isNotEmpty((String)param.getName())) {
                sb.append(" and ry.XM like ?");
                list.add("%" + param.getName() + "%");
            }
            if (Strings.isNotEmpty((String)param.getHcjg())) {
                sb.append(" and ry.HCJG = ?");
                list.add(param.getHcjg());
            }
            if ("1".equals(param.getIsxy())) {
                sb.append(" and ry.SFXYR = '1'");
            }
            if (Strings.isNotEmpty((String)param.getIdNo())) {
                sb.append(" and ry.JSZH like ? ");
                list.add("%" + param.getIdNo() + "%");
            }
            if (Strings.isNotEmpty((String)param.getZqjj())) {
                sb.append(" and cl.JYXM like ?");
                list.add("%" + param.getZqjj() + "%");
            }
            if (Strings.isNotEmpty((String)param.getHcrq())) {
                Date s = Util.parseDate((String)(param.getHcrq() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
                Date e = Util.parseDate((String)(param.getHcrq() + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
                sb.append(" and cl.CJSJ >= ?").append(" and cl.CJSJ <= ?");
                list.add(s.getTime());
                list.add(e.getTime());
            }
            sb.append(" order by ry.CJSJ desc ");
            String sql = sb.toString();
            String count = "select count(ry.ID) " + sql;
            String select = "select ry.* " + sql;
            List r = this.baseDao.getListBySQL(count, select, list.toArray(new Object[list.size()]), page, Ryhc.class);
            return r == null || r.isEmpty() ? new ArrayList() : r;
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Throwable)e);
            } else {
                LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
            }
            return new ArrayList<Ryhc>();
        }
    }

    @Override
    public List<Xlrz> listXlrz(XlrzParamBean param, Page page) {
        try {
            StringBuilder sb = new StringBuilder();
            ArrayList<Object> list = new ArrayList<Object>();
            sb.append(" from T_LKYW_XLRZ xl, t_person p, t_person pp  ").append(" where xl.PERSON_CODE = p.code and pp.code = xl.companion");
            if (Strings.isNotEmpty((String)param.getZqjj())) {
                sb.append(" and p.name like ?");
                list.add("%" + param.getZqjj() + "%");
            }
            if (Strings.isNotEmpty((String)param.getJcbh())) {
                sb.append(" and xl.CAR_NO like ?");
                list.add("%" + param.getJcbh() + "%");
            }
            if (Strings.isNotEmpty((String)param.getTqqk())) {
                sb.append(" and xl.WEATHER = ?");
                list.add(param.getTqqk());
            }
            if (Strings.isNotEmpty((String)param.getJtgz())) {
                sb.append(" and xl.TRAFFIC_CONTROL = ?");
                list.add(param.getJtgz());
            }
            if (Strings.isNotEmpty((String)param.getSbwz())) {
                sb.append(" and xl.REPORT_POSITION like ?");
                list.add("%" + param.getSbwz() + "%");
            }
            if (Strings.isNotEmpty((String)param.getSbrq())) {
                Date s = Util.parseDate((String)(param.getSbrq() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
                Date e = Util.parseDate((String)(param.getSbrq() + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
                sb.append(" and xl.CREATE_TIMESTAMP >= ?").append(" and xl.CREATE_TIMESTAMP <= ?");
                list.add(s.getTime());
                list.add(e.getTime());
            }
            String sql = sb.toString();
            String count = "select count(xl.ID) " + sql;
            StringBuilder filed = new StringBuilder();
            filed.append("xl.ID,");
            filed.append("xl.PERSON_CODE,");
            filed.append("xl.CAR_NO,");
            filed.append("xl.BEGIN_TIMESTAMP,");
            filed.append("xl.END_TIMESTAMP,");
            filed.append("xl.COMPANION,");
            filed.append("xl.WEATHER,");
            filed.append("xl.TRAFFIC_FLOW,");
            filed.append("xl.TRAFFIC_CONTROL,");
            filed.append("xl.DESCRIPTION,");
            filed.append("xl.REPORT_POSITION,");
            filed.append("xl.CREATE_TIMESTAMP,");
            String select = "select xl.* " + sql;
            List r = this.baseDao.getListBySQL(count, select, list.toArray(new Object[list.size()]), page, Xlrz.class);
            return r == null || r.isEmpty() ? new ArrayList() : r;
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Throwable)e);
            } else {
                LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
            }
            return new ArrayList<Xlrz>();
        }
    }

    @Override
    public List<XlrzWj> listXlrzWj(String xlrzId) {
        String hql = "from XlrzWj where xlrzId = ?";
        List list = this.baseDao.getListByHQL(hql, new Object[]{xlrzId});
        return list == null || list.isEmpty() ? new ArrayList() : list;
    }

    @Override
    public List<Czrz> listCzrz(String code, String name, String time, Page page) {
        try {
            StringBuilder sb = new StringBuilder();
            ArrayList<Object> list = new ArrayList<Object>();
            sb.append(" from T_LKYW_CZRZ cz where 1=1");
            if (Strings.isNotEmpty((String)code)) {
                sb.append(" and cz.JH = ?");
                list.add(code);
            }
            if (Strings.isNotEmpty((String)name)) {
                sb.append(" and cz.XM like ?");
                list.add("%" + name + "%");
            }
            if (Strings.isNotEmpty((String)time)) {
                Date s = Util.parseDate((String)(time + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
                Date e = Util.parseDate((String)(time + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
                sb.append(" and cz.CJSJ >= ?").append(" and cz.CJSJ <= ?");
                list.add(s.getTime());
                list.add(e.getTime());
            }
            String sql = sb.toString();
            String count = "select count(cz.ID) " + sql;
            StringBuilder filed = new StringBuilder();
            filed.append("cz.ID as \"id\",");
            filed.append("cz.JH as \"jh\",");
            filed.append("cz.XM as \"xm\",");
            filed.append("cz.DWMC as \"dwmc\",");
            filed.append("cz.YYMC as \"yymc\",");
            filed.append("cz.CZLX as \"czlx\",");
            filed.append("cz.CZJG as \"czjg\",");
            filed.append("cz.CJSJ as \"cjsj\" ");
            String select = "select " + filed.toString() + sql;
            List r = this.baseDao.getListBySQL(count, select, list.toArray(new Object[list.size()]), page, Czrz.class);
            return r == null || r.isEmpty() ? new ArrayList() : r;
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Throwable)e);
            } else {
                LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
            }
            return new ArrayList<Czrz>();
        }
    }

    @Override
    public Clhc getById(String id) {
        Object object = this.baseDao.getObjectById(Clhc.class, (Serializable)((Object)id));
        return object == null ? null : (Clhc)object;
    }

    @Override
    public Ryhc detailRyhc(String id) {
        Object o = this.baseDao.getObjectById(Ryhc.class, (Serializable)((Object)id));
        return o == null ? null : (Ryhc)o;
    }

    @Override
    public CljcHc getjchc(String hcid) {
        String hql = "from CljcHc where clhcId = ?";
        Object o = this.baseDao.getObjectByHQL(hql, new Object[]{hcid});
        return o == null ? null : (CljcHc)o;
    }

    @Override
    public List<CljcHcWj> getjchcwj(String jcid) {
        String hql = "from CljcHcWj where cljcId = ? order by pxzd";
        List list = this.baseDao.getListByHQL(hql, new Object[]{jcid});
        return list == null || list.isEmpty() ? new ArrayList() : list;
    }

    @Override
    public CljcKc getjckc(String hcid) {
        String hql = "from CljcKc where clhcId = ?";
        Object o = this.baseDao.getObjectByHQL(hql, new Object[]{hcid});
        return o == null ? null : (CljcKc)o;
    }

    @Override
    public List<CljcKcWj> getjckcwj(String jcid) {
        String hql = "from CljcKcWj where cljcId = ? order by pxzd";
        List list = this.baseDao.getListByHQL(hql, new Object[]{jcid});
        return list == null || list.isEmpty() ? new ArrayList() : list;
    }

    @Override
    public Ryhc getryhc(String clhcid) {
        String hql = "from Ryhc where clhzId = ?";
        Object o = this.baseDao.getObjectByHQL(hql, new Object[]{clhcid});
        return o == null ? null : (Ryhc)o;
    }
}

