/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.auxiliaryPolicer.control;

import com.xdja.pams.auxiliaryPolicer.bean.AuilibaryPolicerModel;
import com.xdja.pams.auxiliaryPolicer.bean.AuxiliaryPolicerRequestParam;
import com.xdja.pams.auxiliaryPolicer.bean.LockReqeustParam;
import com.xdja.pams.auxiliaryPolicer.bean.ResultData;
import com.xdja.pams.auxiliaryPolicer.bean.ResultMsg;
import com.xdja.pams.auxiliaryPolicer.service.AuxilibaryPolicerService;
import com.xdja.pams.auxiliaryPolicer.util.AuxiUtil;
import com.xdja.pams.auxiliaryPolicer.util.RtnUtil;
import com.xdja.pams.bims.bean.QueryPersonBean;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.util.Base64Encrypt;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.service.DevicePbService;
import com.xdja.pams.scms.service.TerminalReportService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"bims/AuxiliaryPolicerController"})
@Scope(value="session")
public class AuxilibaryPolicerControl
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(AuxilibaryPolicerControl.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private AuxilibaryPolicerService auxilibaryPolicerService;
    @Autowired
    private TerminalReportService terminalReportService;
    @Autowired
    private DevicePbService deviceService;
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    private static final String COMMERRMSG = "\u7cfb\u7edf\u5f02\u5e38";

    @RequestMapping(value={"save.do"}, method={RequestMethod.POST})
    public void addAuxilibaryPolicer(AuilibaryPolicerModel personModel, HttpServletRequest request, HttpServletResponse response) {
        ResultMsg resultMsg;
        String rtnMsg = "";
        boolean isSuccess = false;
        List<ResultData> rtnDataList = null;
        ArrayList<QueryPersonBean> qPersonList = new ArrayList<QueryPersonBean>();
        try {
            String jsonStr = AuxiUtil.readJsonStrFromRequest(request);
            Base64Encrypt base64Encrypt = new Base64Encrypt();
            jsonStr = base64Encrypt.getFromBASE64(jsonStr);
            log.debug("==>\u8bf7\u6c42\u53c2\u6570:{}", (Object)jsonStr);
            List<AuxiliaryPolicerRequestParam> auxiliaryPolicerRequestParamsList = AuxiUtil.parseToList(jsonStr, AuxiliaryPolicerRequestParam.class);
            List<AuxiliaryPolicerRequestParam> personList = null;
            if (personModel == null && (auxiliaryPolicerRequestParamsList == null || auxiliaryPolicerRequestParamsList.size() < 1)) {
                log.info("\u8bf7\u6c42\u6570\u636e\u4e3a\u7a7a");
                rtnMsg = MessageManager.getProMessage(this.message, "common.message.operate.fail");
                throw new RuntimeException(rtnMsg);
            }
            if (personModel != null) {
                personList = personModel.getPersonList();
            }
            if (personList == null || personList.size() < 1) {
                personList = auxiliaryPolicerRequestParamsList;
            }
            if (personList == null || personList.size() < 1) {
                log.info("\u8bf7\u6c42\u6570\u636e\u4e3a\u7a7a");
                rtnMsg = MessageManager.getProMessage(this.message, "common.message.operate.fail");
            } else {
                for (AuxiliaryPolicerRequestParam auxp : personList) {
                    String errorMsg = AuxiUtil.isParamLegal(auxp);
                    if (errorMsg != null) {
                        throw new RuntimeException(errorMsg);
                    }
                    if (auxp.getMobile() == null) {
                        rtnMsg = MessageManager.getProMessage(this.message, "common.message.operate.fail");
                        isSuccess = false;
                        break;
                    }
                    String tmp = this.userManageService.checkMobileIsExist(auxp.getMobile().split(","));
                    if (null != tmp) {
                        rtnMsg = MessageManager.getProMessage(this.message, "bims.person.error.msg.mobile", new String[]{tmp});
                        isSuccess = false;
                        break;
                    }
                    if (this.userManageService.checkCode(auxp.getCode())) {
                        rtnMsg = MessageManager.getProMessage(this.message, "bims.person.error.msg.code");
                        isSuccess = false;
                        break;
                    }
                    if (this.userManageService.checkIdentifer(auxp.getIdentifier())) {
                        rtnMsg = MessageManager.getProMessage(this.message, "bims.person.error.msg.identifier");
                        isSuccess = false;
                        break;
                    }
                    isSuccess = true;
                    qPersonList.add(auxp.toPersonBean());
                }
                if (isSuccess) {
                    rtnDataList = this.auxilibaryPolicerService.addAuxilibaryPolicer(qPersonList);
                    if (rtnDataList == null || rtnDataList.size() < 1) {
                        rtnMsg = MessageManager.getProMessage(this.message, "common.message.operate.fail");
                        isSuccess = false;
                    } else {
                        rtnMsg = MessageManager.getProMessage(this.message, "common.message.operate.success");
                    }
                }
            }
            resultMsg = isSuccess ? RtnUtil.success(rtnMsg, null, rtnDataList) : RtnUtil.fail(rtnMsg);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            resultMsg = RtnUtil.error(Util.varCheckEmp(errorMsg) ? COMMERRMSG : errorMsg);
        }
        Util.writeUtf8JSON(response, resultMsg.toJsonString());
    }

    @RequestMapping(value={"update.do"}, method={RequestMethod.POST, RequestMethod.PUT})
    public void editAuxilibaryPolicer(AuxiliaryPolicerRequestParam param, HttpServletRequest request, HttpServletResponse response) {
        ResultMsg resultMsg;
        String rtnMsg = "";
        boolean isSuccess = false;
        try {
            String jsonStr = AuxiUtil.readJsonStrFromRequest(request);
            Base64Encrypt base64Encrypt = new Base64Encrypt();
            jsonStr = base64Encrypt.getFromBASE64(jsonStr);
            log.debug("==>\u8bf7\u6c42\u53c2\u6570:{}", (Object)jsonStr);
            AuxiliaryPolicerRequestParam paramJson = AuxiUtil.parseToObject(jsonStr, AuxiliaryPolicerRequestParam.class);
            if (param == null && paramJson == null) {
                log.info("\u4fee\u6539\u6570\u636e\u4e3a\u7a7a");
                rtnMsg = MessageManager.getProMessage(this.message, "common.message.operate.fail");
            } else {
                String errorMsg;
                if (param == null || Util.varCheckEmp(param.getDepId())) {
                    param = paramJson;
                }
                if ((errorMsg = AuxiUtil.isParamLegal(param)) != null) {
                    throw new RuntimeException(errorMsg);
                }
                QueryPersonBean personBean = param.toPersonBean();
                if (personBean.getMobile() == null || Util.varCheckEmp(personBean.getMobile())) {
                    rtnMsg = "\u8bf7\u8f93\u5165\u624b\u673a\u53f7";
                } else {
                    String[] mobiles = param.getMobile().split(",");
                    String tmp = null;
                    ArrayList<Mobile> mobileList = new ArrayList<Mobile>();
                    HashMap<String, String> mMap = new HashMap<String, String>();
                    for (String m : mobiles) {
                        if (Util.varCheckEmp(m)) continue;
                        if (mMap.get(m) != null) {
                            tmp = m;
                            break;
                        }
                        mMap.put(m, m);
                        Mobile tmpMobile = this.userManageService.getMobile(m);
                        if (tmpMobile != null && !personBean.getId().equals(tmpMobile.getPerson().getId())) {
                            tmp = m;
                            break;
                        }
                        if (tmpMobile == null) {
                            tmpMobile = new Mobile();
                            tmpMobile.setMobile(m);
                        }
                        mobileList.add(tmpMobile);
                    }
                    if (tmp != null) {
                        rtnMsg = MessageManager.getProMessage(this.message, "bims.person.error.msg.mobile", new String[]{tmp});
                    } else if (this.userManageService.checkCode(personBean.getCode(), personBean.getId())) {
                        rtnMsg = MessageManager.getProMessage(this.message, "bims.person.error.msg.code");
                    } else if (this.userManageService.checkIdentifer(personBean.getIdentifier(), personBean.getId())) {
                        rtnMsg = MessageManager.getProMessage(this.message, "bims.person.error.msg.identifier");
                    } else {
                        Person oldPerson = this.userManageService.queryPersonById(param.getId());
                        if (oldPerson == null) {
                            throw new Exception("\u8be5\u8b66\u5458\u4e0d\u5b58\u5728");
                        }
                        boolean isReportLog = false;
                        if (this.terminalReportService.judgeIsReportForPerson(personBean, oldPerson)) {
                            isReportLog = true;
                        }
                        List<Mobile> oldMobileList = oldPerson.getMobiledList();
                        String canNotDelMobiles = "";
                        for (Mobile mobile : oldMobileList) {
                            List<Device> devices = this.deviceService.getByMobile(mobile.getMobile());
                            if (personBean.getMobile().contains(mobile.getMobile()) || devices == null || devices.size() <= 0) continue;
                            canNotDelMobiles = canNotDelMobiles + mobile.getMobile() + ",";
                        }
                        if (!"".equals(canNotDelMobiles)) {
                            canNotDelMobiles = canNotDelMobiles.substring(0, canNotDelMobiles.length() - 1);
                            rtnMsg = "\u4e0b\u9762\u7684\u5df2\u7533\u8bf7\u8fc7\u5361\u7684\u624b\u673a\u53f7\u4e0d\u53ef\u5220\u9664\uff1a" + canNotDelMobiles;
                        } else {
                            personBean.setMobiledList(mobileList);
                            personBean.setPersonType("2");
                            this.auxilibaryPolicerService.updataAuxilibarayPolicer(personBean);
                            this.userManageService.deleteNoPersonMobile();
                            if (isReportLog) {
                                this.terminalReportService.saveAndReportLogForEdit(personBean);
                            }
                            rtnMsg = MessageManager.getProMessage(this.message, "common.message.operate.success");
                            isSuccess = true;
                        }
                    }
                }
            }
            resultMsg = isSuccess ? RtnUtil.success(rtnMsg, null, null) : RtnUtil.fail(rtnMsg);
        }
        catch (Exception e) {
            resultMsg = RtnUtil.error(e.getMessage());
        }
        Util.writeUtf8JSON(response, resultMsg.toJsonString());
    }

    @RequestMapping(value={"del.do"}, method={RequestMethod.DELETE, RequestMethod.POST})
    public void deleteAuxilibaryPolicer(@RequestParam(value="id", required=false) String id, HttpServletRequest request, HttpServletResponse response) {
        String rtnMsg = "";
        boolean isSuccess = false;
        ResultMsg resultMsg = null;
        try {
            String jsonStr = AuxiUtil.readJsonStrFromRequest(request);
            log.debug("==>\u8bf7\u6c42\u53c2\u6570:{}", (Object)jsonStr);
            String idJson = jsonStr.trim();
            if (Util.varCheckEmp(id) && Util.varCheckEmp(id = idJson)) {
                rtnMsg = MessageManager.getProMessage(this.message, "common.message.operate.fail");
            } else if (!this.userManageService.checkdelete(id)) {
                String cardStates = this.systemConfigPbService.getValueByCode("can_not_delete_state");
                String[] cardStateArr = cardStates.split(",");
                String stateName = "";
                for (String state : cardStateArr) {
                    CommonCode code = this.commonCodePbService.getByCode(state, "2001");
                    if (code == null) continue;
                    stateName = stateName + code.getName() + ",";
                }
                stateName = stateName.endsWith(",") ? stateName.substring(0, stateName.length() - 1) : stateName;
                rtnMsg = MessageManager.getProMessage(this.message, "bims.person.error.msg.cannotdelete1", new String[]{stateName});
            } else {
                this.userManageService.delete(id);
                this.userManageService.deleteNoPersonMobile();
                rtnMsg = MessageManager.getProMessage(this.message, "common.message.operate.success");
                isSuccess = true;
            }
            resultMsg = isSuccess ? RtnUtil.success(rtnMsg, null, null) : RtnUtil.fail(rtnMsg);
        }
        catch (NullPointerException ne) {
            resultMsg = RtnUtil.error("\u5220\u9664\u5931\u8d25");
        }
        catch (Exception e) {
            String msg = e.getMessage();
            resultMsg = RtnUtil.error(Util.varCheckEmp(msg) ? "\u5220\u9664\u5931\u8d25" : msg);
        }
        Util.writeUtf8JSON(response, resultMsg.toJsonString());
    }

    @RequestMapping(value={"lock.do"}, method={RequestMethod.PUT, RequestMethod.POST})
    public void lockAuxilibaryPolicer(LockReqeustParam param, HttpServletRequest request, HttpServletResponse response) {
        ResultMsg resultMsg;
        boolean isSuccess = false;
        try {
            String rtnMsg;
            String jsonStr = AuxiUtil.readJsonStrFromRequest(request);
            log.debug("==>\u8bf7\u6c42\u53c2\u6570:{}", (Object)jsonStr);
            LockReqeustParam paramJson = AuxiUtil.parseToObject(jsonStr, LockReqeustParam.class);
            if (param == null || Util.varCheckEmp(param.getId())) {
                param = paramJson;
            }
            if (param == null) {
                throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            }
            String lockState = param.getLockState();
            String ids = param.getId();
            if (!AuxiUtil.isLegalLockStat(lockState)) {
                throw new RuntimeException("\u9501\u5b9a\u72b6\u6001\u4e0d\u5408\u6cd5");
            }
            if (Util.varCheckEmp(ids)) {
                rtnMsg = MessageManager.getProMessage(this.message, "common.message.operate.fail");
            } else {
                this.auxilibaryPolicerService.changeLockStatus(Arrays.asList(ids.split(",")), lockState);
                rtnMsg = MessageManager.getProMessage(this.message, "common.message.operate.success");
                isSuccess = true;
            }
            resultMsg = isSuccess ? RtnUtil.success(rtnMsg, null, null) : RtnUtil.fail(rtnMsg);
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            resultMsg = RtnUtil.error(Util.varCheckEmp(errMsg) ? COMMERRMSG : errMsg);
        }
        Util.writeUtf8JSON(response, resultMsg.toJsonString());
    }
}

