/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.auxiliaryPolicer.service.impl;

import com.xdja.pams.auxiliaryPolicer.bean.ResultData;
import com.xdja.pams.auxiliaryPolicer.service.AuxilibaryPolicerService;
import com.xdja.pams.bims.bean.QueryPersonBean;
import com.xdja.pams.bims.dao.PersonDao;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.entity.PersonUpdated;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.bims.util.BimsUtil;
import com.xdja.pams.common.util.Md5PwdEncoder;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.PinYin4j;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.upms.entity.Role;
import com.xdja.pams.upms.service.SysRoleService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuxilibaryPolicerServiceImpl
implements AuxilibaryPolicerService {
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DepManageService depService;
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private PersonDao personDao;

    @Override
    @Transactional
    public List<ResultData> addAuxilibaryPolicer(List<QueryPersonBean> policers) {
        if (policers == null || policers.size() < 1) {
            return null;
        }
        ArrayList<ResultData> rtnList = new ArrayList<ResultData>(policers.size());
        for (QueryPersonBean qPerson : policers) {
            qPerson.setPersonType("2");
            qPerson.setCreatorId("0");
            Person p = this.getPerson(qPerson);
            String id = this.personDao.addPerson(p);
            ResultData data = new ResultData();
            data.setCode(p.getCode());
            data.setId(p.getId());
            if (StringUtils.isNotEmpty((String)id)) {
                data.setFlag("0");
                data.setMessage(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                data.setFlag("1");
                data.setMessage(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
            rtnList.add(data);
        }
        return rtnList;
    }

    @Override
    @Transactional
    public boolean updataAuxilibarayPolicer(QueryPersonBean personBean) {
        Person oldInfo = this.personDao.queryPersonById(personBean.getId());
        PersonUpdated personUpdated = new PersonUpdated();
        personUpdated.setCode(oldInfo.getCode());
        personUpdated.setName(oldInfo.getName());
        personUpdated.setIdentifier(oldInfo.getIdentifier());
        personUpdated.setDepName(oldInfo.getDepartment().getName());
        personUpdated.setDepCode(oldInfo.getDepartment().getCode());
        personUpdated.setDepartmnetId(oldInfo.getDepartment().getId());
        personUpdated.setEditorId("0");
        personUpdated.setMobile(oldInfo.getMobile());
        personUpdated.setOrderField(oldInfo.getOrderField());
        personUpdated.setPersonId(oldInfo.getId());
        personUpdated.setPosition(oldInfo.getPosition());
        personUpdated.setSex(oldInfo.getSex());
        personUpdated.setPersonType(oldInfo.getPersonType());
        personUpdated.setMobileMultimediaMessage(oldInfo.getMobileMultimediaMessage());
        personUpdated.setMobilePersonal(oldInfo.getMobilePersonal());
        oldInfo.getPersonUpdatedList().add(personUpdated);
        oldInfo.setName(personBean.getName());
        oldInfo.setCode(personBean.getCode());
        oldInfo.setIdentifier(personBean.getIdentifier());
        oldInfo.setSex(personBean.getSex());
        oldInfo.setPosition(personBean.getPosition());
        oldInfo.setPolice(personBean.getPolice());
        oldInfo.setOfficePhone(personBean.getOfficePhone());
        oldInfo.setMobile(personBean.getMobile());
        oldInfo.setMobiledList(personBean.getMobiledList());
        oldInfo.setDepartment(this.depService.queryDepById(personBean.getDepId()));
        oldInfo.setPersonState(personBean.getPersonState() == null ? oldInfo.getPersonState() : personBean.getPersonState());
        oldInfo.setDisplayState(personBean.getDisplayState() == null ? oldInfo.getDisplayState() : personBean.getDisplayState());
        oldInfo.setLeaderLevel(personBean.getLeaderLevel() == null ? oldInfo.getLeaderLevel() : personBean.getLeaderLevel());
        oldInfo.setPersonType(personBean.getPersonType() == null ? oldInfo.getPersonType() : personBean.getPersonType());
        oldInfo.setMobileMultimediaMessage(personBean.getMobileMultimediaMessage() == null ? oldInfo.getMobileMultimediaMessage() : personBean.getMobileMultimediaMessage());
        oldInfo.setMobilePersonal(personBean.getMobilePersonal() == null ? oldInfo.getMobilePersonal() : personBean.getMobilePersonal());
        oldInfo.setDepCode(oldInfo.getDepartment().getCode());
        oldInfo.setTimestamp(System.currentTimeMillis());
        oldInfo.setNameBriefSpell(PinYin4j.getNameSimplicityWithPolyphone(oldInfo.getName()));
        oldInfo.setCommType(personBean.getCommType() == null ? oldInfo.getCommType() : personBean.getCommType());
        oldInfo.setRoleList(this.setPersongRole(personBean));
        this.personDao.updatePerson(oldInfo);
        return false;
    }

    @Override
    @Transactional
    public boolean deleteAuxilibaryPolicer(String id) {
        if (Util.varCheckEmp(id)) {
            return false;
        }
        Person person = this.personDao.queryPersonById(id);
        person.setFlag("1");
        person.setTimestamp(System.currentTimeMillis());
        person.setMobiledList(null);
        person.setGroupList(null);
        person.setRoleList(null);
        person.setControlDepdList(null);
        person.setControlPolicedList(null);
        this.personDao.updatePerson(person);
        this.personDao.deleteNoPersonMobile();
        return true;
    }

    @Override
    @Transactional
    public boolean changeLockStatus(List<String> ids, String lockStatus) throws Exception {
        if (ids == null || ids.size() < 1) {
            return false;
        }
        for (String id : ids) {
            Person person = this.personDao.queryPersonById(id);
            if (person == null) {
                throw new Exception("\u8b66\u5458\u4e0d\u5b58\u5728");
            }
            person.setLockState(lockStatus);
            this.personDao.updatePerson(person);
        }
        return true;
    }

    private Person getPerson(QueryPersonBean personBean) {
        Person person = new Person();
        person.setName(personBean.getName());
        person.setCode(personBean.getCode());
        person.setIdentifier(personBean.getIdentifier());
        person.setSex(personBean.getSex());
        person.setPosition(personBean.getPosition());
        person.setPolice(personBean.getPolice());
        person.setOfficePhone(personBean.getOfficePhone());
        person.setMobileMultimediaMessage(personBean.getMobileMultimediaMessage());
        person.setMobilePersonal(personBean.getMobilePersonal());
        person.setMobiledList(this.getMobileList(personBean.getMobile()));
        person.setLockState(StringUtils.isNotEmpty((String)personBean.getLockState()) ? personBean.getLockState() : "0");
        String defaultPwd = this.systemConfigPbService.getValueByCode("defaultPass");
        person.setPassword(Md5PwdEncoder.getInstance().encodePassword(defaultPwd));
        person.setFlag("0");
        person.setOrderField(999L);
        person.setNameBriefSpell(PinYin4j.getNameSimplicityWithPolyphone(personBean.getName()));
        person.setMobile(personBean.getMobile());
        person.setOrderField(personBean.getOrderField());
        Department department = this.depService.queryDepById(personBean.getDepId());
        if (department == null) {
            throw new RuntimeException("\u5355\u4f4dID\u4e0d\u6b63\u786e");
        }
        person.setDepartment(department);
        person.setGrade(BimsUtil.checkLevel(personBean.getGrade(), person.getDepartment().getCode()) + "");
        person.setPersonState(personBean.getPersonState());
        person.setDisplayState(personBean.getDisplayState());
        person.setLeaderLevel(personBean.getLeaderLevel());
        person.setPersonType(personBean.getPersonType());
        person.setCommType(personBean.getCommType());
        person.setDepCode(person.getDepartment().getCode());
        person.setRoleList(this.setPersongRole(personBean));
        person.setCreatorId(personBean.getCreatorId());
        person.setLastChangePwDate(new Date());
        return person;
    }

    private List<Mobile> getMobileList(String mobileStr) {
        String[] mobiles;
        ArrayList<Mobile> mobileList = new ArrayList<Mobile>();
        if (mobileStr != null && (mobiles = mobileStr.split(",")).length > 0) {
            for (String mo : mobiles) {
                Mobile mobile = new Mobile();
                mobile.setMobile(mo);
                mobileList.add(mobile);
            }
        }
        return mobileList;
    }

    private List<Role> setPersongRole(QueryPersonBean personBean) {
        Role role;
        String[] roleIdsArray;
        ArrayList<Role> roleList = new ArrayList<Role>();
        String isSetSysRole = this.systemConfigPbService.getValueByCode("isSetSysRole");
        if ("0".equals(isSetSysRole)) {
            roleList.addAll(this.sysRoleService.queryDefaultRoleList());
        }
        if (personBean.getRoleIds() != null) {
            for (String id : roleIdsArray = personBean.getRoleIds().split(",")) {
                role = this.sysRoleService.queryRoleById(id);
                roleList.add(role);
            }
        }
        if (personBean.getTerminalRoleIds() != null) {
            for (String id : roleIdsArray = personBean.getTerminalRoleIds().split(",")) {
                role = this.sysRoleService.queryRoleById(id);
                roleList.add(role);
            }
        }
        return roleList;
    }
}

