/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.bims.control;

import com.xdja.pams.bims.bean.ImpPersonExcelBean;
import com.xdja.pams.bims.bean.PersonBean;
import com.xdja.pams.bims.bean.PersonExtraColumnBean;
import com.xdja.pams.bims.bean.PersonTerminal;
import com.xdja.pams.bims.bean.QueryDeviceBean;
import com.xdja.pams.bims.bean.QueryPersonBean;
import com.xdja.pams.bims.bean.QueryPersonUpdateBean;
import com.xdja.pams.bims.entity.BimsGroup;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.FieldConfig;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.entity.PersonExcel;
import com.xdja.pams.bims.entity.PersonImpErrInfoExcel;
import com.xdja.pams.bims.entity.PersonUpdated;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.FieldConfigService;
import com.xdja.pams.bims.service.GroupManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.commonException.WorkflowException;
import com.xdja.pams.common.util.Md5PwdEncoder;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.common.util.excel.ExcelUtil;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.scms.bean.TerminalBean;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.entity.Terminal;
import com.xdja.pams.scms.service.DevicePbService;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.service.TerminalReportService;
import com.xdja.pams.scms.service.TerminalService;
import com.xdja.pams.sso.bean.SynRst;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.tims.service.MsgPushService;
import com.xdja.pams.upms.entity.Role;
import com.xdja.pams.upms.service.SysRoleService;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@Scope(value="session")
public class UserManageControler
extends BaseControler {
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DevicePbService deviceService;
    @Autowired
    private DeviceService deviceService2;
    @Autowired
    private TerminalService terminalService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private DepManageService depService;
    @Autowired
    private GroupManageService groupManageService;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private TerminalReportService terminalReportService;
    @Autowired
    MsgPushService sendAppNotice;
    @Autowired
    FieldConfigService fieldConfigService;
    private static final DecimalFormat df = new DecimalFormat("######0.00");
    private static final Logger log = LoggerFactory.getLogger(UserManageControler.class);
    private String cardcount = "";

    @RequestMapping(value={"/bims/UserManageControler/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            List<FieldConfig> fieldList = this.fieldConfigService.queryDefaultList();
            HashMap<String, String> fieldState = new HashMap<String, String>();
            if (fieldList != null && !fieldList.isEmpty()) {
                for (FieldConfig fc : fieldList) {
                    fieldState.put(fc.getFieldName(), fc.getDisplayStateList());
                }
            }
            map.put((Object)"fieldState", fieldState);
            List<FieldConfig> customList = this.fieldConfigService.queryCustomList();
            Iterator<FieldConfig> customListIter = customList.iterator();
            while (customListIter.hasNext()) {
                FieldConfig fieldConfig = customListIter.next();
                if ("0".equals(fieldConfig.getDisplayStateList())) continue;
                customListIter.remove();
            }
            map.put((Object)"customList", customList);
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        this.cardcount = this.systemConfigPbService.getValueByCode("cardcount");
        map.put((Object)"cardcount", (Object)this.cardcount);
        map.put((Object)"rootDep", (Object)this.getRootId(request));
        map.put((Object)"clearPhoneInfo", (Object)Util.getConfigFile("clearPhoneInfo").trim());
        return sendUrl;
    }

    @RequestMapping(value={"/bims/UserManageControler/queryUseList.do"})
    public void queryUseList(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryPersonBean queryPersonBean) {
        int operateResult = 1;
        this.setOperator(request);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Page page = new Page(Integer.parseInt(queryPersonBean.getPage()), Integer.parseInt(queryPersonBean.getRows()));
            List<QueryPersonBean> list = this.userManageService.queryPersonList2(queryPersonBean, this.getControlDeps(request), this.getControlPolices(request), page);
            if (list != null && !list.isEmpty()) {
                ArrayList<String> personIds = new ArrayList<String>();
                for (QueryPersonBean qp : list) {
                    personIds.add(qp.getId());
                }
                Map<String, List<PersonExtraColumnBean>> peMap = this.userManageService.getPersonExtraByPersonIds(personIds);
                for (QueryPersonBean qp : list) {
                    qp.setPersonExtraColumns(peMap.get(qp.getId()));
                }
            }
            result.put("total", page.getTotal());
            result.put("rows", list);
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/bims/UserManageControler/toEditOrAddUser.do"})
    public String toEditOrAddUser(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        Person person = null;
        Device device = null;
        if (!"noID".equals(id)) {
            List<Device> deviceList;
            person = this.userManageService.queryPersonById(id);
            List<BimsGroup> groupList = person.getGroupList();
            String groupIds = "";
            for (BimsGroup group : groupList) {
                groupIds = groupIds + group.getId() + ",";
            }
            if (groupIds.length() > 1) {
                person.setGroupIds(groupIds.substring(0, groupIds.length() - 1));
            }
            List<Role> roleList = person.getRoleList();
            String roleIds = "";
            String terminalRoleIds = "";
            for (Role role : roleList) {
                if ("3".equals(role.getType()) || "1".equals(role.getType())) {
                    roleIds = roleIds + role.getId() + ",";
                }
                if (!"2".equals(role.getType())) continue;
                terminalRoleIds = terminalRoleIds + role.getId() + ",";
            }
            if (roleIds.length() > 1) {
                person.setRoleIds(roleIds.substring(0, roleIds.length() - 1));
            }
            if (terminalRoleIds.length() > 1) {
                person.setTerminalRoleIds(terminalRoleIds.substring(0, terminalRoleIds.length() - 1));
            }
            if ((deviceList = this.deviceService.getByPersonId(id)) != null && !deviceList.isEmpty()) {
                device = deviceList.get(0);
                String cardTypeName = this.commonCodePbService.getCodeNameByCode(device.getType(), "2000");
                map.put((Object)"cardTypeName", (Object)cardTypeName);
            } else {
                device = new Device();
                device.setTerminal(new Terminal());
            }
        } else {
            person = new Person();
            person.setDepartment(new Department());
            device = new Device();
            device.setTerminal(new Terminal());
        }
        String codeSize = this.systemConfigPbService.getValueByCode("codeSize");
        try {
            int size = Integer.parseInt(codeSize);
            if (size > 32) {
                codeSize = "32";
            }
            if (size < 6) {
                codeSize = "6";
            }
        }
        catch (NumberFormatException e) {
            log.error("\u8b66\u53f7\u6700\u5927\u957f\u5ea6\u8bbe\u7f6e\u9519\u8bef \uff1a" + codeSize);
            codeSize = "6";
        }
        map.put((Object)"codeSize", (Object)codeSize);
        map.put((Object)"person", (Object)person);
        map.put((Object)"device", (Object)device);
        map.put((Object)"cardcount", (Object)this.cardcount);
        String ifShow = "false";
        if ("0".equals(this.systemConfigPbService.getValueByCode("showPersonalNo"))) {
            ifShow = "true";
        }
        map.put((Object)"showPersonalNo", (Object)ifShow);
        List<FieldConfig> fieldList = this.fieldConfigService.queryDefaultList();
        HashMap<String, String> fieldState = new HashMap<String, String>();
        if (fieldList != null && !fieldList.isEmpty()) {
            for (FieldConfig fc : fieldList) {
                fieldState.put(fc.getFieldName(), fc.getDisplayStateDetail());
            }
        }
        map.put((Object)"fieldState", fieldState);
        List<FieldConfig> customList = this.fieldConfigService.queryCustomList();
        List<PersonExtraColumnBean> peList = null;
        if (!"noID".equals(id)) {
            peList = this.userManageService.getPersonExtraByPersonId(id);
        }
        peList = this.convertPersonExtra(customList, peList);
        map.put((Object)"personExtraColumns", peList);
        return "bims/personManage/default/addOrEdit";
    }

    private List<PersonExtraColumnBean> convertPersonExtra(List<FieldConfig> personCustomColumns, List<PersonExtraColumnBean> defaultValues) {
        ArrayList<PersonExtraColumnBean> personExtraColumns = null;
        if (personCustomColumns != null && !personCustomColumns.isEmpty()) {
            personExtraColumns = new ArrayList<PersonExtraColumnBean>();
            for (FieldConfig commonCode : personCustomColumns) {
                if (!"0".equals(commonCode.getDisplayStateDetail())) continue;
                PersonExtraColumnBean pe = new PersonExtraColumnBean();
                pe.setName(commonCode.getName());
                pe.setCode(commonCode.getFieldName());
                pe.setOrderField(commonCode.getSeq().intValue());
                personExtraColumns.add(pe);
                if (defaultValues == null) continue;
                for (PersonExtraColumnBean column : defaultValues) {
                    if (!column.getCode().equals(pe.getCode())) continue;
                    pe.setValue(column.getValue());
                }
            }
            Collections.sort(personExtraColumns, new Comparator<PersonExtraColumnBean>(){

                @Override
                public int compare(PersonExtraColumnBean o1, PersonExtraColumnBean o2) {
                    return o1.getOrderField() - o2.getOrderField();
                }
            });
        }
        return personExtraColumns;
    }

    private List<PersonExtraColumnBean> makeExtraColumnValue(HttpServletRequest request) {
        ArrayList<PersonExtraColumnBean> list = new ArrayList<PersonExtraColumnBean>();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String param = (String)parameterNames.nextElement();
            if (!param.startsWith("extra")) continue;
            PersonExtraColumnBean personExtraColumnBean = new PersonExtraColumnBean();
            personExtraColumnBean.setCode(param.substring(5));
            personExtraColumnBean.setValue(request.getParameter(param));
            list.add(personExtraColumnBean);
        }
        return list;
    }

    @RequestMapping(value={"/bims/UserManageControler/addUser.do"})
    public void addUser(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryPersonBean personBean, QueryDeviceBean device) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            if (personBean == null || personBean.getMobile() == null) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            } else {
                String tmp = this.userManageService.checkMobileIsExist(personBean.getMobile().split(","));
                if (null != tmp) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.person.error.msg.mobile", new String[]{tmp}));
                } else if (this.userManageService.checkCode(personBean.getCode())) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.person.error.msg.code"));
                } else if (this.userManageService.checkIdentifer(personBean.getIdentifier())) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.person.error.msg.identifier"));
                } else {
                    personBean.setCreatorId(this.person.getId());
                    List<PersonExtraColumnBean> personExtraColumns = this.makeExtraColumnValue(request);
                    personBean.setPersonExtraColumns(personExtraColumns);
                    this.userManageService.add(personBean, device);
                    operateResult = 1;
                    rtnResult.setRtnCode("0");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                }
            }
        }
        catch (WorkflowException e) {
            log.error("\u6dfb\u52a0\u4eba\u5458\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + " " + e.getMessage());
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u4eba\u5458\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/UserManageControler/editUser.do"})
    public void editUser(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryPersonBean personBean, QueryDeviceBean queryDeviceBean) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            if (personBean != null && personBean.getMobile() != null) {
                String[] mobiles = personBean.getMobile().split(",");
                String tmp = null;
                ArrayList<Mobile> mobileList = new ArrayList<Mobile>();
                HashMap<String, String> mMap = new HashMap<String, String>();
                for (String m : mobiles) {
                    if (Util.varCheckEmp(m)) continue;
                    if (mMap.get(m) != null) {
                        tmp = m;
                        break;
                    }
                    mMap.put(m, m);
                    Mobile tmpMobile = this.userManageService.getMobile(m);
                    if (tmpMobile != null && !personBean.getId().equals(tmpMobile.getPerson().getId())) {
                        tmp = m;
                        break;
                    }
                    if (tmpMobile == null) {
                        tmpMobile = new Mobile();
                        tmpMobile.setMobile(m);
                    }
                    mobileList.add(tmpMobile);
                }
                if (tmp != null) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.person.error.msg.mobile", new String[]{tmp}));
                } else if (this.userManageService.checkCode(personBean.getCode(), personBean.getId())) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.person.error.msg.code"));
                } else if (this.userManageService.checkIdentifer(personBean.getIdentifier(), personBean.getId())) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.person.error.msg.identifier"));
                } else {
                    Person oldPerson = this.userManageService.queryPersonById(personBean.getId());
                    boolean isReportLog = false;
                    if (this.terminalReportService.judgeIsReportForPerson(personBean, oldPerson)) {
                        isReportLog = true;
                    }
                    List<Mobile> oldMobileList = oldPerson.getMobiledList();
                    String canNotDelMobiles = "";
                    for (Mobile mobile : oldMobileList) {
                        if (personBean.getMobile().indexOf(mobile.getMobile()) >= 0 || this.deviceService.getByMobile(mobile.getMobile()) == null || this.deviceService.getByMobile(mobile.getMobile()).size() <= 0) continue;
                        canNotDelMobiles = canNotDelMobiles + mobile.getMobile() + ",";
                    }
                    if (!"".equals(canNotDelMobiles)) {
                        canNotDelMobiles = canNotDelMobiles.substring(0, canNotDelMobiles.length() - 1);
                        rtnResult.setRtnCode("1");
                        rtnResult.setRtnMsg("\u4e0b\u9762\u7684\u5df2\u7533\u8bf7\u8fc7\u5361\u7684\u624b\u673a\u53f7\u4e0d\u53ef\u5220\u9664\uff1a" + canNotDelMobiles);
                    } else {
                        personBean.setMobiledList(mobileList);
                        List<PersonExtraColumnBean> personExtraColumns = this.makeExtraColumnValue(request);
                        personBean.setPersonExtraColumns(personExtraColumns);
                        this.userManageService.updatePersonForEdit(personBean, queryDeviceBean, this.operator.getPerson().getId());
                        this.deviceService.updateDeviceWhereMobileNotExist();
                        this.userManageService.deleteNoPersonMobile();
                        if (isReportLog) {
                            this.terminalReportService.saveAndReportLogForEdit(personBean);
                        }
                        operateResult = 1;
                        rtnResult.setRtnCode("0");
                        rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                    }
                }
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        catch (WorkflowException e) {
            log.error("\u4fee\u6539\u4eba\u5458\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u4eba\u5458\u4fe1\u606f\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/UserManageControler/deleteUser.do"})
    public void deleteUser(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            if (!this.userManageService.checkdelete(id)) {
                String cardStates = this.systemConfigPbService.getValueByCode("can_not_delete_state");
                String[] cardStateArr = cardStates.split(",");
                String stateName = "";
                for (String state : cardStateArr) {
                    CommonCode code = this.commonCodePbService.getByCode(state, "2001");
                    if (code == null) continue;
                    stateName = stateName + code.getName() + ",";
                }
                stateName = stateName.endsWith(",") ? stateName.substring(0, stateName.length() - 1) : stateName;
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.person.error.msg.cannotdelete1", new String[]{stateName}));
            } else if (this.person.getId().equals(id)) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.person.error.msg.cannotdelete2"));
            } else {
                this.userManageService.delete(id);
                this.deviceService.updateDeviceWhereMobileNotExist();
                this.userManageService.deleteNoPersonMobile();
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (WorkflowException e) {
            log.error("\u5220\u9664\u4eba\u5458\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u4eba\u5458\u4fe1\u606f\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/UserManageControler/deletePhoneInfo.do"})
    public void deletePhoneInfo(HttpServletRequest request, HttpServletResponse response, ModelMap map, String personId, String imei) {
        log.debug("\u8fdb\u5165deletePhoneInfo\u65b9\u6cd5");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("personId", personId);
        paramMap.put("imei", imei);
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            this.sendAppNotice.sendDelPhoneInfo(paramMap);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            log.debug("\u53d1\u9001\u64e6\u9664\u6307\u4ee4\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u64e6\u9664\u6307\u4ee4\u5931\u8d25\uff01", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/UserManageControler/jumpToSelectImei.do"})
    public String jumpToSelectImei(HttpServletRequest request, HttpServletResponse response, ModelMap map, String personId) {
        map.put((Object)"personId", (Object)personId);
        return "bims/personManage/default/sendCommand";
    }

    @RequestMapping(value={"/bims/UserManageControler/queryUseImeiList.do"})
    public void queryUseImeiList(HttpServletRequest request, HttpServletResponse response, ModelMap map, String personId) {
        int operateResult = 1;
        this.setOperator(request);
        List<PersonTerminal> list = null;
        try {
            list = this.userManageService.queryUseImeiList(personId);
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u83b7\u53d6\u4eba\u5458\u5173\u8054\u7684iemi\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
        String jsonlist = Util.toJsonStr(list);
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/bims/UserManageControler/deleteUserBatch.do"})
    public void deleteUserBatch(HttpServletRequest request, HttpServletResponse response, ModelMap map, String ids) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            String[] idArray = ids.split(",");
            String notdeleteCodes = "";
            for (int i = 0; i < idArray.length; ++i) {
                if (!this.userManageService.checkdelete(idArray[i])) {
                    Person person = this.userManageService.queryPersonById(idArray[i]);
                    notdeleteCodes = notdeleteCodes + person.getName();
                    continue;
                }
                this.userManageService.delete(idArray[i]);
            }
            this.userManageService.deleteNoPersonMobile();
            this.deviceService.updateDeviceWhereMobileNotExist();
            if (notdeleteCodes.equals("")) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg("\u5df2\u5199\u5361\u4eba\u5458\u65e0\u6cd5\u5220\u9664\uff1a" + notdeleteCodes);
            }
        }
        catch (WorkflowException e) {
            log.error("\u6279\u91cf\u5220\u9664\u4eba\u5458\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + " " + e.getMessage());
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u5220\u9664\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/UserManageControler/openBatch.do"})
    public void openBatch(HttpServletRequest request, HttpServletResponse response, ModelMap map, String ids) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            String[] idArray = ids.split(",");
            this.deviceService.updateState("3", idArray);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/UserManageControler/lock.do"})
    public void lock(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, String state) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            Person person = this.userManageService.queryPersonById(id);
            person.setLockState(state);
            this.userManageService.updateUser(person);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/UserManageControler/unlcokPass.do"})
    public void unlcokPass(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            Person person = this.userManageService.queryPersonById(id);
            person.setLoginErrorTimes(0);
            this.userManageService.updateUser(person);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/UserManageControler/resetPass.do"})
    public void resetPass(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            Person person = this.userManageService.queryPersonById(id);
            person.setPassword(Md5PwdEncoder.getInstance().encodePassword(this.systemConfigPbService.getValueByCode("defaultPass")));
            this.userManageService.updateUser(person);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/UserManageControler/personDisplay.do"})
    public void personDisplay(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, String displayState) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            Person person = this.userManageService.queryPersonById(id);
            person.setDisplayState(displayState);
            this.userManageService.updateUser(person);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/UserManageControler/toBingDing.do"})
    public String toBingDing(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        return "bims/personManage/default/bingding";
    }

    @RequestMapping(value={"/bims/UserManageControler/saveBingDing.do"})
    public void saveBingDing(HttpServletRequest request, HttpServletResponse response, ModelMap map, String cardType, String BingDingType, String ids) {
        ReturnResult rtnResult = new ReturnResult();
        cardType = "3";
        try {
            String[] idArray = ids.split(",");
            this.deviceService.updateBindingState(BingDingType, idArray);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/UserManageControler/toCardInfo.do"})
    public String toCardInfo(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        map.put((Object)"id", (Object)id);
        String updateMobile = this.systemConfigPbService.getValueByCode("updatemobile");
        boolean ableUpdateMobile = false;
        if ("0".equals(updateMobile)) {
            ableUpdateMobile = true;
        }
        map.put((Object)"ableUpdateMobile", (Object)ableUpdateMobile);
        return "bims/personManage/default/cardInfo";
    }

    @RequestMapping(value={"/bims/UserManageControler/getCardInfo.do"})
    public void getCardInfo(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        ArrayList<QueryDeviceBean> list = null;
        try {
            List<Device> deviceList = this.deviceService.getByPersonId(id);
            list = new ArrayList<QueryDeviceBean>();
            for (int i = 0; i < deviceList.size(); ++i) {
                QueryDeviceBean deviceBean = new QueryDeviceBean();
                Device device = deviceList.get(i);
                if ("1".equals(device.getRevokeFlag())) continue;
                deviceBean.setCardId(device.getId());
                deviceBean.setStateName(this.commonCodePbService.getCodeNameByCode(device.getState(), "2001"));
                deviceBean.setState(device.getState());
                deviceBean.setType(this.commonCodePbService.getCodeNameByCode(device.getType(), "2000"));
                deviceBean.setPhone(device.getMobile().getMobile());
                deviceBean.setBingDingType(device.getBindingState());
                deviceBean.setImei(device.getImei());
                deviceBean.setImsi(device.getImsi());
                deviceBean.setIccid(device.getIccid());
                String bindingState = device.getBindingState();
                String bindingStateName = " ";
                if (StringUtils.isNotBlank((CharSequence)bindingState)) {
                    String[] arrayState = bindingState.split(",");
                    for (int j = 0; j < arrayState.length; ++j) {
                        bindingStateName = bindingStateName + this.commonCodePbService.getCodeNameByCode(arrayState[j], "2013") + ",";
                    }
                    bindingStateName = bindingStateName.substring(0, bindingStateName.length() - 1);
                }
                deviceBean.setBingDingTypeName(bindingStateName);
                deviceBean.setTerminalId(device.getTerminal().getId());
                deviceBean.setTerminalType(device.getTerminal().getTerminaltype());
                deviceBean.setTerminalTypeName(this.commonCodePbService.getCodeNameByCode(device.getTerminal().getTerminaltype(), "2020"));
                deviceBean.setTerminalBrand(device.getTerminal().getTerminalband());
                deviceBean.setTerminalBrandName(this.commonCodePbService.getCodeNameByCode(device.getTerminal().getTerminalband(), "2021"));
                deviceBean.setTerminalOs(device.getTerminal().getTerminalos());
                deviceBean.setTerminalOsName(this.commonCodePbService.getCodeNameByCode(device.getTerminal().getTerminalos(), "2022"));
                deviceBean.setTerminalName(device.getTerminal().getTerminalname());
                deviceBean.setTerminalVersion(device.getTerminal().getPoliceAppVersion());
                deviceBean.setEditFlag(this.userManageService.checkCardCanEdit(device.getState()) + "");
                deviceBean.setCardName(device.getName());
                list.add(deviceBean);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5361\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        Util.writeUtf8Text(response, Util.toJsonStr(list));
    }

    @RequestMapping(value={"/bims/UserManageControler/saveCardInfo.do"})
    public void saveCardInfo(HttpServletRequest request, HttpServletResponse response, ModelMap map, String jsonrows) {
        ReturnResult rtnResult = new ReturnResult();
        HashMap<String, String> imeiMap = new HashMap<String, String>();
        HashMap<String, String> imsiMap = new HashMap<String, String>();
        try {
            int i;
            boolean flag = true;
            QueryDeviceBean[] deviceBeanArray = Util.readValue(jsonrows, QueryDeviceBean[].class);
            for (i = 0; i < deviceBeanArray.length; ++i) {
                Mobile tmpMobile;
                boolean returnIsExist;
                String BingDingTypes = deviceBeanArray[i].getBingDingType();
                if (BingDingTypes != null && BingDingTypes.length() > 1 && BingDingTypes.indexOf("0") > -1) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg("\u5f53\u9009\u62e9\u4e0d\u7ed1\u5b9a\u65f6\uff0c\u4e0d\u80fd\u518d\u9009\u62e9\u5176\u4ed6\u7ed1\u5b9a\u9879");
                    flag = false;
                    break;
                }
                Device oldDevice = this.deviceService2.get((Serializable)((Object)deviceBeanArray[i].getCardId()));
                if (StringUtils.isNotEmpty((CharSequence)deviceBeanArray[i].getImei()) && !deviceBeanArray[i].getImei().equals(oldDevice.getImei())) {
                    returnIsExist = this.deviceService2.isExistImeiOrImsi(deviceBeanArray[i].getImei(), "imei");
                    if (imeiMap.containsKey(deviceBeanArray[i].getImei()) || returnIsExist) {
                        rtnResult.setRtnCode("1");
                        rtnResult.setRtnMsg("imei:" + deviceBeanArray[i].getImei() + "\u5df2\u5b58\u5728");
                        flag = false;
                        break;
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)deviceBeanArray[i].getImsi()) && !deviceBeanArray[i].getImsi().equals(oldDevice.getImsi())) {
                    returnIsExist = this.deviceService2.isExistImeiOrImsi(deviceBeanArray[i].getImsi(), "imsi");
                    if (imsiMap.containsKey(deviceBeanArray[i].getImsi()) || returnIsExist) {
                        rtnResult.setRtnCode("1");
                        rtnResult.setRtnMsg("imsi:" + deviceBeanArray[i].getImsi() + "\u5df2\u5b58\u5728");
                        flag = false;
                        break;
                    }
                }
                imeiMap.put(deviceBeanArray[i].getImei(), deviceBeanArray[i].getImei());
                imsiMap.put(deviceBeanArray[i].getImsi(), deviceBeanArray[i].getImsi());
                if (oldDevice.getMobile().getMobile().equals(deviceBeanArray[i].getPhone()) || (tmpMobile = this.userManageService.getMobile(deviceBeanArray[i].getPhone())) == null || tmpMobile.getPerson().getId().equals(oldDevice.getPersonId())) continue;
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg("\u624b\u673a\u53f7\u5df2\u5b58\u5728");
                flag = false;
                break;
            }
            if (flag) {
                for (i = 0; i < deviceBeanArray.length; ++i) {
                    Device oldDevice = this.deviceService2.get((Serializable)((Object)deviceBeanArray[i].getCardId()));
                    Mobile tmpMobile = this.userManageService.getMobile(deviceBeanArray[i].getPhone());
                    boolean phoneChange = false;
                    if (!oldDevice.getMobile().getMobile().equals(deviceBeanArray[i].getPhone())) {
                        phoneChange = true;
                        if (tmpMobile != null && tmpMobile.getPerson().getId().equals(oldDevice.getPersonId())) {
                            oldDevice.setMobile(tmpMobile);
                        } else {
                            String oldPhone = oldDevice.getMobile().getMobile();
                            oldDevice.getMobile().setMobile(deviceBeanArray[i].getPhone());
                            Person person = this.userManageService.queryPersonById(oldDevice.getPersonId());
                            String personPhone = person.getMobile();
                            if (StringUtils.isNotBlank((CharSequence)personPhone)) {
                                if ((personPhone = personPhone.replace(oldPhone, deviceBeanArray[i].getPhone())).indexOf(deviceBeanArray[i].getPhone()) < 0) {
                                    personPhone = personPhone + "," + deviceBeanArray[i].getPhone();
                                }
                            } else {
                                personPhone = deviceBeanArray[i].getPhone();
                            }
                            person.setMobile(personPhone);
                            this.userManageService.updateUser(person);
                        }
                    }
                    boolean isReportLog = false;
                    if (phoneChange || this.terminalReportService.jubgeIsReportForDevice(deviceBeanArray[i], oldDevice)) {
                        isReportLog = true;
                    }
                    TerminalBean terminalBean = this.terminalService.getById((Serializable)((Object)deviceBeanArray[i].getTerminalId()));
                    terminalBean.setTerminalband(deviceBeanArray[i].getTerminalBrand());
                    terminalBean.setTerminalname(deviceBeanArray[i].getTerminalName());
                    terminalBean.setTerminalos(deviceBeanArray[i].getTerminalOs());
                    terminalBean.setTerminaltype(deviceBeanArray[i].getTerminalType());
                    this.terminalService.update(terminalBean);
                    oldDevice.setBindingState(deviceBeanArray[i].getBingDingType());
                    oldDevice.setImei(deviceBeanArray[i].getImei());
                    oldDevice.setImsi(deviceBeanArray[i].getImsi());
                    oldDevice.setName(deviceBeanArray[i].getCardName());
                    this.deviceService2.update(oldDevice);
                    if (!isReportLog) continue;
                    this.terminalReportService.saveAndReportLogForCardInfoEdit(deviceBeanArray[i]);
                }
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5b89\u5168\u5361\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/UserManageControler/clientControl.do"})
    public void clientControl(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, String state) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            String[] ids = new String[]{id};
            this.deviceService.updateState(state, ids);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/UserManageControler/rebindControl.do"})
    public void rebindControl(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            String[] ids = new String[]{id};
            this.deviceService2.reBand(id);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/UserManageControler/toImportExcel.do"})
    public String toImport(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        boolean isOne = false;
        try {
            isOne = "one".equals(this.systemConfigPbService.getValueByCode("cardcount"));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            isOne = false;
        }
        map.put((Object)"isOne", (Object)("" + isOne));
        return "bims/personManage/default/import";
    }

    @RequestMapping(value={"/bims/UserManageControler/toEditHistory.do"})
    public String toEditHistory(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        map.put((Object)"id", (Object)id);
        return "bims/personManage/default/editHistory";
    }

    @RequestMapping(value={"/bims/UserManageControler/getEditHistory.do"})
    public void getEditHistory(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        List<PersonUpdated> personHistoryList = this.userManageService.queryEditHistoryById(id);
        ArrayList<QueryPersonUpdateBean> list = new ArrayList<QueryPersonUpdateBean>();
        for (int i = 0; i < personHistoryList.size(); ++i) {
            QueryPersonUpdateBean personBean = new QueryPersonUpdateBean();
            PersonUpdated person = personHistoryList.get(i);
            personBean.setId(person.getId());
            personBean.setCode(person.getCode());
            personBean.setName(person.getName());
            personBean.setIdentifier(person.getIdentifier());
            personBean.setDepName(person.getDepName());
            personBean.setEditTime(Util.getDate("yyyy-MM-dd HH:mm", person.getEditDate()));
            list.add(personBean);
        }
        Util.writeUtf8Text(response, Util.toJsonStr(list));
    }

    @RequestMapping(value={"/bims/UserManageControler/exportExcel.do"})
    public void exportExcel(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryPersonBean queryPersonBean) {
        log.info("exportExcel...............");
        try {
            String fileTitle = this.scps.getValueByCode("expBimsUserFileTitle");
            String fileName = Util.toUtf8String(this.scps.getValueByCode("expBimsUserFileName")) + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            Page page = new Page(1, Integer.parseInt(this.scps.getValueByCode("maxExcelCount")));
            List<QueryPersonBean> personList = this.userManageService.queryPersonList2(queryPersonBean, this.getControlDeps(request), this.getControlPolices(request), page);
            ArrayList<PersonExcel> list = new ArrayList<PersonExcel>();
            for (QueryPersonBean user : personList) {
                log.info(user.getCode() + user.getName() + user.getDepName());
                PersonExcel personBean = new PersonExcel();
                personBean.setId(user.getId());
                personBean.setCode(user.getCode());
                personBean.setName(user.getName());
                personBean.setSex(user.getSex());
                personBean.setIdentifier(user.getIdentifier());
                personBean.setDepName(user.getDepName());
                personBean.setPolice(user.getPolice());
                personBean.setPosition(user.getPosition());
                personBean.setOrderField(user.getOrderField());
                personBean.setLockState(user.getLockState());
                personBean.setMobile(user.getMobile());
                list.add(personBean);
            }
            if (list.size() <= 0) {
                PersonExcel personBean = new PersonExcel();
                list.add(personBean);
            }
            ArrayList<String> titleList = new ArrayList<String>();
            titleList.add(MessageManager.getProMessage(this.message, "bims.person.page.info.code"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.person.page.info.name"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.person.page.info.sex"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.person.page.info.identifer"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.person.page.info.dep"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.person.page.info.police"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.person.page.info.position"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.person.page.info.mobile"));
            ExcelUtil.getExcelAsTitle((OutputStream)response.getOutputStream(), fileTitle, fileTitle, list, titleList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Util.writeUtf8Text(response, MessageManager.getProMessage(this.message, "exp.error.msg") + ":" + e.getMessage());
        }
    }

    @RequestMapping(value={"/bims/UserManageControler/exportErrInfoExcel.do"})
    public void exportErrInfoExcel(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryPersonBean queryPersonBean) {
        log.info("exportExcel...............");
        try {
            String fileTitle = "\u5bfc\u5165\u5931\u8d25\u6570\u636e";
            String fileName = Util.toUtf8String("errinfo") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            Page page = new Page(1, Integer.parseInt(this.scps.getValueByCode("maxExcelCount")));
            List personList = (List)request.getSession().getAttribute("impErrorInfoList");
            ArrayList<PersonImpErrInfoExcel> list = new ArrayList<PersonImpErrInfoExcel>();
            for (ImpPersonExcelBean user : personList) {
                log.info(user.getCode() + user.getName() + user.getDepName());
                PersonImpErrInfoExcel personBean = new PersonImpErrInfoExcel();
                personBean.setId(user.getId());
                personBean.setCode(user.getCode());
                personBean.setName(user.getName());
                personBean.setSex(user.getSex());
                personBean.setIdentifier(user.getIdentifier());
                personBean.setDepCode(user.getI_dep_code());
                personBean.setPolice(user.getPolice());
                personBean.setPosition(user.getPosition());
                personBean.setMobile(user.getI_mobile());
                personBean.setDeviceType(user.getDeviceType());
                personBean.setTerminalType(user.getTerminalType());
                personBean.setTerminalBrand(user.getTerminalBrand());
                personBean.setTerminalName(user.getTerminalName());
                personBean.setTerminalOs(user.getTerminalOs());
                personBean.setCommType(user.getCommType());
                personBean.setCardName(user.getCardName());
                personBean.setUseType(user.getUseType());
                personBean.setErrorMsg(user.getErrorMsg());
                list.add(personBean);
            }
            if (list.size() <= 0) {
                PersonImpErrInfoExcel personBean = new PersonImpErrInfoExcel();
                list.add(personBean);
            }
            ArrayList<String> titleList = new ArrayList<String>();
            titleList.add(MessageManager.getProMessage(this.message, "bims.person.page.info.code"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.person.page.info.name"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.person.page.info.sex"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.person.page.info.identifer"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.person.page.info.dep"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.person.page.info.police"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.person.page.info.position"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.person.page.info.mobile"));
            titleList.add(MessageManager.getProMessage(this.message, "device.apply.page.info.index.cardtype"));
            titleList.add(MessageManager.getProMessage(this.message, "device.apply.page.info.index.terminaltype"));
            titleList.add(MessageManager.getProMessage(this.message, "device.apply.page.info.index.terminalbrand"));
            titleList.add(MessageManager.getProMessage(this.message, "device.apply.page.info.index.terminalname"));
            titleList.add(MessageManager.getProMessage(this.message, "device.apply.page.info.index.terminalos"));
            titleList.add(MessageManager.getProMessage(this.message, "device.apply.page.info.index.commtype"));
            titleList.add(MessageManager.getProMessage(this.message, "device.apply.page.info.index.devicename"));
            titleList.add(MessageManager.getProMessage(this.message, "device.apply.page.info.index.useType"));
            titleList.add(MessageManager.getProMessage(this.message, "device.apply.page.info.index.cardtype"));
            titleList.add(MessageManager.getProMessage(this.message, "device.apply.page.info.index.cardtype"));
            titleList.add("\u5f02\u5e38\u4fe1\u606f");
            ExcelUtil.getExcelAsTitle((OutputStream)response.getOutputStream(), fileTitle, fileTitle, list, titleList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Util.writeUtf8Text(response, MessageManager.getProMessage(this.message, "exp.error.msg") + ":" + e.getMessage());
        }
    }

    @RequestMapping(value={"/bims/UserManageControler/importExcel.do"})
    public void importExcel(@RequestParam MultipartFile file, HttpServletResponse response, HttpServletRequest request) {
        HashSet<ImpPersonExcelBean> wellList = new HashSet<ImpPersonExcelBean>();
        ArrayList<ImpPersonExcelBean> exitList = new ArrayList<ImpPersonExcelBean>();
        ArrayList<ImpPersonExcelBean> infoNotExitList = new ArrayList<ImpPersonExcelBean>();
        ArrayList<ImpPersonExcelBean> errorList = new ArrayList<ImpPersonExcelBean>();
        HashMap<String, Object> totalCount = new HashMap<String, Object>();
        try {
            log.info("importExcel begin.....................");
            long timeBetween = System.currentTimeMillis();
            this.userManageService.importPerson(file, wellList, exitList, infoNotExitList, errorList, totalCount, this.person.getId(), request);
            ArrayList<ImpPersonExcelBean> impErrorInfoList = new ArrayList<ImpPersonExcelBean>();
            impErrorInfoList.addAll(infoNotExitList);
            impErrorInfoList.addAll(errorList);
            impErrorInfoList.addAll(exitList);
            request.getSession().setAttribute("impErrorInfoList", impErrorInfoList);
            log.info("importPerson use time:" + (System.currentTimeMillis() - timeBetween));
            totalCount.put("wellCount", wellList.size());
            totalCount.put("infoNotExitCount", infoNotExitList.size());
            totalCount.put("infoNotExitList", infoNotExitList);
            totalCount.put("errorCount", errorList.size());
            totalCount.put("errorList", errorList);
            totalCount.put("exitCount", exitList.size());
            totalCount.put("exitList", exitList);
        }
        catch (Exception e) {
            totalCount.put("error", MessageManager.getProMessage(this.message, "bims.person.imp.error.exception") + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info(".....................importExcel end.");
        Util.writeUtf8Text1(response, Util.toJsonStr(totalCount));
    }

    @RequestMapping(value={"/bims/UserManageControler/importProgress.do"})
    public void importProgress(HttpServletResponse response, HttpServletRequest request) {
        HttpSession session = request.getSession();
        Double result = session.getAttribute("uploadUserCount") == null ? 0.0 : Double.valueOf(session.getAttribute("uploadUserCount") + "");
        result = result * 100.0;
        Util.writeUtf8Text1(response, df.format(result));
    }

    @RequestMapping(value={"/bims/UserManageControler/saveSkin.do"})
    public void saveSkin(HttpServletRequest request, HttpServletResponse response, String skinCode) {
        ReturnResult rr = new ReturnResult();
        try {
            if (!Util.varCheckEmp(skinCode)) {
                this.setOperator(request);
                this.userManageService.saveSkin(this.person.getId(), skinCode);
                this.person.setTheme(skinCode);
                rr.setRtnCode("0");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u6362\u80a4\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"/bims/UserManageControler/saveShortcutMenu.do"})
    public void saveShortcutMenu(HttpServletRequest request, HttpServletResponse response, String shortcutMenu) {
        ReturnResult rr = new ReturnResult();
        try {
            this.setOperator(request);
            this.userManageService.savaShortcutMenu(this.person.getId(), shortcutMenu);
            this.person.setShortcutMenu(shortcutMenu);
            rr.setRtnCode("0");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5feb\u6377\u83dc\u5355\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"/bims/UserManageControler/changePw.do"})
    public void changePw(HttpServletRequest request, HttpServletResponse response, String oldPassword, String newPassword1) {
        ReturnResult rr = new ReturnResult();
        boolean flag = false;
        try {
            if (!Util.varCheckEmp(oldPassword) && !Util.varCheckEmp(newPassword1)) {
                this.setOperator(request);
                Person p = this.userManageService.queryPersonById(this.person.getId());
                if (p != null) {
                    if (Md5PwdEncoder.getInstance().encodePassword(oldPassword.trim()).equals(p.getPassword())) {
                        p.setPassword(Md5PwdEncoder.getInstance().encodePassword(newPassword1.trim()));
                        p.setLastChangePwDate(new Date());
                        this.userManageService.updateUser(p);
                        rr.setRtnCode("0");
                        rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                        flag = true;
                    } else {
                        rr.setRtnCode("1");
                        rr.setRtnMsg(MessageManager.getProMessage(this.message, "bims.change.pw.error"));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5bc6\u7801\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e);
        }
        if (!flag && Util.varCheckEmp(rr.getRtnCode())) {
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"/bims/UserManageControler/toEditDepWin.do"})
    public String openEditDepWin() {
        return "bims/personManage/default/editDeptree";
    }

    @RequestMapping(value={"/bims/UserManageControler/editUsersDep.do"})
    public void editUsersDep(HttpServletRequest request, HttpServletResponse response, String ids, String depId) {
        ReturnResult rr = new ReturnResult();
        try {
            this.userManageService.updateUserDep(ids, depId);
            rr.setRtnCode("0");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            log.info("\u6279\u91cf\u4fee\u6539\u4eba\u5458\u5355\u4f4d\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u4fee\u6539\u4eba\u5458\u5355\u4f4d\u5931\u8d25", (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"/bims/UserManageControler/queryPerson.do"})
    public void queryPerson(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryPersonBean queryPersonBean) {
        SynRst synRst = new SynRst();
        try {
            List<Person> personList = this.userManageService.queryPerson(queryPersonBean);
            ArrayList<PersonBean> personBeanList = new ArrayList<PersonBean>();
            for (Person person : personList) {
                PersonBean personBean = new PersonBean();
                personBean.setID(person.getId());
                personBean.setCODE(person.getCode());
                personBean.setDEPCODE(person.getDepCode());
                personBean.setDEPNAME(person.getDepName());
                personBean.setGRADE(person.getGrade());
                personBean.setIDENTIFIER(person.getGrade());
                personBean.setNAME(person.getName());
                personBean.setPOLICE(person.getPolice());
                personBean.setSEX(person.getSex());
                personBeanList.add(personBean);
            }
            synRst.setList(personBeanList);
            synRst.setCount(personBeanList.size());
            synRst.setResult("0", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.success"));
        }
        catch (Exception e) {
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.error"));
            log.error("\u83b7\u53d6\u90e8\u95e8\u4eba\u5458\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
        Util.writeUtf8Text(response, Util.toJsonStr(synRst));
    }
}

