/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.bims.service.impl;

import com.xdja.pams.bims.bean.QueryGroupBean;
import com.xdja.pams.bims.dao.BimsGroupDao;
import com.xdja.pams.bims.dao.PersonDao;
import com.xdja.pams.bims.entity.BimsGroup;
import com.xdja.pams.bims.entity.GroupMemberSyn;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.GroupManageService;
import com.xdja.pams.bims.util.BimsUtil;
import com.xdja.pams.common.util.Page;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GroupManageServiceImpl
implements GroupManageService {
    @Autowired
    private BimsGroupDao groupDao;
    @Autowired
    private PersonDao personDao;
    @Autowired
    private DepManageService depManageService;

    @Override
    @Transactional
    public String addGroup(BimsGroup group) {
        if (StringUtils.isBlank((CharSequence)(group.getOrderField() + ""))) {
            group.setOrderField(999L);
        }
        group.setFlag("0");
        return this.groupDao.addGroup(group);
    }

    @Override
    @Transactional
    public void deleteGroupById(String id) {
        BimsGroup group = this.groupDao.queryGroupById(id);
        group.setFlag("1");
        group.setTimestamp(System.currentTimeMillis());
        group.setPersonList(null);
        this.groupDao.updateGroup(group);
    }

    @Override
    @Transactional
    public void updateGroup(BimsGroup group) {
        this.groupDao.updateGroup(group);
    }

    @Override
    public BimsGroup queryGroupByID(String groupId) {
        return this.groupDao.queryGroupById(groupId);
    }

    @Override
    public List<Person> queryGroupMember(String groupId) {
        BimsGroup group = this.groupDao.queryGroupById(groupId);
        return group.getPersonList();
    }

    @Override
    public List<BimsGroup> queryGroupList(QueryGroupBean queryGroupBean, String controlDepIds, Page page) {
        StringBuilder selectHql = new StringBuilder("select * from t_bims_group  bimsgroup where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from t_bims_group  bimsgroup where 1=1 ");
        ArrayList<String> paramList = new ArrayList<String>();
        selectHql.append("and bimsgroup.flag = ? ");
        countHql.append("and bimsgroup.flag = ? ");
        paramList.add("0");
        if (StringUtils.isNotBlank((CharSequence)queryGroupBean.getName())) {
            selectHql.append("and bimsgroup.name like ? ");
            countHql.append("and bimsgroup.name like ? ");
            paramList.add("%" + StringUtils.trim((String)queryGroupBean.getName()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryGroupBean.getType())) {
            selectHql.append("and bimsgroup.type like ? ");
            countHql.append("and bimsgroup.type like ? ");
            paramList.add("%" + queryGroupBean.getType() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryGroupBean.getCreatorID())) {
            selectHql.append("and (bimsgroup.CREATOR_ID = ? or bimsgroup.MANAGE_FLAG='1') ");
            countHql.append("and (bimsgroup.CREATOR_ID = ? or bimsgroup.MANAGE_FLAG='1') ");
            paramList.add(queryGroupBean.getCreatorID());
        }
        if (StringUtils.isNotBlank((CharSequence)queryGroupBean.getDepId())) {
            selectHql.append("and bimsgroup.dep_Id in (" + BimsUtil.getChildDepsSql() + ")");
            countHql.append("and bimsgroup.dep_Id in (" + BimsUtil.getChildDepsSql() + ")");
            paramList.add(queryGroupBean.getDepId());
        } else {
            selectHql.append("and bimsgroup.dep_Id in (" + BimsUtil.getChildDepsSql(controlDepIds) + ")");
            countHql.append("and bimsgroup.dep_Id in (" + BimsUtil.getChildDepsSql(controlDepIds) + ")");
        }
        selectHql.append(" order by order_field asc,create_date desc ");
        return this.groupDao.queryGroupListBySql(countHql.toString(), selectHql.toString(), paramList.toArray(), page);
    }

    @Override
    public List<BimsGroup> queryGroupList(QueryGroupBean queryBean) {
        StringBuilder selectHql = new StringBuilder("select * from t_bims_group  bimsgroup where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from t_bims_group  bimsgroup where 1=1 ");
        ArrayList<String> paramList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)queryBean.getName())) {
            selectHql.append("and bimsgroup.name like ? ");
            countHql.append("and bimsgroup.name like ? ");
            paramList.add("%" + queryBean.getName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getDepId())) {
            selectHql.append("and bimsgroup.dep_Id in (" + BimsUtil.getChildDepsSql() + ")");
            countHql.append("and bimsgroup.dep_Id in (" + BimsUtil.getChildDepsSql() + ")");
            paramList.add(queryBean.getDepId());
        }
        return this.groupDao.queryGroupListBySql(selectHql.toString(), paramList.toArray());
    }

    @Override
    @Transactional
    public void updateGroupMember(String groupId, String[] personIds) {
        boolean flag;
        BimsGroup group = this.groupDao.queryGroupById(groupId);
        ArrayList<GroupMemberSyn> groupMemberSynList = new ArrayList<GroupMemberSyn>();
        List<Person> oldGroupMemberList = group.getPersonList();
        for (int i = 0; i < oldGroupMemberList.size(); ++i) {
            flag = true;
            String oldPersonId = oldGroupMemberList.get(i).getId();
            for (int j = 0; j < personIds.length; ++j) {
                if (!oldPersonId.equals(personIds[j])) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            GroupMemberSyn groupMemberSyn = new GroupMemberSyn();
            groupMemberSyn.setGroupId(groupId);
            groupMemberSyn.setPersonId(oldPersonId);
            groupMemberSyn.setType("2");
            groupMemberSynList.add(groupMemberSyn);
        }
        for (int j = 0; j < personIds.length; ++j) {
            flag = true;
            for (int i = 0; i < oldGroupMemberList.size(); ++i) {
                if (!"".equals(personIds[j]) && !personIds[j].equals(oldGroupMemberList.get(i).getId())) continue;
                flag = false;
                break;
            }
            if (!flag || "".equals(personIds[j])) continue;
            GroupMemberSyn groupMemberSyn = new GroupMemberSyn();
            groupMemberSyn.setGroupId(groupId);
            groupMemberSyn.setPersonId(personIds[j]);
            groupMemberSyn.setType("1");
            groupMemberSynList.add(groupMemberSyn);
        }
        this.groupDao.addGroupMemberSyn(groupMemberSynList);
        ArrayList<Person> list = new ArrayList<Person>();
        for (String id : personIds) {
            Person person = this.personDao.queryPersonById(id);
            list.add(person);
        }
        group.setPersonList(list);
        this.groupDao.updateGroup(group);
    }

    @Override
    public boolean judgeIsGroupMember(String groupId, String personId) {
        List<Person> list = this.queryGroupMember(groupId);
        boolean isGroupMember = false;
        for (Person groupPerson : list) {
            if (!groupPerson.getId().equals(personId)) continue;
            isGroupMember = true;
            break;
        }
        return isGroupMember;
    }

    @Override
    public boolean judgeIsGroupHavePersons(String groupId) {
        List<Person> list = this.queryGroupMember(groupId);
        return list != null && list.size() > 0;
    }

    @Override
    @Transactional
    public void updateGroupForEdit(BimsGroup group) {
        BimsGroup tempGroup = this.queryGroupByID(group.getId());
        tempGroup.setName(group.getName());
        tempGroup.setType(group.getType());
        tempGroup.setDepartment(this.depManageService.queryDepById(group.getDepId()));
        tempGroup.setOrderField(group.getOrderField());
        tempGroup.setNote(group.getNote());
        tempGroup.setManageFlag(group.getManageFlag());
        tempGroup.setTimestamp(System.currentTimeMillis());
        this.updateGroup(tempGroup);
    }
}

