/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.filter;

import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoFilters
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SsoFilters.class);
    private String ssoLogoutUrl;

    public void destroy() {
        this.ssoLogoutUrl = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpSession session = httpRequest.getSession();
        String url = httpRequest.getRequestURI();
        try {
            Util util = new Util();
            if (util.checkFilterUrl(url, "sso.not.Filter.url")) {
                String urlParam = httpRequest.getQueryString();
                request.getRequestDispatcher(url.substring(httpRequest.getContextPath().length())).forward(request, response);
                return;
            }
            if (url.contains("/login/loginControler/loginOut.do")) {
                httpResponse.sendRedirect(this.ssoLogoutUrl);
                session.invalidate();
                return;
            }
            Operator operator = null;
            operator = (Operator)session.getAttribute("operator");
            request.setAttribute("isSSO", (Object)"true");
            if (operator == null) {
                if (!url.contains("/login/loginControler/login.do") && !url.contains("/login/loginControler/loginOut.do")) {
                    boolean isAjaxReq = false;
                    Enumeration names = httpRequest.getHeaderNames();
                    String xmlhttpreq = httpRequest.getHeader("x-requested-with");
                    xmlhttpreq = xmlhttpreq != null ? xmlhttpreq.toUpperCase() : null;
                    isAjaxReq = "XMLHTTPREQUEST".equals(xmlhttpreq);
                    if (isAjaxReq) {
                        httpResponse.sendError(512);
                        return;
                    }
                    httpResponse.sendRedirect(httpRequest.getContextPath() + "/login/loginControler/login.do");
                } else {
                    chain.doFilter(request, response);
                }
            } else {
                chain.doFilter(request, response);
            }
        }
        catch (Exception e) {
            log.error("#SSO\u8d44\u6e90\u62e6\u622a\u5931\u8d25", (Throwable)e);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.ssoLogoutUrl = config.getInitParameter("logoutUrl");
    }
}

