/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.service.impl;

import com.xdja.pams.common.service.PnPushService;
import com.xdja.pams.common.util.MD5Util;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.tims.bean.PnRequestBean;
import com.xdja.pams.tims.dao.MsgPushDao;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PnPushServiceImpl
implements PnPushService {
    @Autowired
    private SystemConfigPbService systemConfigService;
    @Autowired
    private MsgPushDao msgPushDao;
    private static final Logger log = LoggerFactory.getLogger(PnPushServiceImpl.class);

    @Override
    public String push(List<String> personIds, String appId, String bodyJson) throws Exception {
        if (CollectionUtils.isEmpty(personIds)) {
            return "";
        }
        String pushReceiveType = this.systemConfigService.getValueByCode("msgpush_receive_type");
        HashSet<String> imeiSet = new HashSet<String>();
        PnRequestBean pr = new PnRequestBean();
        if (StringUtils.isBlank((CharSequence)pushReceiveType)) {
            pushReceiveType = "0";
        }
        for (String personId : personIds) {
            if ("0".equals(pushReceiveType)) {
                List<String> personImeiList = this.msgPushDao.queryToPersonImeiByPersonId(personId);
                imeiSet.addAll(personImeiList);
            }
            if (!"1".equals(pushReceiveType)) continue;
            List<String> personIccid = this.msgPushDao.queryToPersonICCIDByPersonId(personId);
            imeiSet.addAll(personIccid);
        }
        StringBuffer sb = new StringBuffer();
        for (String imei : imeiSet) {
            if (imei.length() < 15) {
                imei = (imei + "00000").substring(0, 15);
            }
            if ((imei = MD5Util.MD5(imei)) != null) {
                imei = imei.toLowerCase();
            }
            sb.append(imei).append(",");
        }
        String imeiAll = sb.toString();
        if (imeiAll.length() > 0) {
            imeiAll = imeiAll.substring(0, imeiAll.length() - 1);
        }
        pr.setTo(imeiAll);
        pr.setFrom(appId);
        pr.setTitle("");
        pr.setMessage(bodyJson);
        String rqJson = Util.toJsonStr(pr);
        rqJson = URLEncoder.encode(rqJson, "utf-8");
        HttpRequestUtil httpclient = new HttpRequestUtil();
        String urlStr = this.systemConfigService.getValueByCode("msgpush_url");
        log.debug("\u63a8\u9001url:" + urlStr + " \u8bf7\u6c42\u6570\u636e:" + rqJson);
        String rst = httpclient.post(urlStr, rqJson);
        return rst;
    }
}

