/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.util;

import java.io.Serializable;

public class Page
implements Serializable {
    private static final long serialVersionUID = 4329683329578284885L;
    public static final int DEFAULT_PAGE_SIZE = 30;
    private int page;
    private int rp;
    private int total;
    private int pageCount;

    public Page() {
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setRp(int rp) {
        this.rp = rp;
    }

    public Page(int page, int rp) {
        if (page < 0) {
            page = 1;
        }
        if (rp < 1) {
            rp = 1;
        }
        this.page = page;
        this.rp = rp;
    }

    public Page(int pageIndex) {
        this(pageIndex, 30);
    }

    public Page(String SpageIndex, String SpageSize) {
        int pageIndex = 1;
        int pageSize = 30;
        try {
            pageIndex = Integer.parseInt(SpageIndex);
        }
        catch (Exception e) {
            pageIndex = 1;
        }
        try {
            pageSize = Integer.parseInt(SpageSize);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pageIndex <= 0) {
            pageIndex = 1;
        }
        if (pageSize < 1) {
            pageSize = 1;
        }
        this.page = pageIndex;
        this.rp = pageSize;
    }

    public int getRp() {
        return this.rp;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getTotal() {
        return this.total;
    }

    public int getFirstResult() {
        return (this.page - 1) * this.rp;
    }

    public void setTotal(int i) {
        int totalCount = i;
        if (totalCount < 0) {
            totalCount = 0;
        }
        this.total = totalCount;
        this.pageCount = totalCount / this.rp + (totalCount % this.rp == 0 ? 0 : 1);
        if (totalCount == 0) {
            this.page = 1;
        } else if (this.page > this.pageCount) {
            // empty if block
        }
    }

    public boolean isEmpty() {
        return this.total == 0;
    }

    public boolean isLastPage() {
        if (this.getPageCount() == 0) {
            return true;
        }
        return this.page == this.getPageCount();
    }

    public boolean isFirstPage() {
        return this.page <= 1;
    }
}

