/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.enaas.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.enaas.bean.ApproveResultRequest;
import com.xdja.pams.enaas.bean.EnaasResponse;
import com.xdja.pams.enaas.service.EnaasService;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.webservice.client.EnaasClient;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnaasServiceImpl
implements EnaasService {
    private static final Logger log = LoggerFactory.getLogger(EnaasService.class);
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DeviceService deviceService;

    @Override
    public EnaasResponse approvePersonInfo(Device device) {
        String url = this.systemConfigService.getValueByCode("enaas_url");
        String version = this.systemConfigService.getValueByCode("enaas_version");
        String sysId = this.systemConfigService.getValueByCode("enaas_sysid");
        Person person = this.userManageService.queryPersonById(device.getPersonId());
        return EnaasClient.approvePersonInfo(url, version, sysId, device.getEnaasUserId(), person.getName(), person.getCode(), person.getMobile(), person.getIdentifier(), this.covCardType(device.getType()));
    }

    @Override
    public EnaasResponse approvePersonInfoV2(Device device) {
        String url = this.systemConfigService.getValueByCode("enaas_url");
        String version = this.systemConfigService.getValueByCode("enaas_version");
        String sysId = this.systemConfigService.getValueByCode("enaas_sysid");
        Person person = this.userManageService.queryPersonById(device.getPersonId());
        String RAId = "";
        if ("1".equals(person.getPersonType())) {
            RAId = this.systemConfigService.getValueByCode("enaas_ra_id_mj");
        }
        if ("2".equals(person.getPersonType())) {
            RAId = this.systemConfigService.getValueByCode("enaas_ra_id_xj");
        }
        if ("3".equals(person.getPersonType())) {
            RAId = this.systemConfigService.getValueByCode("enaas_ra_id_fzfzt");
        }
        return EnaasClient.approvePersonInfoV2(url, version, sysId, device.getEnaasUserId(), person.getName(), person.getCode(), person.getMobile(), person.getIdentifier(), this.covCardType(device.getType()), RAId);
    }

    private String covCardType(String cardType) {
        if ("1".equals(cardType)) {
            return "1";
        }
        if ("2".equals(cardType)) {
            return "2";
        }
        if ("3".equals(cardType) || "4".equals(cardType)) {
            return "3";
        }
        return "4";
    }

    @Override
    public EnaasResponse cardNotify(Device device) {
        log.info("**** method cardNotify");
        String isUseEnaas = this.systemConfigService.getValueByCode("enaas_use");
        if ("1".equals(isUseEnaas)) {
            String url = this.systemConfigService.getValueByCode("enaas_url");
            String version = this.systemConfigService.getValueByCode("enaas_version");
            String sysId = this.systemConfigService.getValueByCode("enaas_sysid");
            return EnaasClient.cardNotify(url, version, sysId, device.getEnaasUserId());
        }
        return null;
    }

    @Override
    public EnaasResponse personDeleteNotify(Device device) {
        log.info("**** method personDeleteNotify");
        String isUseEnaas = this.systemConfigService.getValueByCode("enaas_use");
        if ("1".equals(isUseEnaas)) {
            String url = this.systemConfigService.getValueByCode("enaas_url");
            String version = this.systemConfigService.getValueByCode("enaas_version");
            String sysId = this.systemConfigService.getValueByCode("enaas_sysid");
            return EnaasClient.personDeleteNotify(url, version, sysId, device.getEnaasUserId());
        }
        return null;
    }

    @Override
    public void approveResultNotify(ApproveResultRequest approveResultRequest) {
        log.info("**** method approveResultNotify");
        Device device = this.deviceService.getByEnaasUserId(approveResultRequest.getUser_id());
        if (device == null) {
            log.error("\u8ba4\u8bc1\u7ed3\u679c\u8fd4\u56de\u7528\u6237ID\u672a\u5173\u8054\u5b89\u5168\u5361\u4fe1\u606f");
            return;
        }
        if ("1".equals(approveResultRequest.getResult())) {
            device.setState("1");
        } else {
            device.setEnaasState(approveResultRequest.getResult());
            device.setEnaasDesc(approveResultRequest.getDesc());
        }
        device.setTimestamp(new Date().getTime());
        this.deviceService.update(device);
    }
}

