/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.fjjg.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.fjjg.bean.FjBindInfoBean;
import com.xdja.pams.fjjg.service.BindInfoService;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class AuxBindController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(AuxBindController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private BindInfoService bindInfoService;

    @RequestMapping(value={"/fjjg/AuxBindController/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            map.put((Object)"rootDep", (Object)this.getRootId(request));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/fjjg/AuxBindController/queryList.do"})
    public void queryUseList(HttpServletRequest request, HttpServletResponse response, ModelMap map, FjBindInfoBean queryBean) {
        this.setOperator(request);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Page page = new Page(Integer.parseInt(queryBean.getPage()), Integer.parseInt(queryBean.getRows()));
            List<FjBindInfoBean> list = this.bindInfoService.getFjBindList(queryBean, this.getControlDeps(request), this.getControlPolices(request), page);
            result.put("total", page.getTotal());
            result.put("rows", list);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }
}

