/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.jwtapply.control;

import com.xdja.pams.bims.bean.PersonBean;
import com.xdja.pams.bims.bean.QueryDeviceBean;
import com.xdja.pams.bims.bean.QueryPersonBean;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.commonException.WorkflowException;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.bean.TaskListBean;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.entity.Terminal;
import com.xdja.pams.scms.service.DevicePbService;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.service.DeviceWorkflowService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.CommonCodeService;
import com.xdja.pams.upms.entity.SysPower;
import com.xdja.pams.upms.service.UserPowerService;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class JwtApplyController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(JwtApplyController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private CommonCodeService commonCodeService;
    @Autowired
    private DevicePbService devicePbService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private DeviceWorkflowService deviceWorkflowService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private UserPowerService userPowerService;

    @RequestMapping(value={"/jwtapply/jwtapplycontroller/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, PageParam page, ModelMap map) {
        String sendUrl = "error/error";
        Person person = null;
        Device device = null;
        try {
            String scheme = request.getScheme();
            if (!"https".equals(scheme)) {
                String url = "https://" + request.getServerName() + ":8443" + request.getContextPath() + request.getServletPath() + "?" + request.getQueryString();
                response.sendRedirect(url);
                return null;
            }
            if (scheme.equals("https")) {
                X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
                if (certs == null) {
                    log.debug("\u9519\u8bef\uff01\u8bf7\u63d0\u4ea4\u8bc1\u4e66\uff01");
                }
                X509Certificate gaX509Cert = null;
                gaX509Cert = certs[0];
                String dn = gaX509Cert.getSubjectDN().toString();
                String[] strMyList = dn.split(" ");
                String[] sfzhs = strMyList[1].split(",");
                String sfzh = sfzhs[0];
                String[] dlmTemp = strMyList[0].split("=");
                String name = dlmTemp[1];
                map.put((Object)"identifier", (Object)sfzhs);
                person = new Person();
                person.setName(name);
                person.setIdentifier(sfzh);
                person.setDepartment(new Department());
                device = new Device();
                device.setTerminal(new Terminal());
            }
            sendUrl = this.menuLinkPage;
            map.put((Object)"powerId", (Object)"SCMS02");
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        map.put((Object)"nowdate", (Object)Util.getDate("yyyy-MM-dd"));
        map.put((Object)"person", person);
        map.put((Object)"device", device);
        return "jwtApply/default/jwtApply";
    }

    @RequestMapping(value={"/jwtapply/jwtapplycontroller/save.do"})
    public void save(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryPersonBean personBean, QueryDeviceBean device) {
        ReturnResult rtnResult = new ReturnResult();
        boolean operateResult = false;
        try {
            if (personBean == null) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            } else {
                Object tmp = null;
                if (null != tmp) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.person.error.msg.mobile", new String[]{tmp}));
                } else if (this.userManageService.checkCode(personBean.getCode())) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.person.error.msg.code"));
                } else if (this.userManageService.checkIdentifer(personBean.getIdentifier())) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.person.error.msg.identifier"));
                } else {
                    personBean.setCreatorId("0");
                    Person p = this.userManageService.applyJwt(personBean, device);
                    operateResult = true;
                    rtnResult.setRtnCode("0");
                    rtnResult.setRtnMsg(p.getId());
                }
            }
        }
        catch (WorkflowException e) {
            log.error("\u6dfb\u52a0\u4eba\u5458\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + " " + e.getMessage());
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u4eba\u5458\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/jwtapply/jwtapplycontroller/downloadForm.do"})
    public void downloadForm(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        try {
            Person person = this.userManageService.queryPersonById(id);
            String templatePath = request.getSession().getServletContext().getRealPath("/") + "download/ApplicationForm.xls";
            FileInputStream inpt = new FileInputStream(templatePath);
            String filename = "\u7533\u8bf7\u8868.xls";
            response.reset();
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(filename, "UTF-8"));
            ServletOutputStream os = null;
            os = response.getOutputStream();
            HSSFWorkbook wb = new HSSFWorkbook((InputStream)inpt);
            HSSFSheet sheet = wb.getSheetAt(0);
            sheet.getRow(1).getCell(1).setCellValue(Util.getDate("yyyy-MM-dd", person.getCreateDate()));
            sheet.getRow(3).getCell(2).setCellValue(person.getDepartment().getName());
            sheet.getRow(4).getCell(2).setCellValue(person.getName());
            sheet.getRow(4).getCell(6).setCellValue(this.commonCodePbService.getCodeNameByCode(person.getSex(), "sex"));
            sheet.getRow(4).getCell(10).setCellValue(person.getMobile());
            sheet.getRow(5).getCell(2).setCellValue(this.commonCodePbService.getCodeNameByCode(person.getPolice(), "2012"));
            sheet.getRow(5).getCell(6).setCellValue(this.commonCodePbService.getCodeNameByCode(person.getPosition(), "2011"));
            sheet.getRow(5).getCell(10).setCellValue(person.getCode());
            sheet.getRow(6).getCell(2).setCellValue(person.getIdentifier());
            List<Device> devices = this.devicePbService.getByPersonId(person.getId());
            Device device = devices.get(0);
            if ("2".equals(device.getType())) {
                sheet.getRow(7).getCell(2).setCellValue("\u25a1\u79fb\u52a8\u624b\u673a\u7ec8\u7aef   \u2611\u7b14\u8bb0\u672c\u65e0\u7ebf\u4e0a\u516c\u5b89\u7f51  \uff08\u5728\u6846\u4e2d\u5212\u221a\uff0c\u53ea\u80fd\u9009\u62e9\u5176\u4e00\uff09");
            } else {
                sheet.getRow(7).getCell(2).setCellValue("\u2611\u79fb\u52a8\u624b\u673a\u7ec8\u7aef   \u25a1\u7b14\u8bb0\u672c\u65e0\u7ebf\u4e0a\u516c\u5b89\u7f51  \uff08\u5728\u6846\u4e2d\u5212\u221a\uff0c\u53ea\u80fd\u9009\u62e9\u5176\u4e00\uff09");
            }
            sheet.getRow(8).getCell(2).setCellValue(this.commonCodePbService.getCodeNameByCode(device.getTerminal().getTerminalband(), "2021"));
            sheet.getRow(8).getCell(6).setCellValue(device.getTerminal().getTerminalname());
            sheet.getRow(9).getCell(2).setCellValue(this.commonCodePbService.getCodeNameByCode(device.getTerminal().getTerminalos(), "2022"));
            sheet.getRow(9).getCell(6).setCellValue(this.commonCodePbService.getCodeNameByCode(device.getTerminal().getTerminaltype(), "2020"));
            sheet.getRow(10).getCell(2).setCellValue(person.getMobile());
            if ("1".equals(device.getCommType())) {
                sheet.getRow(11).getCell(2).setCellValue("\u25a1\u7535\u4fe1  \u2611\u79fb\u52a8  \u25a1\u8054\u901a\u3000\uff08\u5728\u6846\u4e2d\u5212\u221a\uff0c\u53ea\u80fd\u9009\u62e9\u5176\u4e00\uff09");
            } else if ("2".equals(device.getCommType())) {
                sheet.getRow(11).getCell(2).setCellValue("\u25a1\u7535\u4fe1  \u25a1\u79fb\u52a8  \u2611\u8054\u901a\u3000\uff08\u5728\u6846\u4e2d\u5212\u221a\uff0c\u53ea\u80fd\u9009\u62e9\u5176\u4e00\uff09");
            } else {
                sheet.getRow(11).getCell(2).setCellValue("\u2611\u7535\u4fe1  \u25a1\u79fb\u52a8  \u25a1\u8054\u901a\u3000\uff08\u5728\u6846\u4e2d\u5212\u221a\uff0c\u53ea\u80fd\u9009\u62e9\u5176\u4e00\uff09");
            }
            sheet.getRow(12).getCell(8).setCellValue(Util.getDate("yyyy-MM-dd", person.getCreateDate()));
            wb.write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/jwtapply/jwtapplycontroller/downloadFormByDevice.do"})
    public void downloadFormByDevice(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        try {
            Device device = this.deviceService.get((Serializable)((Object)id));
            Person person = this.userManageService.queryPersonById(device.getPersonId());
            String templatePath = request.getSession().getServletContext().getRealPath("/") + "download/ApplicationForm.xls";
            FileInputStream inpt = new FileInputStream(templatePath);
            String filename = "\u7533\u8bf7\u8868.xls";
            response.reset();
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(filename, "UTF-8"));
            ServletOutputStream os = null;
            os = response.getOutputStream();
            HSSFWorkbook wb = new HSSFWorkbook((InputStream)inpt);
            HSSFSheet sheet = wb.getSheetAt(0);
            sheet.getRow(1).getCell(1).setCellValue(Util.getDate("yyyy-MM-dd", person.getCreateDate()));
            sheet.getRow(3).getCell(2).setCellValue(person.getDepartment().getName());
            sheet.getRow(4).getCell(2).setCellValue(person.getName());
            sheet.getRow(4).getCell(6).setCellValue(this.commonCodePbService.getCodeNameByCode(person.getSex(), "sex"));
            sheet.getRow(4).getCell(10).setCellValue(person.getMobile());
            sheet.getRow(5).getCell(2).setCellValue(this.commonCodePbService.getCodeNameByCode(person.getPolice(), "2012"));
            sheet.getRow(5).getCell(6).setCellValue(this.commonCodePbService.getCodeNameByCode(person.getPosition(), "2011"));
            sheet.getRow(5).getCell(10).setCellValue(person.getCode());
            sheet.getRow(6).getCell(2).setCellValue(person.getIdentifier());
            if ("2".equals(device.getType())) {
                sheet.getRow(7).getCell(2).setCellValue("\u25a1\u79fb\u52a8\u624b\u673a\u7ec8\u7aef   \u2611\u7b14\u8bb0\u672c\u65e0\u7ebf\u4e0a\u516c\u5b89\u7f51  \uff08\u5728\u6846\u4e2d\u5212\u221a\uff0c\u53ea\u80fd\u9009\u62e9\u5176\u4e00\uff09");
            } else {
                sheet.getRow(7).getCell(2).setCellValue("\u2611\u79fb\u52a8\u624b\u673a\u7ec8\u7aef   \u25a1\u7b14\u8bb0\u672c\u65e0\u7ebf\u4e0a\u516c\u5b89\u7f51  \uff08\u5728\u6846\u4e2d\u5212\u221a\uff0c\u53ea\u80fd\u9009\u62e9\u5176\u4e00\uff09");
            }
            sheet.getRow(8).getCell(2).setCellValue(this.commonCodePbService.getCodeNameByCode(device.getTerminal().getTerminalband(), "2021"));
            sheet.getRow(8).getCell(6).setCellValue(device.getTerminal().getTerminalname());
            sheet.getRow(9).getCell(2).setCellValue(this.commonCodePbService.getCodeNameByCode(device.getTerminal().getTerminalos(), "2022"));
            sheet.getRow(9).getCell(6).setCellValue(this.commonCodePbService.getCodeNameByCode(device.getTerminal().getTerminaltype(), "2020"));
            sheet.getRow(10).getCell(2).setCellValue(person.getMobile());
            if ("1".equals(device.getCommType())) {
                sheet.getRow(11).getCell(2).setCellValue("\u25a1\u7535\u4fe1  \u2611\u79fb\u52a8  \u25a1\u8054\u901a\u3000\uff08\u5728\u6846\u4e2d\u5212\u221a\uff0c\u53ea\u80fd\u9009\u62e9\u5176\u4e00\uff09");
            } else if ("2".equals(device.getCommType())) {
                sheet.getRow(11).getCell(2).setCellValue("\u25a1\u7535\u4fe1  \u25a1\u79fb\u52a8  \u2611\u8054\u901a\u3000\uff08\u5728\u6846\u4e2d\u5212\u221a\uff0c\u53ea\u80fd\u9009\u62e9\u5176\u4e00\uff09");
            } else {
                sheet.getRow(11).getCell(2).setCellValue("\u2611\u7535\u4fe1  \u25a1\u79fb\u52a8  \u25a1\u8054\u901a\u3000\uff08\u5728\u6846\u4e2d\u5212\u221a\uff0c\u53ea\u80fd\u9009\u62e9\u5176\u4e00\uff09");
            }
            sheet.getRow(12).getCell(8).setCellValue(Util.getDate("yyyy-MM-dd", person.getCreateDate()));
            wb.write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/jwtapply/jwtapplycontroller/toJwtApplyList.do"})
    public String toJwtApplyList(HttpServletRequest request, HttpServletResponse response, PageParam page, ModelMap map) {
        String sendUrl = "error/error";
        Object person = null;
        Object device = null;
        String id = null;
        try {
            X509Certificate[] certs;
            String scheme = request.getScheme();
            if (scheme.equals("https")) {
                certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
                if (certs == null) {
                    log.debug("\u9519\u8bef\uff01\u8bf7\u63d0\u4ea4\u8bc1\u4e66\uff01");
                }
            } else {
                String url = "https://" + request.getServerName() + ":8443" + request.getContextPath() + request.getServletPath() + "?" + request.getQueryString();
                response.sendRedirect(url);
                return null;
            }
            X509Certificate gaX509Cert = null;
            gaX509Cert = certs[0];
            String dn = gaX509Cert.getSubjectDN().toString();
            String[] strMyList = dn.split(" ");
            String[] sfzhs = strMyList[1].split(",");
            String sfzh = sfzhs[0];
            String[] dlmTemp = strMyList[0].split("=");
            String name = dlmTemp[1];
            map.put((Object)"identifier", (Object)sfzhs);
            Person p = this.userManageService.getUserByIdentifer(sfzh);
            id = p.getId();
            sendUrl = this.menuLinkPage;
            map.put((Object)"powerId", (Object)"SCMS02");
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        map.put((Object)"id", id);
        return "jwtApply/default/jwtApplyList";
    }

    @RequestMapping(value={"/jwtapply/jwtapplycontroller/jwtApplyListQuery.do"})
    public void jwtApplyListQuery(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, String id, String code) {
        Page page = new Page();
        page.setRp(Integer.parseInt(pageParam.getRows()));
        page.setPage(Integer.parseInt(pageParam.getPage()));
        ArrayList listmap = new ArrayList();
        boolean operateResult = false;
        try {
            Person person = this.userManageService.queryPersonById(id);
            Map<String, SysPower> mapPower = this.userPowerService.queryPersonRoleList(person.getId());
            List<Device> devices = null;
            if (mapPower.get("JWTAPPLY") != null) {
                // empty if block
            }
            devices = this.devicePbService.getByPersonId(person.getId());
            for (Device device : devices) {
                HashMap<String, String> map = new HashMap<String, String>();
                PersonBean personb = this.userManageService.getPersonById(device.getPersonId());
                if ("0".equals(device.getState())) {
                    List<TaskListBean> tasks = this.deviceWorkflowService.findTodoTasksByDeviceId(device.getId());
                    TaskListBean tb = tasks.get(0);
                    List taskList = this.taskService.createTaskQuery().processInstanceId(tb.getProcessInstanceId()).list();
                    Task task = (Task)taskList.get(0);
                    map.put("taskName", task.getName());
                } else {
                    CommonCode cardState = this.commonCodeService.getByCode(device.getState(), "2001");
                    map.put("taskName", cardState != null ? cardState.getName() : "");
                }
                map.put("sate", device.getState());
                map.put("id", device.getId());
                map.put("name", personb.getNAME());
                map.put("code", personb.getCODE());
                map.put("depname", personb.getDEPNAME());
                map.put("identifier", personb.getIDENTIFIER());
                map.put("mobile", device.getMobile() != null ? device.getMobile().getMobile() : "");
                CommonCode cardtype = this.commonCodeService.getByCode(device.getType(), "2000");
                map.put("cardtype", cardtype != null ? cardtype.getName() : "");
                CommonCode usetype = this.commonCodeService.getByCode(device.getUseType(), "useType");
                map.put("usetype", usetype != null ? usetype.getName() : "");
                CommonCode commType = this.commonCodeService.getByCode(device.getCommType(), "2015");
                map.put("commType", commType != null ? commType.getName() : "");
                map.put("devicename", device.getName());
                listmap.add(map);
            }
            operateResult = true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(page.getTotal()));
        map.put("rows", listmap);
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/jwtapply/jwtapplycontroller/toJwtApplyInfo.do"})
    public String toJwtApplyInfo(HttpServletRequest request, HttpServletResponse response, String id, ModelMap map) {
        Device device = this.deviceService.get((Serializable)((Object)id));
        Person person = this.userManageService.queryPersonById(device.getPersonId());
        map.put((Object)"person", (Object)person);
        map.put((Object)"device", (Object)device);
        CommonCode sex = this.commonCodeService.getByCode(person.getSex(), "sex");
        map.put((Object)"sex", (Object)(sex != null ? sex.getName() : ""));
        CommonCode position = this.commonCodeService.getByCode(person.getPosition(), "2011");
        map.put((Object)"position", (Object)(position != null ? position.getName() : ""));
        CommonCode police = this.commonCodeService.getByCode(person.getPolice(), "2012");
        map.put((Object)"police", (Object)(police != null ? police.getName() : ""));
        CommonCode cardtype = this.commonCodeService.getByCode(device.getType(), "2000");
        map.put((Object)"cardtype", (Object)(cardtype != null ? cardtype.getName() : ""));
        CommonCode usetype = this.commonCodeService.getByCode(device.getUseType(), "useType");
        map.put((Object)"usetype", (Object)(usetype != null ? usetype.getName() : ""));
        CommonCode commType = this.commonCodeService.getByCode(device.getCommType(), "2015");
        map.put((Object)"commType", (Object)(commType != null ? commType.getName() : ""));
        map.put((Object)"devicename", (Object)device.getName());
        Terminal terminal = device.getTerminal();
        CommonCode terminalband = this.commonCodeService.getByCode(terminal.getTerminalband(), "2021");
        map.put((Object)"terminalband", (Object)(terminalband != null ? terminalband.getName() : ""));
        map.put((Object)"terminalname", (Object)terminal.getTerminalname());
        CommonCode terminalos = this.commonCodeService.getByCode(terminal.getTerminalos(), "2022");
        map.put((Object)"terminalos", (Object)(terminalos != null ? terminalos.getName() : ""));
        CommonCode terminaltype = this.commonCodeService.getByCode(terminal.getTerminaltype(), "2020");
        map.put((Object)"terminaltype", (Object)(terminaltype != null ? terminaltype.getName() : ""));
        return "jwtApply/default/jwtApplyInfo";
    }
}

