/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.jwzs.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.jwzs.bean.BLLCBean;
import com.xdja.pams.jwzs.entity.BLLC;
import com.xdja.pams.jwzs.service.BllcService;
import com.xdja.pams.logms.service.SystemLogService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class BllcControler
extends BaseControler {
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private BllcService bllcService;
    @Autowired
    private ResourceBundleMessageSource message;
    private static final Logger log = LoggerFactory.getLogger(BllcControler.class);
    private static final String STR_PID = "pid";
    private static final String STR_PARENT_ID = "person_id";
    private static final String STR_ID = "id";
    private static final String STR_TITLE = "title";
    private static final String STR_TYPE = "type";
    private static final String TYPE_BT = "bt";
    private static final String TYPE_NR = "nr";
    private static final String TYPE_LX = "lx";
    private static final String ROOTID = "0";

    @RequestMapping(value={"/jwzs/BllcControler/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            map.put((Object)STR_PARENT_ID, (Object)this.person.getId());
            map.put((Object)STR_PID, (Object)0);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/jwzs/BllcControler/list.do"})
    public void list(HttpServletRequest request, HttpServletResponse response, PageParam page, BLLCBean bean) {
        int operateResult = 1;
        try {
            Page p = new Page(page.getPage(), page.getRows());
            List<BLLC> list = this.bllcService.queryList(bean, p);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("total", p.getTotal());
            map.put("rows", list);
            Util.writeUtf8Text(response, Util.toJsonStr(map));
        }
        catch (Exception e) {
            operateResult = 0;
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/jwzs/BllcControler/getById.do"})
    public void getById(int id, HttpServletResponse response) {
        BLLC person = this.bllcService.queryById(id);
        Util.writeUtf8JSON(response, Util.toJsonStr(person));
    }

    @RequestMapping(value={"/jwzs/BllcControler/forwardUpdatePage.do"})
    public String forwardUpdatePage(String id, ModelMap map) {
        map.put((Object)STR_ID, (Object)id);
        return "jwzs/bllc/default/update";
    }

    @RequestMapping(value={"/jwzs/BllcControler/forwardUpdateLCPage.do"})
    public String forwardUpdateLCPage(String id, String pid, ModelMap map) {
        map.put((Object)STR_ID, (Object)id);
        map.put((Object)STR_PID, (Object)pid);
        return "jwzs/bllc/default/updatelc";
    }

    @RequestMapping(value={"/jwzs/BllcControler/forwardAddPage.do"})
    public String forwardAddPage(String pid, ModelMap map) {
        map.put((Object)STR_PID, (Object)pid);
        return "jwzs/bllc/default/add";
    }

    @RequestMapping(value={"/jwzs/BllcControler/forwardAddLCPage.do"})
    public String forwardAddLCPage(String pid, ModelMap map) {
        map.put((Object)STR_PID, (Object)pid);
        return "jwzs/bllc/default/addlc";
    }

    @RequestMapping(value={"/jwzs/BllcControler/save.do"})
    public void save(BLLC bean, HttpServletResponse response, HttpServletRequest request) throws IOException {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            int pid = Integer.parseInt(bean.getPid());
            List<BLLC> list = this.bllcService.queryByPid(bean.getPid());
            if (pid > 12 && list.size() >= 1) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg("\u53ea\u80fd\u6dfb\u52a0\u4e00\u6761\u6570\u636e");
                operateResult = 0;
            } else {
                this.bllcService.save(bean);
                rtnResult.setRtnCode(ROOTID);
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = 0;
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/jwzs/BllcControler/update.do"})
    public void update(BLLC bean, HttpServletResponse response, HttpServletRequest request) throws IOException {
        int operateResult = 1;
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.bllcService.update(bean);
            rtnResult.setRtnCode(ROOTID);
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = 0;
            log.error(e.getMessage(), (Throwable)e);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/jwzs/BllcControler/del.do"})
    public void del(int id, HttpServletResponse response, HttpServletRequest request) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            this.bllcService.deleteAndChild(Integer.toString(id));
            rtnResult.setRtnCode(ROOTID);
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = 0;
            log.error(e.getMessage(), (Throwable)e);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/jwzs/BllcControler/getChild.do"})
    public void getChild(String pid, HttpServletResponse response, PageParam page) throws IOException {
        Page p = new Page(page.getPage(), page.getRows());
        BLLCBean bean = new BLLCBean();
        bean.setPid(pid);
        List<BLLC> list = this.bllcService.queryList(bean, p);
        ArrayList listmap = new ArrayList();
        HashMap<String, String> map0 = new HashMap<String, String>();
        map0.put(STR_ID, "");
        map0.put(STR_TITLE, MessageManager.getProMessage(this.message, "commontree.commoncode.select"));
        listmap.add(map0);
        for (BLLC code : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(STR_ID, code.getId());
            map.put(STR_PID, code.getPid());
            map.put(STR_TITLE, code.getTitle());
            listmap.add(map);
        }
        String jsonlist = Util.toJsonStr(listmap);
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/jwzs/BllcControler/getChildTree.do"})
    public void getChildTree(String id, String type, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)id)) {
            Util.writeUtf8Text(response, "[{\"text\":\"" + MessageManager.getProMessage(this.message, "jwzs.bllc.controller.ywlx") + "\",\"id\":\"0\",\"state\":\"closed\"}]");
            return;
        }
        BLLCBean bean = new BLLCBean();
        bean.setPid(id);
        List<BLLC> list = this.bllcService.queryList(bean, null);
        ArrayList listmap = new ArrayList();
        for (BLLC code : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(STR_ID, code.getId());
            map.put("text", code.getTitle());
            if (TYPE_BT.equals(type)) {
                map.put("text", MessageManager.getProMessage(this.message, "jwzs.bllc.controller.nr"));
            } else {
                map.put("state", "closed");
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(STR_PID, code.getPid());
            if (ROOTID.equals(id)) {
                attributes.put(STR_TYPE, TYPE_LX);
            } else {
                if (TYPE_LX.equals(type)) {
                    attributes.put(STR_TYPE, TYPE_BT);
                }
                if (TYPE_BT.equals(type)) {
                    attributes.put(STR_TYPE, TYPE_NR);
                }
            }
            map.put("attributes", attributes);
            listmap.add(map);
        }
        String jsonlist = Util.toJsonStr(listmap);
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/jwzs/BllcControler/queryPid.do"})
    public void queryPid(int id, HttpServletResponse response, HttpServletRequest request) {
        ReturnResult rtnResult = new ReturnResult();
        boolean operateResult = true;
        try {
            BLLC bllc = this.bllcService.queryById(id);
            rtnResult.setData(bllc);
            rtnResult.setRtnCode(ROOTID);
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = false;
            log.error(e.getMessage(), (Throwable)e);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }
}

