/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.login.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.Md5PwdEncoder;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.LoginForm;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.login.service.LoginService;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.LegalIPService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.upms.entity.SysPower;
import com.xdja.pams.upms.service.UserPowerService;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class LoginControler
extends BaseControler {
    @Autowired
    private UserManageService userManage;
    @Autowired
    private LoginService loginService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private LegalIPService legalIPService;
    @Autowired
    private UserPowerService userPowerService;
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private ResourceBundleMessageSource message;
    private static final Logger log = LoggerFactory.getLogger(LoginControler.class);

    @RequestMapping(value={"/login/loginControler/login.do"})
    public void login(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        String sendUrl = "/login/loginControler/toLoginPage.do";
        try {
            String isSSO = (String)request.getAttribute("isSSO");
            if ("true".equals(isSSO)) {
                sendUrl = "/login/loginControler/loginValidate4SSO.do";
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u662f\u5426\u96c6\u6210SSO\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        try {
            request.getRequestDispatcher(sendUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.error("\u767b\u5f55\u9a8c\u8bc1\u4e8c\u6b21\u8df3\u8f6c\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    @RequestMapping(value={"/login/loginControler/toLoginPage.do"})
    public String toLoginPage(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        String systemThreme = "s_blue";
        try {
            systemThreme = this.systemConfigPbService.getValueByCode("systemTheme");
            String systemName = this.systemConfigPbService.getValueByCode("systemName");
            String copyrightInfo = this.systemConfigPbService.getValueByCode("copyrightInfo");
            map.put((Object)"systemName", (Object)systemName);
            map.put((Object)"copyrightInfo", (Object)copyrightInfo);
            if (request.getAttribute("rst") != null) {
                map.put((Object)"rst", request.getAttribute("rst"));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)systemThreme)) {
            systemThreme = "s_blue";
        }
        return "login/" + systemThreme + "/login";
    }

    @RequestMapping(value={"/login/loginControler/loginValidate4SSO.do"})
    public String loginValidate4SSO(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/errorSSO";
        try {
            String loginUser = request.getRemoteUser();
            if (Util.varCheckEmp(loginUser)) {
                log.debug("SSO\u540e\u83b7\u53d6\u767b\u5f55\u7528\u6237\u5931\u8d25");
                map.put((Object)"rtnMessage", (Object)MessageManager.getProMessage(this.message, "common.message.operate.fail"));
                return sendUrl;
            }
            LoginForm login = new LoginForm();
            login.setName(loginUser);
            ReturnResult rtnResult = this.loginValidateCommon(request, true, login, null);
            if ("0".equals(rtnResult.getRtnCode())) {
                sendUrl = "/login/loginControler/index.do";
                try {
                    request.getRequestDispatcher(sendUrl).forward((ServletRequest)request, (ServletResponse)response);
                    return null;
                }
                catch (Exception e) {
                    log.error("SSO\u540e\u8df3\u8f6c\u81f3\u9996\u9875\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                    map.put((Object)"rtnMessage", (Object)MessageManager.getProMessage(this.message, "common.message.operate.fail"));
                }
            } else {
                map.put((Object)"rtnMessage", (Object)rtnResult.getRtnMsg());
            }
        }
        catch (Exception e) {
            log.error("SSO\u767b\u5f55\u9a8c\u8bc1\u540e\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            map.put((Object)"rtnMessage", (Object)MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/login/loginControler/loginValidate4Cer.do"})
    public void loginValidate4Cer(HttpServletRequest request, HttpServletResponse response, LoginForm login, ModelMap map) {
        ReturnResult rtnResult = new ReturnResult();
        String sendUrl = "error/error";
        String scheme = request.getScheme();
        try {
            if (scheme.equals("https")) {
                X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
                if (certs == null) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg("\u767b\u5f55\u5931\u8d25\uff01\u672a\u63d0\u4ea4\u8bc1\u4e66\uff01");
                } else {
                    X509Certificate gaX509Cert = null;
                    gaX509Cert = certs[0];
                    String dn = gaX509Cert.getSubjectDN().toString();
                    String[] strMyList = dn.split(" ");
                    String[] sfzhs = strMyList[1].split(",");
                    String sfzh = sfzhs[0];
                    rtnResult = this.loginValidateCommon4Cer(request, sfzh);
                }
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg("\u767b\u5f55\u5931\u8d25\uff01\u8bf7\u4f7f\u7528HTTPS\u8bf7\u6c42\u767b\u5f55\uff01");
            }
            sendUrl = "0".equals(rtnResult.getRtnCode()) ? "/login/loginControler/index.do" : "/login/loginControler/login.do";
            rtnResult.setUrl(sendUrl);
            request.setAttribute("rst", (Object)rtnResult);
            request.getRequestDispatcher(sendUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.error("\u8bc1\u4e66\u767b\u5f55\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/login/loginControler/loginValidate.do"})
    public void loginValidate(HttpServletRequest request, HttpServletResponse response, LoginForm login, ModelMap map) {
        ReturnResult rtnResult = null;
        String sendUrl = "error/error";
        String sessionVerticode = (String)request.getSession().getAttribute("vertificationCode");
        rtnResult = this.loginValidateCommon(request, false, login, sessionVerticode);
        if ("0".equals(rtnResult.getRtnCode())) {
            sendUrl = "/login/loginControler/index.do";
        }
        rtnResult.setUrl(sendUrl);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    private ReturnResult loginValidateCommon(HttpServletRequest request, boolean isSSO, LoginForm login, String sessionVerticode) {
        ReturnResult rtnResult;
        block19: {
            rtnResult = new ReturnResult();
            int operateResult = 1;
            try {
                String loginIp = Util.getRemortIP(request);
                if ("1".equals(this.systemConfigPbService.getValueByCode("checkIp")) && !this.legalIPService.checkIP(loginIp, null)) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "login.error.msg.ip"));
                    operateResult = 0;
                    break block19;
                }
                if (!(isSSO || sessionVerticode != null && sessionVerticode.equalsIgnoreCase(login.getVertiCode()))) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "login.error.msg.validatecode"));
                    operateResult = 0;
                    break block19;
                }
                Person person = this.userManage.getUserByCode(login.name);
                if (!isSSO && person == null) {
                    person = this.userManage.getUserByMobile(login.name);
                } else if (isSSO && person == null) {
                    person = this.userManage.getUserByIdentifer(login.name);
                }
                if (person == null) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "login.error.msg.police"));
                    operateResult = 0;
                    return rtnResult;
                }
                if (this.loginService.judgeIslock(person)) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "login.error.msg.lock"));
                    operateResult = 0;
                } else if (this.loginService.judgeIslock2(person)) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "login.error.msg.lock2"));
                    operateResult = 0;
                } else if (!isSSO && !Md5PwdEncoder.getInstance().encodePassword(login.getPassword()).equals(person.getPassword())) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "login.error.msg.pass"));
                    operateResult = 0;
                    person.setLoginErrorTimes(person.getLoginErrorTimes() + 1);
                    this.userManage.updateUserNotUpdateLastupdatetime(person);
                } else {
                    Map<String, SysPower> mapPower = this.userPowerService.queryPersonRoleList(person.getId());
                    if (mapPower == null) {
                        rtnResult.setRtnCode("1");
                        rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "login.error.msg.power"));
                        operateResult = 0;
                    }
                    person.setLoginErrorTimes(0);
                    this.userManage.updateUserNotUpdateLastupdatetime(person);
                    Operator operator = new Operator();
                    operator.setPerson(person);
                    operator.setLoginIp(Util.getRemortIP(request));
                    operator.setTopFunctions(mapPower);
                    request.getSession().setAttribute("operator", (Object)operator);
                    rtnResult.setRtnCode("0");
                    if ("1".equals(this.systemConfigPbService.getValueByCode("isOtherLogin"))) {
                        ServletContext sc = request.getSession().getServletContext();
                        HttpSession tmpSession = (HttpSession)sc.getAttribute(person.getCode());
                        if (tmpSession != null) {
                            sc.removeAttribute(person.getCode());
                            try {
                                tmpSession.invalidate();
                            }
                            catch (IllegalStateException e1) {
                                log.info("session\u5df2\u7ecf\u9500\u6bc1\u3002");
                            }
                        }
                        sc.setAttribute(person.getCode(), (Object)request.getSession());
                    }
                }
                this.systemLogService.saveLoginLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), Util.getRemortIP(request), operateResult, "", "", "");
            }
            catch (Exception e) {
                log.error("\u767b\u5f55\u9a8c\u8bc1\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        return rtnResult;
    }

    private ReturnResult loginValidateCommon4Cer(HttpServletRequest request, String identifier) {
        ReturnResult rtnResult;
        block13: {
            rtnResult = new ReturnResult();
            int operateResult = 1;
            try {
                String loginIp = Util.getRemortIP(request);
                if ("1".equals(this.systemConfigPbService.getValueByCode("checkIp")) && !this.legalIPService.checkIP(loginIp, null)) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "login.error.msg.ip"));
                    operateResult = 0;
                    break block13;
                }
                Person person = this.userManage.getUserByIdentifer(identifier);
                if (person == null) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "login.error.msg.police"));
                    operateResult = 0;
                    return rtnResult;
                }
                if (this.loginService.judgeIslock(person)) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "login.error.msg.lock"));
                    operateResult = 0;
                } else if (this.loginService.judgeIslock2(person)) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "login.error.msg.lock2"));
                    operateResult = 0;
                } else {
                    Map<String, SysPower> mapPower = this.userPowerService.queryPersonRoleList(person.getId());
                    if (mapPower == null) {
                        rtnResult.setRtnCode("1");
                        rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "login.error.msg.power"));
                        operateResult = 0;
                    }
                    person.setLoginErrorTimes(0);
                    this.userManage.updateUserNotUpdateLastupdatetime(person);
                    Operator operator = new Operator();
                    operator.setPerson(person);
                    operator.setLoginIp(Util.getRemortIP(request));
                    operator.setTopFunctions(mapPower);
                    request.getSession().setAttribute("operator", (Object)operator);
                    rtnResult.setRtnCode("0");
                    if ("1".equals(this.systemConfigPbService.getValueByCode("isOtherLogin"))) {
                        ServletContext sc = request.getSession().getServletContext();
                        HttpSession tmpSession = (HttpSession)sc.getAttribute(person.getCode());
                        if (tmpSession != null) {
                            sc.removeAttribute(person.getCode());
                            try {
                                tmpSession.invalidate();
                            }
                            catch (IllegalStateException e1) {
                                log.info("session\u5df2\u7ecf\u9500\u6bc1\u3002");
                            }
                        }
                        sc.setAttribute(person.getCode(), (Object)request.getSession());
                    }
                }
                this.systemLogService.saveLoginLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), Util.getRemortIP(request), operateResult, "", "", "");
            }
            catch (Exception e) {
                log.error("\u767b\u5f55\u9a8c\u8bc1\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        return rtnResult;
    }

    @RequestMapping(value={"/login/loginControler/loginOut.do"})
    public void loginOut(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        try {
            request.getSession().invalidate();
            this.login(request, response, map);
        }
        catch (Exception e) {
            log.error("\u767b\u51fa\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
        }
    }

    @RequestMapping(value={"/login/loginControler/getVerificateCode.do"})
    public void getVerificateCode(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "No-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
        int width = 85;
        int height = 30;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics g = image.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        Random random = new Random();
        Font mfont = new Font("\u534e\u6587\u5b8b\u4f53", 1, 30);
        g.setColor(this.getRandColor(200, 250));
        g.fillRect(0, 0, width, height);
        g.setFont(mfont);
        g.setColor(this.getRandColor(180, 200));
        for (int i = 0; i < 100; ++i) {
            int x = random.nextInt(width - 1);
            int y = random.nextInt(height - 1);
            int x1 = random.nextInt(6) + 1;
            int y1 = random.nextInt(12) + 1;
            BasicStroke bs = new BasicStroke(2.0f, 0, 2);
            Line2D.Double line = new Line2D.Double(x, y, x + x1, y + y1);
            g2d.setStroke(bs);
            g2d.draw(line);
        }
        String sRand = "";
        String ctmp = "";
        int itmp = 0;
        for (int i = 0; i < 4; ++i) {
            itmp = random.nextInt(2) == 1 ? random.nextInt(26) + 65 : random.nextInt(10) + 48;
            ctmp = String.valueOf((char)itmp);
            sRand = sRand + ctmp;
            Color color = new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110));
            g.setColor(color);
            g.drawString(ctmp, 20 * i, 25);
        }
        HttpSession session = request.getSession(true);
        session.setAttribute("vertificationCode", (Object)sRand);
        g.dispose();
        try {
            ImageIO.write((RenderedImage)image, "JPEG", (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private Color getRandColor(int s, int c) {
        Random random = new Random();
        if (s > 255) {
            s = 255;
        }
        if (c > 255) {
            c = 255;
        }
        int r = s + random.nextInt(c - s);
        int g = s + random.nextInt(c - s);
        int b = s + random.nextInt(c - s);
        return new Color(r, g, b);
    }

    @RequestMapping(value={"/login/loginControler/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        Operator operator = (Operator)request.getSession().getAttribute("operator");
        map.put((Object)"operator", (Object)operator);
        map.put((Object)"menuJson", (Object)Util.toJsonStr(operator.getTopFunctions()));
        String systemName = this.systemConfigPbService.getValueByCode("systemName");
        String copyrightInfo = this.systemConfigPbService.getValueByCode("copyrightInfo");
        String version = this.systemConfigPbService.getValueByCode("version");
        String showchart = this.systemConfigPbService.getValueByCode("showChart");
        map.put((Object)"systemName", (Object)systemName);
        map.put((Object)"copyrightInfo", (Object)copyrightInfo);
        map.put((Object)"version", (Object)version);
        map.put((Object)"showChart", (Object)(showchart == null ? "false" : showchart));
        map.put((Object)"loginUrl", (Object)"/login/loginControler/login.do");
        List<CommonCode> skinList = this.commonCodePbService.queryByType("changeSkin");
        map.put((Object)"skinList", skinList);
        String theme = operator.getPerson().getTheme();
        if (Util.varCheckEmp(theme)) {
            theme = "s_blue";
        }
        map.put((Object)"skin", (Object)theme);
        return "index";
    }
}

