/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.lsbk.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.lsbk.bean.CarControlBean;
import com.xdja.pams.lsbk.dao.CarControlDao;
import com.xdja.pams.lsbk.entity.CarControl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CarControlDaoImpl
implements CarControlDao {
    @Autowired
    private BaseDao baseDao;
    private static final Logger log = LoggerFactory.getLogger(CarControlDaoImpl.class);

    @Override
    public CarControl queryById(String id) {
        return (CarControl)this.baseDao.getObjectById(CarControl.class, (Serializable)((Object)id));
    }

    @Override
    public List<CarControl> queryList(CarControlBean carControlBean, Page page) {
        StringBuilder select = new StringBuilder("from CarControl where 1=1 ");
        ArrayList<Object> list = new ArrayList<Object>();
        if (carControlBean != null) {
            if (StringUtils.isNotBlank((CharSequence)carControlBean.getHphm())) {
                select.append(" and hphm like ?");
                list.add("%" + carControlBean.getHphm() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)carControlBean.getKssj())) {
                select.append(" and kssj >= ?");
                try {
                    Date startDate = Util.parseDate(carControlBean.getKssj() + " 00:00:00", "yyyy-MM-dd HH:mm:ss");
                    list.add(startDate);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)carControlBean.getJssj())) {
                select.append(" and jssj <= ?");
                try {
                    Date endDate = Util.parseDate(carControlBean.getJssj() + " 23:59:59", "yyyy-MM-dd HH:mm:ss");
                    list.add(endDate);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        String selectCount = "select count(*) " + select.toString();
        Object[] values = null;
        if (list.size() > 0) {
            values = list.toArray(new Object[0]);
        }
        log.info(selectCount);
        return this.baseDao.getListByHQL(selectCount, select.toString() + "order by jssj desc", values, page);
    }

    @Override
    public CarControl save(CarControl bean) {
        this.baseDao.create(bean);
        return bean;
    }

    @Override
    public void update(CarControl bean) {
        this.baseDao.update(bean);
    }
}

