/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.pamsapi.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.data.ResponseBean;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.http.RequestApi;
import com.xdja.pams.http.ResponseApi;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.SystemConfigService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class PamsApiController
extends BaseControler {
    private static final Logger LOG = LoggerFactory.getLogger(PamsApiController.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemConfigService systemConfigService;

    @RequestMapping(value={"pamsapi/PamsApiController/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        LOG.info("pamsapi/PamsApiController/index.do");
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            map.put((Object)"personId", (Object)this.person.getId());
        }
        catch (Exception e) {
            LOG.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"pamsapi/PamsApiController/api.do"})
    public void callApi(HttpServletRequest request, HttpServletResponse response) {
        LOG.info("pamsapi/PamsApiController/api.do");
        RequestApi api = new RequestApi(this.getApiUrl());
        try {
            String param = request.getParameter("_param");
            String page = request.getParameter("page");
            String pageSize = request.getParameter("rows");
            String jsonPage = RequestApi.toJsonPage((String)param, (String)page, (String)pageSize);
            LOG.info("param:   " + jsonPage);
            String result = api.post(jsonPage);
            LOG.info("result:   " + result);
            ResponseApi.writeJson((HttpServletResponse)response, (String)result);
        }
        catch (Exception e) {
            LOG.error("\u8bf7\u6c42api\u51fa\u9519", (Throwable)e);
        }
    }

    @RequestMapping(value={"pamsapi/PamsApiController/apiData.do"})
    public void callApiData(HttpServletRequest request, HttpServletResponse response) {
        LOG.info("pamsapi/PamsApiController/apiData.do");
        RequestApi api = new RequestApi(this.getApiUrl());
        try {
            String param = request.getParameter("_param");
            String page = request.getParameter("page");
            String pageSize = request.getParameter("rows");
            String jsonPage = RequestApi.toJsonPage((String)param, (String)page, (String)pageSize);
            LOG.info("param:   " + jsonPage);
            String result = api.post(jsonPage);
            LOG.info("result:   " + result);
            ResponseBean responseBean = ResponseApi.toResponseBean((String)result);
            String rows = responseBean.getRows();
            LOG.info("rows:   " + rows);
            ResponseApi.writeJson((HttpServletResponse)response, (String)rows);
        }
        catch (Exception e) {
            LOG.error("\u8bf7\u6c42apiData\u51fa\u9519", (Throwable)e);
        }
    }

    @RequestMapping(value={"pamsapi/PamsApiController/nextPage.do"})
    public String nextPage(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        LOG.info("pamsapi/PamsApiController/apiPage.do");
        String nextPage = request.getParameter("nextPage");
        LOG.info("nextPage: " + nextPage);
        try {
            String param = request.getParameter("_param");
            if (StringUtils.isNotBlank((CharSequence)param)) {
                RequestApi api = new RequestApi(this.getApiUrl());
                String page = request.getParameter("page");
                String pageSize = request.getParameter("rows");
                String jsonPage = RequestApi.toJsonPage((String)param, (String)page, (String)pageSize);
                LOG.info("param:   " + jsonPage);
                String result = api.post(jsonPage);
                LOG.info("result:   " + result);
                ResponseBean responseBean = ResponseApi.toResponseBean((String)result);
                String rows = responseBean.getRows();
                LOG.info("rows:   " + rows);
                model.put((Object)"rows", (Object)rows);
            }
        }
        catch (Exception e) {
            LOG.error("\u8bf7\u6c42nextPage\u51fa\u9519", (Throwable)e);
        }
        return nextPage;
    }

    private String getApiUrl() {
        String pamsUrl = this.systemConfigService.getValueByCode("PAMS_API_URL");
        return pamsUrl;
    }
}

