/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.report.util;

import com.xdja.pams.common.util.Base64Encrypt;
import com.xdja.pams.report.entity.LeafNode;
import com.xdja.pams.report.entity.RequestContent;
import com.xdja.pams.report.util.ReportUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestXmlReader {
    private static final Logger log = LoggerFactory.getLogger(RequestXmlReader.class);
    private String proFilePath;
    private String picPath = "/gprsQQNR/";
    private List<LeafNode> elemList;
    private String type = "";
    private String attribute = "";
    private String id = "";
    private int picNum = 0;

    public RequestXmlReader(String proPicPath, String id) {
        this.proFilePath = proPicPath + this.picPath;
        this.elemList = new ArrayList<LeafNode>();
        this.id = id;
    }

    public RequestContent getReqContent(String strXml) {
        try {
            Element root = this.getRootElement(strXml);
            this.getElementList(root);
        }
        catch (DocumentException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        RequestContent requestContent = new RequestContent();
        requestContent.setType(this.type);
        requestContent.setNodeList(this.elemList);
        return requestContent;
    }

    public Element getRootElement(String strXml) throws DocumentException {
        Document srcdoc = DocumentHelper.parseText((String)strXml);
        Element elem = srcdoc.getRootElement();
        Element reqTypeElement = elem.element("ReqType");
        Element tranElement = elem.element("TransactionType");
        this.type = "login".compareToIgnoreCase(reqTypeElement.getTextTrim()) == 0 ? "\u767b\u5f55\u8bf7\u6c42" : (tranElement != null ? "\u91c7\u96c6\u64cd\u4f5c\u8bf7\u6c42" : "\u67e5\u8be2\u64cd\u4f5c\u8bf7\u6c42");
        return elem;
    }

    public void getElementList(Element element) {
        List elements = element.elements();
        if (elements.size() == 0) {
            this.attribute = element.attributeValue("Type");
            if (StringUtils.isNotBlank((CharSequence)this.attribute) && StringUtils.equals((CharSequence)this.attribute, (CharSequence)"blob")) {
                String tempPath = this.proFilePath + this.id + this.picNum + ".jpg";
                try {
                    FileOutputStream fos = new FileOutputStream(new File(tempPath));
                    Base64Encrypt base64 = new Base64Encrypt();
                    fos.write(base64.encodeByteArr(element.getTextTrim()));
                    fos.close();
                }
                catch (FileNotFoundException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                String name = element.getName();
                String value = "<a href=\"javascript:displayPic('" + this.id + this.picNum + "')\">\u67e5\u770b\u56fe\u7247</a>";
                this.elemList.add(new LeafNode(this.toChinaese(name), value));
                ++this.picNum;
            } else {
                String name = element.getName();
                String value = element.getTextTrim();
                value = value.replaceAll("<", "&lt;");
                value = value.replaceAll(">", "&gt;");
                this.elemList.add(new LeafNode(this.toChinaese(name), value));
            }
        } else {
            for (Element elem : elements) {
                this.getElementList(elem);
            }
        }
    }

    private String toChinaese(String strCode) {
        String strReturn = strCode;
        String[][] codes = new String[][]{{"ReqType", "\u8bf7\u6c42\u7c7b\u578b"}, {"SessionID", "\u4f1a\u8bddID"}, {"DataSource", "\u6570\u636e\u6e90"}, {"Condition", "\u6761\u4ef6"}, {"Version", "\u7248\u672c\u53f7"}, {"TransactionType", "\u4f20\u8f93\u7c7b\u578b"}, {"Name", "\u8868\u540d"}, {"IsMain", "\u662f\u5426\u4e3b\u8868"}, {"Operate", "\u64cd\u4f5c\u7c7b\u578b"}, {"BeginNo", "\u5f00\u59cb\u8bb0\u5f55\u6570"}};
        int codesLength = codes.length;
        for (int i = 0; i < codesLength; ++i) {
            if (!StringUtils.equals((CharSequence)strCode, (CharSequence)codes[i][0])) continue;
            strReturn = codes[i][1];
            break;
        }
        return ReportUtil.getFieldName(strReturn);
    }

    public static void main(String[] args) throws DocumentException {
        String srcXml = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root><Version>20071115</Version><ReqType>wzlrdzjclr</ReqType><SessionID>30000010386</SessionID><TransactionType>1</TransactionType><Tables><Table><Name>t_jtwf_wfcj</Name><IsMain>1</IsMain><Row><Operate>insert</Operate><Data><c_id Type=\"varchar\">\u82cfC666660220081104104511</c_id><c_cjfs Type=\"varchar\">4</c_cjfs><c_cllx Type=\"varchar\">B11</c_cllx><c_wfdd Type=\"varchar\">10311</c_wfdd><d_wfsj Type=\"date\" Format=\"yyyyMMddHHmmss\">20081104104325</d_wfsj><c_hphm Type=\"varchar\">\u82cfC66666</c_hphm><c_hpzl Type=\"varchar\">02</c_hpzl><c_cjr Type=\"varchar\">320303</c_cjr><c_wfxw Type=\"varchar\">1042100</c_wfxw><c_gzzt Type=\"varchar\">1</c_gzzt><c_cjdw Type=\"varchar\">450342520000</c_cjdw></Data><Condition></Condition></Row></Table><Table><Name>t_jtwf_wfcj_zp</Name><IsMain>0</IsMain><Row><Operate>insert</Operate><Data><b_zp Type=\"blob\">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</b_zp><c_id Type=\"varchar\">\u82cfC666660220081104104511</c_id></Data><Condition></Condition></Row></Table></Tables></Root>";
        RequestXmlReader test = new RequestXmlReader("d:", "1");
        RequestContent requestContent = test.getReqContent(srcXml);
        for (LeafNode node : requestContent.getNodeList()) {
            System.out.println(node.getName());
        }
    }
}

