/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.rptms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.rptms.bean.ConditionBean;
import com.xdja.pams.rptms.service.ConditionManagerService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class ConditionManagerControler
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ConditionManagerService conditionManagerService;
    private static final Logger log = LoggerFactory.getLogger(ConditionManagerControler.class);

    @RequestMapping(value={"/rptms/conditionmanager/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ModelMap map) {
        log.debug("##########\u62a5\u8868\u6761\u4ef6\u7ba1\u7406\u9996\u9875\u9762\u5c55\u793a<\u5f00\u59cb>##########");
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, pageParam.getMenuId(), pageParam.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error("#\u62a5\u8868\u6761\u4ef6\u7ba1\u7406\u9996\u9875\u9762\u5c55\u793a\u5931\u8d25", (Throwable)e);
            map.put((Object)"errMsg", (Object)(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage()));
        }
        log.debug("##########\u62a5\u8868\u6761\u4ef6\u7ba1\u7406\u9996\u9875\u9762\u5c55\u793a<\u7ed3\u675f>##########");
        return sendUrl;
    }

    @RequestMapping(value={"/rptms/conditionmanager/queryConditionList.do"})
    public String queryConditionList(HttpServletRequest request, HttpServletResponse response, ConditionBean conditionBean, PageParam pageParam) {
        log.debug("##########\u62a5\u8868\u6761\u4ef6\u67e5\u8be2<\u5f00\u59cb>##########");
        HashMap<String, Serializable> rtnMap = new HashMap<String, Serializable>();
        int operateResult = 1;
        try {
            Page page = new Page(pageParam.getPage(), pageParam.getRows());
            ArrayList rtnList = this.conditionManagerService.queryConditionList(conditionBean, page);
            rtnMap.put("total", Integer.valueOf(page.getTotal()));
            rtnMap.put("rows", rtnList == null ? new ArrayList() : rtnList);
        }
        catch (Exception e) {
            log.error("#\u62a5\u8868\u6761\u4ef6\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            operateResult = 0;
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnMap));
        log.debug("##########\u62a5\u8868\u6761\u4ef6\u67e5\u8be2<\u7ed3\u675f>##########");
        return null;
    }

    @RequestMapping(value={"/rptms/conditionmanager/toAddConditon.do"})
    public String toAddConditon(HttpServletRequest request, HttpServletResponse response, PageParam pageParam) {
        return pageParam.getSendUrl();
    }

    @RequestMapping(value={"/rptms/conditionmanager/addCondition.do"})
    public String addCondition(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ConditionBean conditionBean) {
        log.debug("##########\u62a5\u8868\u6761\u4ef6\u6dfb\u52a0<\u5f00\u59cb>##########");
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            this.setOperator(request);
            conditionBean.setCreatorId(this.operator.getPerson().getId());
            this.conditionManagerService.addCondition(conditionBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("#\u62a5\u8868\u6761\u4ef6\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        log.debug(Util.toJsonStr(rtnResult));
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
        log.debug("##########\u62a5\u8868\u6761\u4ef6\u6dfb\u52a0<\u7ed3\u675f>##########");
        return null;
    }

    @RequestMapping(value={"/rptms/conditionmanager/toEditConditon.do"})
    public String toEditConditon(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ModelMap map, String conditionId) {
        log.debug("##########\u62a5\u8868\u6761\u4ef6\u4fee\u6539_\u8df3\u8f6c<\u5f00\u59cb>##########");
        ConditionBean conditoinBean = null;
        try {
            conditoinBean = this.conditionManagerService.getConditionById(conditionId);
        }
        catch (Exception e) {
            log.error("#\u62a5\u8868\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            conditoinBean = new ConditionBean();
            map.put((Object)"errMsg", (Object)(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage()));
        }
        map.put((Object)"data", (Object)conditoinBean);
        log.debug("##########\u62a5\u8868\u6761\u4ef6\u4fee\u6539_\u8df3\u8f6c<\u7ed3\u675f>##########");
        return pageParam.getSendUrl();
    }

    @RequestMapping(value={"/rptms/conditionmanager/editCondition.do"})
    public String editCondition(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ConditionBean conditionBean) {
        log.debug("##########\u62a5\u8868\u6761\u4ef6\u4fee\u6539<\u5f00\u59cb>##########");
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            this.conditionManagerService.editCondition(conditionBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("#\u4fee\u6539\u62a5\u8868\u6761\u4ef6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        log.debug(Util.toJsonStr(rtnResult));
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
        log.debug("##########\u62a5\u8868\u6761\u4ef6\u4fee\u6539<\u7ed3\u675f>##########");
        return null;
    }

    @RequestMapping(value={"/rptms/conditionmanager/delCondition.do"})
    public String delCondition(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ConditionBean conditionBean) {
        log.debug("##########\u62a5\u8868\u6761\u4ef6\u5220\u9664<\u5f00\u59cb>##########");
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            this.conditionManagerService.delCondition(conditionBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("#\u5220\u9664\u62a5\u8868\u6761\u4ef6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
        log.debug(Util.toJsonStr(rtnResult));
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
        log.debug("##########\u62a5\u8868\u6761\u4ef6\u5220\u9664<\u7ed3\u675f>##########");
        return null;
    }

    @RequestMapping(value={"/rptms/conditionmanager/autoSelectConditon.do"})
    public String autoSelectConditon(HttpServletResponse response, HttpServletRequest request, ConditionBean conditionBean, String q) {
        log.debug("##########\u62a5\u8868\u6761\u4ef6\u81ea\u52a8\u8865\u5168<\u5f00\u59cb>##########");
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            conditionBean.setQueryKey(q);
            List<ConditionBean> list = this.conditionManagerService.queryConditionList(conditionBean, null);
            map.put("total", list.size());
            map.put("rows", list);
        }
        catch (Exception e) {
            log.error("#\u62a5\u8868\u6761\u4ef6\u81ea\u52a8\u8865\u5168\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text(response, Util.toJsonStr(map));
        log.debug("##########\u62a5\u8868\u6761\u4ef6\u81ea\u52a8\u8865\u5168<\u7ed3\u675f>##########");
        return null;
    }
}

