/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.rptms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.rptms.bean.ReportBean;
import com.xdja.pams.rptms.bean.ReportConditionBean;
import com.xdja.pams.rptms.entity.Report;
import com.xdja.pams.rptms.service.ReportManagerService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class ReportManagerControl
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ReportManagerService reportManagerService;
    private static final Logger log = LoggerFactory.getLogger(ReportManagerControl.class);

    @RequestMapping(value={"/rptms/reportmanager/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ModelMap map) {
        log.debug("##########\u4e1a\u52a1\u62a5\u8868\u7ba1\u7406\u9996\u9875\u9762<\u5f00\u59cb>##########");
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, pageParam.getMenuId(), pageParam.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error("#\u6a21\u5757\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            map.put((Object)"errMsg", (Object)(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage()));
        }
        log.debug("##########\u4e1a\u52a1\u62a5\u8868\u7ba1\u7406\u9996\u9875\u9762<\u7ed3\u675f>##########");
        return sendUrl;
    }

    @RequestMapping(value={"/rptms/reportmanager/queryReportList.do"})
    public String queryReportList(HttpServletRequest request, HttpServletResponse response, ReportBean reportBean, PageParam pageParam) {
        log.debug("##########\u4e1a\u52a1\u62a5\u8868\u67e5\u8be2<\u5f00\u59cb>##########");
        HashMap<String, Serializable> rtnMap = new HashMap<String, Serializable>();
        int operateResult = 1;
        try {
            Page page = new Page(pageParam.getPage(), pageParam.getRows());
            ArrayList rtnList = this.reportManagerService.queryReportList(reportBean, page);
            rtnMap.put("total", Integer.valueOf(page.getTotal()));
            rtnMap.put("rows", rtnList == null ? new ArrayList() : rtnList);
        }
        catch (Exception e) {
            log.error("#\u62a5\u8868\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            operateResult = 0;
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnMap));
        log.debug("##########\u4e1a\u52a1\u62a5\u8868\u67e5\u8be2<\u7ed3\u675f>##########");
        return null;
    }

    @RequestMapping(value={"/rptms/reportmanager/toAddReport.do"})
    public String toAddReport(HttpServletRequest request, HttpServletResponse response, PageParam pageParam) {
        return pageParam.getSendUrl();
    }

    @RequestMapping(value={"/rptms/reportmanager/addReport.do"})
    public String addReport(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ReportBean reportBean) {
        log.debug("##########\u4e1a\u52a1\u62a5\u8868\u6dfb\u52a0<\u5f00\u59cb>##########");
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            reportBean.setCreatorId(this.operator.getPerson().getId());
            Report report = this.reportManagerService.addReport(reportBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(report.getReportId());
        }
        catch (Exception e) {
            log.error("#\u62a5\u8868\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        log.debug(Util.toJsonStr(rtnResult));
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
        log.debug("##########\u4e1a\u52a1\u62a5\u8868\u6dfb\u52a0<\u7ed3\u675f>##########");
        return null;
    }

    @RequestMapping(value={"/rptms/reportmanager/toEditReport.do"})
    public String toEditReport(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ModelMap map, String reportId, String tabIdx) {
        log.debug("##########\u4e1a\u52a1\u62a5\u8868\u4fee\u6539_\u8df3\u8f6c<\u5f00\u59cb>##########");
        ReportBean reportBean = null;
        try {
            reportBean = this.reportManagerService.getReportById(reportId);
        }
        catch (Exception e) {
            log.error("#\u62a5\u8868\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            reportBean = new ReportBean();
            map.put((Object)"errMsg", (Object)(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage()));
        }
        map.put((Object)"data", (Object)reportBean);
        map.put((Object)"tabIdx", (Object)(tabIdx == null ? "0" : tabIdx));
        log.debug("##########\u4e1a\u52a1\u62a5\u8868\u4fee\u6539_\u8df3\u8f6c<\u7ed3\u675f>##########");
        return pageParam.getSendUrl();
    }

    @RequestMapping(value={"/rptms/reportmanager/editReportInfo.do"})
    public String editReportInfo(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ReportBean reportBean) {
        log.debug("##########\u4e1a\u52a1\u62a5\u8868\u4fee\u6539<\u5f00\u59cb>##########");
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            this.reportManagerService.editReportInfo(reportBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("#\u4fee\u6539\u62a5\u8868\u57fa\u672c\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        log.debug(Util.toJsonStr(rtnResult));
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
        log.debug("##########\u4e1a\u52a1\u62a5\u8868\u4fee\u6539<\u7ed3\u675f>##########");
        return null;
    }

    @RequestMapping(value={"/rptms/reportmanager/addReportParameter.do"})
    public String addReportParameter(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ReportConditionBean reportConditionBean) {
        log.debug("##########\u4e1a\u52a1\u62a5\u8868_\u6dfb\u52a0\u62a5\u8868\u53c2\u6570<\u5f00\u59cb>##########");
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            this.reportManagerService.addReportParameter(reportConditionBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("#\u62a5\u8868\u53c2\u6570\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        log.debug(Util.toJsonStr(rtnResult));
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
        log.debug("##########\u4e1a\u52a1\u62a5\u8868_\u6dfb\u52a0\u62a5\u8868\u53c2\u6570<\u7ed3\u675f>##########");
        return null;
    }

    @RequestMapping(value={"/rptms/reportmanager/queryReportParameterList.do"})
    public String queryReportParameterList(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ReportConditionBean reportConditionBean) {
        log.debug("##########\u4e1a\u52a1\u62a5\u8868_\u62a5\u8868\u53c2\u6570\u67e5\u8be2<\u5f00\u59cb>##########");
        HashMap<String, Serializable> rtnMap = new HashMap<String, Serializable>();
        int operateResult = 1;
        try {
            Page page = new Page(pageParam.getPage(), pageParam.getRows());
            ArrayList rtnList = this.reportManagerService.queryReportParameterList(reportConditionBean, page);
            rtnMap.put("total", Integer.valueOf(page.getTotal()));
            rtnMap.put("rows", rtnList == null ? new ArrayList() : rtnList);
        }
        catch (Exception e) {
            log.error("#\u62a5\u8868\u53c2\u6570\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            operateResult = 0;
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnMap));
        log.debug("##########\u4e1a\u52a1\u62a5\u8868_\u62a5\u8868\u53c2\u6570\u67e5\u8be2<\u7ed3\u675f>##########");
        return null;
    }

    @RequestMapping(value={"/rptms/reportmanager/toEditReportParameter.do"})
    public String toEditReportParameter(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, String reportConditionId) {
        log.debug("##########\u4e1a\u52a1\u62a5\u8868_\u62a5\u8868\u53c2\u6570\u4fee\u6539_\u8df3\u8f6c<\u5f00\u59cb>##########");
        ReportConditionBean reportConditioinBean = null;
        try {
            reportConditioinBean = this.reportManagerService.getReportParameterById(reportConditionId);
        }
        catch (Exception e) {
            reportConditioinBean = new ReportConditionBean();
            log.error("#\u62a5\u8868\u53c2\u6570\u4fee\u6539\u8df3\u8f6c\u5931\u8d25", (Throwable)e);
        }
        log.debug(Util.toJsonStr(reportConditioinBean));
        Util.writeUtf8Text(response, Util.toJsonStr(reportConditioinBean));
        log.debug("##########\u4e1a\u52a1\u62a5\u8868_\u62a5\u8868\u53c2\u6570\u4fee\u6539_\u8df3\u8f6c<\u7ed3\u675f>##########");
        return null;
    }

    @RequestMapping(value={"/rptms/reportmanager/editReportParameter.do"})
    public String editReportParameter(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ReportConditionBean reportConditionBean) {
        log.debug("##########\u4e1a\u52a1\u62a5\u8868_\u62a5\u8868\u53c2\u6570\u4fee\u6539<\u5f00\u59cb>##########");
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            this.reportManagerService.editReportParameter(reportConditionBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("#\u4fee\u6539\u62a5\u8868\u53c2\u6570\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        log.debug(Util.toJsonStr(rtnResult));
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
        log.debug("##########\u4e1a\u52a1\u62a5\u8868_\u62a5\u8868\u53c2\u6570\u4fee\u6539<\u7ed3\u675f>##########");
        return null;
    }

    @RequestMapping(value={"/rptms/reportmanager/delReportParameter.do"})
    public String delReportParameter(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ReportConditionBean reportConditionBean) {
        log.debug("##########\u4e1a\u52a1\u62a5\u8868_\u62a5\u8868\u53c2\u6570\u5220\u9664<\u5f00\u59cb>##########");
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            this.reportManagerService.delReportParameter(reportConditionBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("#\u5220\u9664\u62a5\u8868\u53c2\u6570\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        log.debug(Util.toJsonStr(rtnResult));
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
        log.debug("##########\u4e1a\u52a1\u62a5\u8868_\u62a5\u8868\u53c2\u6570\u5220\u9664<\u7ed3\u675f>##########");
        return null;
    }

    @RequestMapping(value={"/rptms/reportmanager/editReportOther.do"})
    public String editReportOther(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ReportBean reportBean) {
        log.debug("##########\u4e1a\u52a1\u62a5\u8868_\u5176\u4ed6\u914d\u7f6e\u9879\u4fee\u6539<\u5f00\u59cb>##########");
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            this.reportManagerService.editReportOther(reportBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("#\u4fee\u6539\u62a5\u8868\u5176\u4ed6\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        log.debug(Util.toJsonStr(rtnResult));
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
        log.debug("##########\u4e1a\u52a1\u62a5\u8868_\u5176\u4ed6\u914d\u7f6e\u9879\u4fee\u6539<\u7ed3\u675f>##########");
        return null;
    }

    @RequestMapping(value={"/rptms/reportmanager/editReportChart.do"})
    public String editReportChart(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ReportBean reportBean) {
        log.debug("##########\u4e1a\u52a1\u62a5\u8868_\u5176\u4ed6\u914d\u7f6e\u9879\u4fee\u6539<\u5f00\u59cb>##########");
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            this.reportManagerService.editReportChart(reportBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("#\u4fee\u6539\u62a5\u8868\u5176\u4ed6\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        log.debug(Util.toJsonStr(rtnResult));
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
        log.debug("##########\u4e1a\u52a1\u62a5\u8868_\u5176\u4ed6\u914d\u7f6e\u9879\u4fee\u6539<\u7ed3\u675f>##########");
        return null;
    }

    @RequestMapping(value={"/rptms/reportmanager/enableOrDisableReport.do"})
    public String enableOrDisableReport(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ReportBean reportBean) {
        log.debug("##########\u4e1a\u52a1\u62a5\u8868\u542f\u7981\u7528<\u5f00\u59cb>##########");
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            this.reportManagerService.enableOrDisableReport(reportBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("#\u4fee\u6539\u62a5\u8868\u542f\u7981\u7528\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        log.debug(Util.toJsonStr(rtnResult));
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
        log.debug("##########\u4e1a\u52a1\u62a5\u8868\u542f\u7981\u7528<\u7ed3\u675f>##########");
        return null;
    }
}

