/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.rptms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.rptms.bean.QueryReportTemplateBean;
import com.xdja.pams.rptms.bean.ReportBean;
import com.xdja.pams.rptms.bean.UploadItemsBean;
import com.xdja.pams.rptms.entity.Report;
import com.xdja.pams.rptms.entity.ReportTemplate;
import com.xdja.pams.rptms.service.ReportTemplateManageService;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;

@Controller
@Scope(value="session")
public class ReportTemplateManageControler
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private ReportTemplateManageService reportTemplateManageService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private CommonCodePbService commonCodePbService;
    private static final Logger log = LoggerFactory.getLogger(ReportTemplateManageControler.class);

    @RequestMapping(value={"/rptms/ReportTemplateManageControler/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage()));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/rptms/ReportTemplateManageControler/queryReportTemplates.do"})
    public void queryReportTemplates(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryReportTemplateBean queryReportTemplateBean, PageParam pageParam) {
        int operateResult = 1;
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Page page = new Page(Integer.parseInt(pageParam.getPage()), Integer.parseInt(pageParam.getRows()));
            List<QueryReportTemplateBean> reportTemplateList = this.reportTemplateManageService.queryReportTemplateList(queryReportTemplateBean, page);
            result.put("total", page.getTotal());
            result.put("rows", reportTemplateList);
            log.info(Util.toJsonStr(result));
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u83b7\u53d6\u5355\u4f4d\u4fe1\u606f\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/rptms/ReportTemplateManageControler/toAddTemplate.do"})
    public String toAddTemplate(Model model, PageParam page) {
        return page.getSendUrl();
    }

    @RequestMapping(value={"/rptms/ReportTemplateManageControler/addTemplate.do"})
    public void addTemplate(UploadItemsBean uploadItems, HttpServletRequest request, HttpServletResponse response, PageParam pageParam) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            String templateDir = this.scps.getValueByCode("reportTemplateDir");
            StringBuffer path = new StringBuffer(templateDir);
            this.setOperator(request);
            path.append(File.separator).append(this.person.getCode()).append("_");
            ReportTemplate reportTemplate = new ReportTemplate();
            reportTemplate.setName(uploadItems.getName());
            reportTemplate.setNote(uploadItems.getNote());
            reportTemplate.setCreatorId(this.person.getId());
            for (MultipartFile file : uploadItems.getFileData()) {
                String fileName = file.getOriginalFilename();
                String extension = FilenameUtils.getExtension((String)fileName);
                if ("jrxml".equalsIgnoreCase(extension)) {
                    if (!fileName.substring(0, fileName.lastIndexOf(".")).matches("^([A-Z]|[a-z])+([a-z]|[A-Z]|[0-9]|_)*([A-Z]|[0-9]|[a-z])$")) {
                        throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.templateManage.error.addrtfilenamenotright"));
                    }
                    path.append(fileName.substring(0, fileName.lastIndexOf(".")));
                    reportTemplate.setFilePath(path.toString() + File.separator + path.toString().substring(path.toString().lastIndexOf(File.separator) + 1) + "." + extension);
                    continue;
                }
                reportTemplate.setPicturePath(path.toString() + File.separator + path.toString().substring(path.toString().lastIndexOf(File.separator) + 1) + "." + extension);
            }
            this.reportTemplateManageService.validateRt(reportTemplate.getFilePath());
            this.reportTemplateManageService.addTemplate(uploadItems, reportTemplate);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e.getMessage());
        }
        Util.writeUtf8Text1(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/rptms/ReportTemplateManageControler/toEditTemplate.do"})
    public String toEditTemplate(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, PageParam page) {
        ReportTemplate reportTemplate = null;
        try {
            reportTemplate = this.reportTemplateManageService.queryReportTemplateById(id);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6a21\u677f\u51fa\u73b0\u9519\u8bef:" + e.getMessage(), (Throwable)e);
        }
        map.put((Object)"reportTemplate", (Object)reportTemplate);
        return page.getSendUrl();
    }

    @RequestMapping(value={"/rptms/ReportTemplateManageControler/updateTemplate.do"})
    public void updateTemplate(HttpServletRequest request, HttpServletResponse response, ReportTemplate reportTemplate) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            ReportTemplate reportTemplateOld = this.reportTemplateManageService.queryReportTemplateById(reportTemplate.getId());
            reportTemplateOld.setName(reportTemplate.getName());
            reportTemplateOld.setNote(reportTemplate.getNote());
            this.reportTemplateManageService.updateReportTemplate(reportTemplateOld);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e.getMessage());
        }
        Util.writeUtf8Text1(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/rptms/ReportTemplateManageControler/deleteTemplate.do"})
    public void deleteTemplate(HttpServletRequest request, HttpServletResponse response, String id) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            ReportTemplate reportTemplateOld = this.reportTemplateManageService.queryReportTemplateById(id);
            this.reportTemplateManageService.deleteReportTemplate(reportTemplateOld);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e.getMessage());
        }
        Util.writeUtf8Text1(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/rptms/ReportTemplateManageControler/viewReportStyle.do"})
    public void viewReportStyle(HttpServletRequest request, HttpServletResponse response, String id) {
        String fileNotFoundPic = request.getSession().getServletContext().getRealPath("css/themes/default/system/images/zwtp-500-390.jpg");
        ReportTemplate reportTemplateOld = this.reportTemplateManageService.queryReportTemplateById(id);
        FileInputStream in = null;
        try {
            if (reportTemplateOld != null) {
                File file = new File(reportTemplateOld.getPictureAllPath());
                if (file.exists()) {
                    in = new FileInputStream(file);
                }
            } else {
                try {
                    in = new FileInputStream(new File(fileNotFoundPic));
                }
                catch (FileNotFoundException e1) {
                    log.error(e1.getMessage(), (Throwable)e1);
                }
            }
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u62a5\u8868\u9884\u89c8\u6587\u4ef6\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        byte[] b = new byte[1024];
        int len = -1;
        try {
            ServletOutputStream os = response.getOutputStream();
            int i = 0;
            while ((i = in.read(b)) > 0) {
                os.write(b, 0, i);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/rptms/ReportTemplateManageControler/toGetReports.do"})
    public String toGetReports(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        return page.getSendUrl();
    }

    @RequestMapping(value={"/rptms/ReportTemplateManageControler/getReports.do"})
    public void getReports(HttpServletRequest request, HttpServletResponse response, String id) {
        int operateResult = 1;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        try {
            ReportTemplate reportTemplate = this.reportTemplateManageService.queryReportTemplateById(id);
            List<Report> reportList = reportTemplate.getReportList();
            ArrayList<ReportBean> reportBeanList = new ArrayList<ReportBean>();
            for (Report report : reportList) {
                ReportBean reportBean = new ReportBean();
                reportBean.setReportName(report.getReportName());
                reportBean.setStrCreateTime(Util.getDate("yyyy-MM-dd HH:mm:ss", report.getCreateDate()));
                reportBean.setReportType(this.commonCodePbService.getCodeNameByCode(report.getReportType(), "reportType"));
                reportBeanList.add(reportBean);
            }
            result.put("total", Integer.valueOf(reportBeanList.size()));
            result.put("rows", reportBeanList);
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u83b7\u53d6\u6a21\u677f\u5173\u8054\u7684\u62a5\u8868\u51fa\u73b0\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/rptms/ReportTemplateManageControler/getReportTemplate.do"})
    public void getReportTemplate(HttpServletRequest request, HttpServletResponse response, String id) {
        ReportTemplate reportTemplateOld = this.reportTemplateManageService.queryReportTemplateById(id);
        String fileName = reportTemplateOld.getFilePath().substring(reportTemplateOld.getFilePath().lastIndexOf(File.separator) + 1);
        String dir = reportTemplateOld.getFilePath().substring(0, reportTemplateOld.getFilePath().lastIndexOf(File.separator));
        this.download(fileName, request, response, dir);
    }

    @RequestMapping(value={"/rptms/ReportTemplateManageControler/toReplaceTemplate.do"})
    public String toReplaceTemplate(ModelMap map, PageParam page, String id) {
        ReportTemplate reportTemplate = null;
        try {
            reportTemplate = this.reportTemplateManageService.queryReportTemplateById(id);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6a21\u677f\u51fa\u73b0\u9519\u8bef:" + e.getMessage(), (Throwable)e);
        }
        map.put((Object)"reportTemplate", (Object)reportTemplate);
        return page.getSendUrl();
    }

    @RequestMapping(value={"/rptms/ReportTemplateManageControler/replaceTemplate.do"})
    public void replaceTemplate(HttpServletRequest request, HttpServletResponse response, UploadItemsBean uploadItemsBean) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            ReportTemplate reportTemplateOld = this.reportTemplateManageService.queryReportTemplateById(uploadItemsBean.getId());
            String templateDir = this.scps.getValueByCode("reportTemplateDir");
            StringBuffer path = new StringBuffer(templateDir);
            this.setOperator(request);
            path.append(File.separator).append(this.person.getCode()).append("_");
            this.reportTemplateManageService.replaceReportTemplate(uploadItemsBean, reportTemplateOld, path);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e.getMessage());
        }
        Util.writeUtf8Text1(response, Util.toJsonStr(rtnResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(String filename, HttpServletRequest request, HttpServletResponse response, String dir) {
        String path = request.getSession().getServletContext().getRealPath(dir);
        String filepath = path + File.separator + filename;
        File file = null;
        OutputStream os = null;
        BufferedInputStream fin = null;
        try {
            response.setContentType("application/x-msdownload");
            response.setHeader("Content-Disposition", "attachment; filename=" + filename);
            file = new File(filepath);
            os = response.getOutputStream();
            if (file.exists()) {
                fin = new BufferedInputStream(new FileInputStream(file));
                if (fin != null) {
                    byte[] b = new byte[2048];
                    int i = 0;
                    while ((i = fin.read(b)) > 0) {
                        os.write(b, 0, i);
                    }
                }
                os.flush();
                os.close();
                fin.close();
                os = null;
                fin = null;
            } else {
                response.setContentType("text/plain;charset=UTF-8");
                os.write("<script type=text/javascript>alert('\u60a8\u4e0b\u8f7d\u7684\u6587\u4ef6\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u4e0a\u4f20\uff0c\\n\u8bf7\u70b9\u51fb\u786e\u5b9a\u7ee7\u7eed\u4e0b\u8f7d\uff01');window.location.href='index.do';</script>".getBytes("UTF-8"));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (fin != null) {
                    fin.close();
                }
                file = null;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

