/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.rptms.service.impl;

import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.rptms.bean.ConditionBean;
import com.xdja.pams.rptms.bean.ReportConditionBean;
import com.xdja.pams.rptms.dao.ConditionManagerDao;
import com.xdja.pams.rptms.entity.Condition;
import com.xdja.pams.rptms.service.ConditionManagerService;
import com.xdja.pams.rptms.service.DatasourceMangerService;
import com.xdja.pams.rptms.service.ReportManagerService;
import com.xdja.pams.syms.service.CommonCodePbService;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConditionManagerServiceImpl
implements ConditionManagerService {
    @Autowired
    private ConditionManagerDao conditionManagerDao;
    @Autowired
    private ReportManagerService reportManagerService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private DatasourceMangerService datasourceService;
    @Autowired
    private ResourceBundleMessageSource message;
    private static final Logger log = LoggerFactory.getLogger(ConditionManagerServiceImpl.class);

    @Override
    public List<ConditionBean> queryConditionList(ConditionBean conditionBean, Page page) {
        log.debug("$$$$$$$$$$\u62a5\u8868\u6761\u4ef6\u67e5\u8be2<\u5f00\u59cb>$$$$$$$$$$");
        ArrayList<ConditionBean> conditionBeanList = new ArrayList<ConditionBean>();
        List<Condition> conditionList = this.conditionManagerDao.queryConditionList(conditionBean, page);
        String codeValue = "";
        ConditionBean tmpConditionBean = null;
        for (Condition condition : conditionList) {
            tmpConditionBean = new ConditionBean();
            BeanUtils.copyProperties((Object)condition, (Object)tmpConditionBean);
            if (tmpConditionBean.getDatasourceId() != null) {
                codeValue = this.datasourceService.getDatasourceById(tmpConditionBean.getDatasourceId()).getDatasourceName();
                tmpConditionBean.setDatasourceName(codeValue);
            }
            codeValue = this.commonCodePbService.getCodeNameByCode(String.valueOf(tmpConditionBean.getConditionType()), "conditionType");
            tmpConditionBean.setConditionTypeName(codeValue);
            conditionBeanList.add(tmpConditionBean);
        }
        log.debug("$$$$$$$$$$\u62a5\u8868\u6761\u4ef6\u67e5\u8be2<\u7ed3\u675f>$$$$$$$$$$");
        return conditionBeanList;
    }

    @Override
    @Transactional
    public Condition addCondition(ConditionBean conditionBean) {
        log.debug("$$$$$$$$$$\u62a5\u8868\u6761\u4ef6\u6dfb\u52a0<\u5f00\u59cb>$$$$$$$$$$");
        String conditionType = conditionBean.getConditionType();
        if (("2".equals(conditionType) || "3".equals(conditionType)) && "1".equals(conditionBean.getDataOriginCode())) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode node = objectMapper.readTree(conditionBean.getConditionData());
                node.get(0);
            }
            catch (Exception e) {
                log.error("$Json\u6570\u636e\u683c\u5f0f\u5316\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.jsonformat"));
            }
        }
        ConditionBean tmpCondtionBean = new ConditionBean();
        tmpCondtionBean.setConditionShowId(conditionBean.getConditionShowId());
        List<Condition> conditionList = this.conditionManagerDao.queryConditionList(tmpCondtionBean, null);
        if (conditionList != null && !conditionList.isEmpty()) {
            log.error(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.conditonExit") + ":" + conditionBean.getConditionShowId());
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.conditonExit"));
        }
        Condition condition = new Condition();
        BeanUtils.copyProperties((Object)conditionBean, (Object)condition);
        condition = this.conditionManagerDao.addCondition(condition);
        log.debug("$$$$$$$$$$\u62a5\u8868\u6761\u4ef6\u6dfb\u52a0<\u7ed3\u675f>$$$$$$$$$$");
        return condition;
    }

    @Override
    public ConditionBean getConditionById(String conditionId) {
        log.debug("$$$$$$$$$$\u83b7\u53d6\u62a5\u8868\u6761\u4ef6<\u5f00\u59cb>$$$$$$$$$$");
        ConditionBean conditionBean = new ConditionBean();
        Condition condition = this.conditionManagerDao.getConditionById(conditionId);
        String codeValue = null;
        if (condition == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.noSuchConditonExit") + ":" + conditionId);
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.noSuchConditonExit"));
        }
        BeanUtils.copyProperties((Object)condition, (Object)conditionBean);
        if (conditionBean.getDatasourceId() != null) {
            codeValue = this.datasourceService.getDatasourceById(conditionBean.getDatasourceId()).getDatasourceName();
            conditionBean.setDatasourceName(codeValue);
        }
        codeValue = this.commonCodePbService.getCodeNameByCode(String.valueOf(conditionBean.getConditionType()), "conditionType");
        conditionBean.setConditionTypeName(codeValue);
        log.debug("$$$$$$$$$$\u83b7\u53d6\u62a5\u8868\u6761\u4ef6<\u7ed3\u675f>$$$$$$$$$$");
        return conditionBean;
    }

    @Override
    @Transactional
    public void editCondition(ConditionBean conditionBean) {
        log.debug("$$$$$$$$$$\u4fee\u6539\u62a5\u8868\u6761\u4ef6<\u5f00\u59cb>$$$$$$$$$$");
        String conditionType = conditionBean.getConditionType();
        if (("2".equals(conditionType) || "3".equals(conditionType)) && "1".equals(conditionBean.getDataOriginCode())) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode node = objectMapper.readTree(conditionBean.getConditionData());
                node.get(0);
            }
            catch (Exception e) {
                log.error("$Json\u6570\u636e\u683c\u5f0f\u5316\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.jsonformat"));
            }
        }
        ConditionBean tmpCondtionBean = new ConditionBean();
        tmpCondtionBean.setConditionShowId(conditionBean.getConditionShowId());
        List<Condition> conditionList = this.conditionManagerDao.queryConditionList(tmpCondtionBean, null);
        Condition condition = null;
        if (conditionList != null && !conditionList.isEmpty()) {
            for (Condition tmpCondition : conditionList) {
                if (tmpCondition.getConditionId().equals(conditionBean.getConditionId())) {
                    condition = tmpCondition;
                    continue;
                }
                log.error(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.conditonExit") + ":" + conditionBean.getConditionId());
                throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.conditonExit"));
            }
        } else {
            condition = this.conditionManagerDao.getConditionById(conditionBean.getConditionId());
        }
        condition.setConditionName(conditionBean.getConditionName());
        condition.setConditionType(conditionBean.getConditionType());
        condition.setConditionShowId(conditionBean.getConditionShowId());
        condition.setDataOriginCode(conditionBean.getDataOriginCode());
        condition.setDatasourceId(conditionBean.getDatasourceId());
        condition.setConditionData(conditionBean.getConditionData());
        condition.setDefaultValue(conditionBean.getDefaultValue());
        condition.setNote(conditionBean.getNote());
        condition.setCreatorId(conditionBean.getConditionId());
        this.conditionManagerDao.editCondition(condition);
        log.debug("$$$$$$$$$$\u4fee\u6539\u62a5\u8868\u6761\u4ef6<\u7ed3\u675f>$$$$$$$$$$");
    }

    @Override
    @Transactional
    public void delCondition(ConditionBean conditionBean) {
        Condition condition;
        log.debug("$$$$$$$$$$\u5220\u9664\u62a5\u8868\u6761\u4ef6<\u5f00\u59cb>$$$$$$$$$$");
        ReportConditionBean reportConditionBean = new ReportConditionBean();
        reportConditionBean.setConditionId(conditionBean.getConditionId());
        List<ReportConditionBean> list = this.reportManagerService.queryReportParameterList(reportConditionBean, null);
        if (list == null || list.isEmpty()) {
            condition = this.conditionManagerDao.getConditionById(conditionBean.getConditionId());
            if (condition == null) {
                log.error(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.noSuchConditonExit") + ":" + conditionBean.getConditionId());
                throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.noSuchConditonExit"));
            }
        } else {
            log.error(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.reportParamsExit") + ":" + conditionBean.getConditionId());
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.reportParamsExit"));
        }
        this.conditionManagerDao.delCondition(condition);
        log.debug("$$$$$$$$$$\u5220\u9664\u62a5\u8868\u6761\u4ef6<\u7ed3\u675f>$$$$$$$$$$");
    }
}

