/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.bean;

import com.xdja.pams.common.util.Base64Encrypt;
import com.xdja.pams.scms.bean.CertValidity;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.Writer;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DInfo {
    private static final Logger log = LoggerFactory.getLogger(DInfo.class);
    private String url;
    private String version;
    private String password;
    private String devCardNo;
    private String devPassword;
    private String gateCardNO;
    private String algType;
    private String isSM2;
    private String type;
    private String isImsi;
    private String getGWCertSwitch;
    private String isWritePersonInfo;
    private String useThirdCert;
    private String isEmpowerKey;

    public DInfo(String url, String password, String devCardNo, String devPassword, String gateCardNO, String algType, String isSM2, String type, String isImsi, String getGWCertSwitch) {
        this.url = url;
        this.password = password;
        this.devCardNo = devCardNo;
        this.devPassword = devPassword;
        this.gateCardNO = gateCardNO;
        this.algType = algType;
        this.isSM2 = isSM2;
        this.type = type;
        this.isImsi = isImsi;
        this.getGWCertSwitch = getGWCertSwitch;
    }

    public DInfo(String url, String password, String devCardNo, String devPassword, String gateCardNO, String algType, String isSM2, String type, String isImsi, String getGWCertSwitch, String isWritePersonInfo) {
        this.url = url;
        this.password = password;
        this.devCardNo = devCardNo;
        this.devPassword = devPassword;
        this.gateCardNO = gateCardNO;
        this.algType = algType;
        this.isSM2 = isSM2;
        this.type = type;
        this.isImsi = isImsi;
        this.getGWCertSwitch = getGWCertSwitch;
        this.isWritePersonInfo = isWritePersonInfo;
    }

    public DInfo(String url, String devCardNo, String devPassword) {
        this.url = url;
        this.devCardNo = devCardNo;
        this.devPassword = devPassword;
    }

    public String getIsEmpowerKey() {
        return this.isEmpowerKey;
    }

    public void setIsEmpowerKey(String isEmpowerKey) {
        this.isEmpowerKey = isEmpowerKey;
    }

    public String getUseThirdCert() {
        return this.useThirdCert;
    }

    public void setUseThirdCert(String useThirdCert) {
        this.useThirdCert = useThirdCert;
    }

    public String getGetGWCertSwitch() {
        return this.getGWCertSwitch;
    }

    public void setGetGWCertSwitch(String getGWCertSwitch) {
        this.getGWCertSwitch = getGWCertSwitch;
    }

    public static String covALgType(String type) {
        String algtype = "";
        if ("1".equals(type)) {
            algtype = "1.0";
        }
        if ("2".equals(type)) {
            algtype = "2.0";
        }
        return algtype;
    }

    public static String covCartType(String type) {
        String cardType = "";
        if (type.equals("1")) {
            cardType = "5";
        }
        if (type.equals("2")) {
            cardType = "4";
        }
        if (type.equals("3")) {
            cardType = "3";
        }
        if (type.equals("4")) {
            cardType = "3";
        }
        if ("6".equals(type)) {
            cardType = "6";
        }
        return cardType;
    }

    public static String covCartTypeJIT(String type) {
        String cardType = "";
        if (type.equals("1")) {
            cardType = "5";
        }
        if (type.equals("2")) {
            cardType = "4";
        }
        if (type.equals("3")) {
            cardType = "3";
        }
        if (type.equals("4")) {
            cardType = "2";
        }
        if (type.equals("6")) {
            cardType = "3";
        }
        return cardType;
    }

    public static String covCardTypeSimpleCA(String type) {
        String cardType = "";
        if ("1".equals(type)) {
            cardType = "5";
        }
        if ("2".equals(type)) {
            cardType = "4";
        }
        if ("3".equals(type)) {
            cardType = "3";
        }
        if ("4".equals(type)) {
            cardType = "2";
        }
        if ("6".equals(type)) {
            cardType = "6";
        }
        return cardType;
    }

    public static String getCertQueryErr(String strKey, String version, String admin) {
        if ("0".equals(strKey)) {
            return "\u83b7\u53d6\u7f51\u5173\u8bc1\u4e66\u5931\u8d25\uff0c\u8bbe\u5907\u6ca1\u6709\u67e5\u8be2\u8bc1\u4e66\u6743\u9650";
        }
        if ("4".equals(strKey)) {
            if (version.equals("3.0") && admin.equals("2.0")) {
                return "\u83b7\u53d6\u7f51\u5173\u8bc1\u4e66\u5931\u8d25\uff0c\u67e5\u8be2\u7684\u7f51\u5173SM2\u8bc1\u4e66\u4e0d\u5b58\u5728";
            }
            return "\u83b7\u53d6\u7f51\u5173\u8bc1\u4e66\u5931\u8d25\uff0c\u67e5\u8be2\u7684\u7f51\u5173RSA\u8bc1\u4e66\u4e0d\u5b58\u5728";
        }
        if ("5".equals(strKey)) {
            return "\u4e0d\u652f\u6301\u7684CA\u7c7b\u578b";
        }
        if ("7".equals(strKey)) {
            return "\u83b7\u53d6\u7f51\u5173\u8bc1\u4e66\u5931\u8d25\uff0c\u5361\u7c7b\u578b\u9519\u8bef";
        }
        if ("8".equals(strKey)) {
            return "\u83b7\u53d6\u7f51\u5173\u8bc1\u4e66\u5931\u8d25\uff0c\u5361\u53f7\u9519\u8bef";
        }
        if ("9".equals(strKey)) {
            return "\u83b7\u53d6\u7f51\u5173\u8bc1\u4e66\u5931\u8d25\uff0c\u64cd\u4f5c\u8005\u4e3a\u7a7a";
        }
        if ("13".equals(strKey)) {
            return "\u83b7\u53d6\u7f51\u5173\u8bc1\u4e66\u5931\u8d25\uff0c\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef";
        }
        if ("14".equals(strKey)) {
            return "\u83b7\u53d6\u7f51\u5173\u8bc1\u4e66\u5931\u8d25\uff0c\u67e5\u8be2\u7684\u8bc1\u4e66\u5904\u4e8e\u51bb\u7ed3\u72b6\u6001";
        }
        if ("15".equals(strKey)) {
            return "\u83b7\u53d6\u7f51\u5173\u8bc1\u4e66\u5931\u8d25\uff0c\u67e5\u8be2\u7684\u8bc1\u4e66\u5df2\u88ab\u540a\u9500";
        }
        if ("16".equals(strKey)) {
            return "\u83b7\u53d6\u7f51\u5173\u8bc1\u4e66\u5931\u8d25\uff0c\u67e5\u8be2\u7684\u8bc1\u4e66\u5df2\u8fc7\u671f";
        }
        if ("18".equals(strKey)) {
            return "\u83b7\u53d6\u7f51\u5173\u8bc1\u4e66\u5931\u8d25\uff0c\u67e5\u8be2\u7684\u662f\u65e0\u6548\u7684\u8bc1\u4e66";
        }
        if ("19".equals(strKey)) {
            return "\u83b7\u53d6\u7f51\u5173\u8bc1\u4e66\u5931\u8d25\uff0c\u63a5\u53e3\u7248\u672c\u9519\u8bef";
        }
        if ("24".equals(strKey)) {
            return "\u83b7\u53d6\u7f51\u5173\u8bc1\u4e66\u5931\u8d25\uff0c\u5176\u4ed6\u9519\u8bef";
        }
        if ("-1".equals(strKey)) {
            return "\u83b7\u53d6\u7f51\u5173\u8bc1\u4e66\u5931\u8d25\uff0c\u8fde\u63a5\u65b0-D\u5f02\u5e38";
        }
        if ("988".equals(strKey)) {
            return "\u8c03\u7528-D\u9002\u914d\u670d\u52a1\u5f02\u5e38";
        }
        return "";
    }

    public static String getCertIssueErr(String strKey) {
        if ("0".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u8bbe\u5907\u6ca1\u6709\u7b7e\u53d1\u8bc1\u4e66\u6743\u9650";
        }
        if ("3".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u8bc1\u4e66\u5df2\u5b58\u5728";
        }
        if ("5".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684CA\u7c7b\u578b";
        }
        if ("6".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0cCA\u9519\u8bef";
        }
        if ("7".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u5361\u7c7b\u578b\u9519\u8bef";
        }
        if ("8".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u5361\u53f7\u9519\u8bef";
        }
        if ("9".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u64cd\u4f5c\u8005\u4e3a\u7a7a";
        }
        if ("10".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u516c\u94a5\u9519\u8bef";
        }
        if ("11".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0cp10\u9519\u8bef";
        }
        if ("12".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u4ecep7\u4e2d\u83b7\u53d6\u8bc1\u4e66\u65f6\u9519\u8bef";
        }
        if ("13".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef";
        }
        if ("19".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u63a5\u53e3\u7248\u672c\u9519\u8bef";
        }
        if ("20".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0clicense\u6587\u4ef6\u4e0d\u5b58\u5728";
        }
        if ("21".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0clicense\u6587\u4ef6\u6709\u6548\u671f\u9519\u8bef";
        }
        if ("22".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0clicense\u6587\u4ef6\u5176\u4ed6\u9519\u8bef";
        }
        if ("23".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u8bc1\u4e66\u6570\u91cf\u8d85\u8fc7license\u6587\u4ef6\u9650\u5236";
        }
        if ("24".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u5176\u4ed6\u9519\u8bef";
        }
        if ("-1".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u8fde\u63a5\u65b0\u2014D\u5f02\u5e38";
        }
        if ("988".equals(strKey)) {
            return "\u8c03\u7528-D\u9002\u914d\u670d\u52a1\u5f02\u5e38";
        }
        if ("30".equals(strKey)) {
            return "\u8bbe\u5907\u786c\u4ef6\u7f16\u53f7\u6216\u8bbe\u5907imei\u4e0d\u5728\u767d\u540d\u5355\u4e2d";
        }
        return "";
    }

    public static String getCertRevoke(String strFlag) {
        if (strFlag.equals("1")) {
            return "\u64a4\u9500\u8bc1\u4e66\u6210\u529f";
        }
        if (strFlag.equals("0")) {
            return "\u8bbe\u5907\u6ca1\u6709\u64a4\u9500\u8bc1\u4e66\u6743\u9650";
        }
        if (strFlag.equals("2")) {
            return "\u64a4\u9500\u8bc1\u4e66\u5931\u8d25";
        }
        if (strFlag.equals("4")) {
            return "\u8981\u64a4\u9500\u7684\u8bc1\u4e66\u4e0d\u5b58\u5728";
        }
        if (strFlag.equals("5")) {
            return "\u4e0d\u652f\u6301\u7684CA\u7c7b\u578b";
        }
        if (strFlag.equals("7")) {
            return "\u5361\u7c7b\u578b\u9519\u8bef";
        }
        if (strFlag.equals("8")) {
            return "\u5361\u53f7\u9519\u8bef";
        }
        if (strFlag.equals("9")) {
            return "\u64cd\u4f5c\u8005\u4e3a\u7a7a";
        }
        if (strFlag.equals("13")) {
            return "\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef";
        }
        if (strFlag.equals("19")) {
            return "\u63a5\u53e3\u7248\u672c\u9519\u8bef";
        }
        if (strFlag.equals("-1")) {
            return "\u8fde\u63a5\u65b0-D\u5f02\u5e38";
        }
        if (strFlag.equals("988")) {
            return "\u8c03\u7528-D\u9002\u914d\u670d\u52a1\u5f02\u5e38";
        }
        return "\u672a\u77e5\u9519\u8bef";
    }

    public static String getErrCertApplyRA(String strFlag) {
        if (strFlag.equals("1")) {
            return "\u64a4\u9500\u8bc1\u4e66\u6210\u529f";
        }
        if (strFlag.equals("0")) {
            return "\u8bbe\u5907\u6ca1\u6709\u64a4\u9500\u8bc1\u4e66\u6743\u9650";
        }
        if (strFlag.equals("6")) {
            return "CA\u9519\u8bef";
        }
        if (strFlag.equals("9")) {
            return "\u64cd\u4f5c\u8005\u4e3a\u7a7a";
        }
        if (strFlag.equals("19")) {
            return "\u63a5\u53e3\u7248\u672c\u9519\u8bef";
        }
        if (strFlag.equals("31")) {
            return "\u4e0d\u652f\u6301\u7684\u8bc1\u4e66\u6a21\u677f";
        }
        if (strFlag.equals("32")) {
            return "\u8bc1\u4e66\u7533\u8bf7\u5931\u8d25";
        }
        if (strFlag.equals("33")) {
            return "\u65e0\u6548\u7684\u8bc1\u4e66\u7533\u8bf7\u7c7b\u578b";
        }
        if (strFlag.equals("36")) {
            return "\u7528\u6237\u4fe1\u606f\u53c2\u6570\u9519\u8bef";
        }
        return "\u672a\u77e5\u9519\u8bef";
    }

    public static String certDownlaodRAJitErr(String strKey) {
        if ("0".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u8bbe\u5907\u6ca1\u6709\u7b7e\u53d1\u8bc1\u4e66\u6743\u9650";
        }
        if ("3".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u8bc1\u4e66\u5df2\u5b58\u5728";
        }
        if ("5".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684CA\u7c7b\u578b";
        }
        if ("6".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0cCA\u9519\u8bef";
        }
        if ("7".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u5361\u7c7b\u578b\u9519\u8bef";
        }
        if ("8".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u5361\u53f7\u9519\u8bef";
        }
        if ("9".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u64cd\u4f5c\u8005\u4e3a\u7a7a";
        }
        if ("10".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u516c\u94a5\u9519\u8bef";
        }
        if ("11".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0cp10\u9519\u8bef";
        }
        if ("12".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u4ecep7\u4e2d\u83b7\u53d6\u8bc1\u4e66\u65f6\u9519\u8bef";
        }
        if ("13".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef";
        }
        if ("19".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u63a5\u53e3\u7248\u672c\u9519\u8bef";
        }
        if ("20".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u5176\u4ed6\u9519\u8bef";
        }
        if ("25".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u7528\u6237\u72b6\u6001\u9519\u8bef";
        }
        if ("36".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u7528\u6237\u4e0d\u5b58\u5728";
        }
        if ("38".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0cuserId\u53c2\u6570\u4e3a\u7a7a";
        }
        if ("40".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u65e0\u6548\u7684\u8bc1\u4e66\u8bf7\u6c42";
        }
        if ("-1".equals(strKey)) {
            return "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u8fde\u63a5\u65b0\u2014D\u5f02\u5e38";
        }
        if ("988".equals(strKey)) {
            return "\u8c03\u7528-D\u9002\u914d\u670d\u52a1\u5f02\u5e38";
        }
        return "";
    }

    public static String getCertApplyRAKR(String strFlag) {
        if (strFlag.equals("0")) {
            return "\u8bbe\u5907\u6ca1\u6709\u7b7e\u53d1\u8bc1\u4e66\u6743\u9650";
        }
        if (strFlag.equals("6")) {
            return "CA\u9519\u8bef";
        }
        if (strFlag.equals("9")) {
            return "\u64cd\u4f5c\u8005\u4e3a\u7a7a";
        }
        if (strFlag.equals("19")) {
            return "\u63a5\u53e3\u7248\u672c\u9519\u8bef";
        }
        if (strFlag.equals("31")) {
            return "\u4e0d\u652f\u6301\u7684\u8bc1\u4e66\u6a21\u677f";
        }
        if (strFlag.equals("32")) {
            return "\u8bc1\u4e66\u7533\u8bf7\u5931\u8d25";
        }
        if (strFlag.equals("33")) {
            return "\u65e0\u6548\u7684\u8bc1\u4e66\u7533\u8bf7\u7c7b\u578b";
        }
        if (strFlag.equals("36")) {
            return "\u7528\u6237\u4fe1\u606f\u53c2\u6570\u9519\u8bef";
        }
        return "\u672a\u77e5\u9519\u8bef";
    }

    public static String getReviewRAKR(String strFlag) {
        if (strFlag.equals("0")) {
            return "\u8bbe\u5907\u6ca1\u6709\u7b7e\u53d1\u8bc1\u4e66\u6743\u9650";
        }
        if (strFlag.equals("6")) {
            return "CA\u9519\u8bef";
        }
        if (strFlag.equals("9")) {
            return "\u64cd\u4f5c\u8005\u4e3a\u7a7a";
        }
        if (strFlag.equals("19")) {
            return "\u63a5\u53e3\u7248\u672c\u9519\u8bef";
        }
        if (strFlag.equals("35")) {
            return "\u5ba1\u6838\u5931\u8d25 \u65e0\u6548\u7684\u72b6\u6001\u8f6c\u6362";
        }
        if (strFlag.equals("36")) {
            return "\u7528\u6237\u4e0d\u5b58\u5728";
        }
        if (strFlag.equals("38")) {
            return "userId\u53c2\u6570\u4e3a\u7a7a";
        }
        if (strFlag.equals("39")) {
            return "\u5ba1\u6279\u7c7b\u578b\u9519\u8bef";
        }
        return "\u672a\u77e5\u9519\u8bef";
    }

    public static String getSN(String strCert) {
        String sn = "";
        try {
            Base64Encrypt base64 = new Base64Encrypt();
            CertificateFactory certificate_factory = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream stream = new ByteArrayInputStream(strCert.getBytes());
            X509Certificate x509certificate = (X509Certificate)certificate_factory.generateCertificate(stream);
            sn = x509certificate.getSerialNumber().toString(16);
        }
        catch (CertificateException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchProviderException e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        return sn;
    }

    public static String getPubKey(String strCert) {
        strCert = DInfo.getOrgCert(strCert);
        log.debug("\u7b7e\u540d\u8bc1\u4e66:{}", (Object)strCert);
        String pubKey = "";
        try {
            CertificateFactory certificate_factory = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream stream = new ByteArrayInputStream(strCert.getBytes());
            X509Certificate x509certificate = (X509Certificate)certificate_factory.generateCertificate(stream);
            pubKey = new String(Base64.encode((byte[])x509certificate.getPublicKey().getEncoded()));
        }
        catch (CertificateException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchProviderException e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        return pubKey;
    }

    public static CertValidity getCertValidity(String strCert) {
        strCert = DInfo.getOrgCert(strCert);
        try {
            Base64Encrypt base64 = new Base64Encrypt();
            CertificateFactory certificate_factory = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream stream = new ByteArrayInputStream(strCert.getBytes());
            X509Certificate x509certificate = (X509Certificate)certificate_factory.generateCertificate(stream);
            CertValidity certValidity = new CertValidity();
            certValidity.setStart(x509certificate.getNotBefore());
            certValidity.setEnd(x509certificate.getNotAfter());
            return certValidity;
        }
        catch (CertificateException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchProviderException e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        return null;
    }

    private static X509Certificate getX509(String strCert) {
        strCert = DInfo.getOrgCert(strCert);
        try {
            Base64Encrypt base64 = new Base64Encrypt();
            CertificateFactory certificate_factory = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream stream = new ByteArrayInputStream(strCert.getBytes());
            X509Certificate x509certificate = (X509Certificate)certificate_factory.generateCertificate(stream);
            return x509certificate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getOrgCert(String strCert) {
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN CERTIFICATE-----\n");
        for (int i = 0; i < strCert.length(); ++i) {
            if (i > 0 && i % 76 == 0) {
                sb.append("\n");
            }
            sb.append(strCert.charAt(i));
        }
        sb.append("\n-----END CERTIFICATE-----");
        return sb.toString();
    }

    public static X509Certificate getCertByDerString(String derHexString) {
        String sn = "";
        X509Certificate x509certificate = null;
        try {
            CertificateFactory certificate_factory = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream stream = new ByteArrayInputStream(DInfo.hexStringToBytes(derHexString));
            x509certificate = (X509Certificate)certificate_factory.generateCertificate(stream);
        }
        catch (CertificateException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchProviderException e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        return x509certificate;
    }

    public static String getBase64FromCert(X509Certificate cert) {
        if (cert != null) {
            try {
                CharArrayWriter charWrite = new CharArrayWriter();
                PEMWriter pemWriter = new PEMWriter((Writer)charWrite);
                pemWriter.writeObject((Object)cert);
                pemWriter.close();
                return charWrite.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(DInfo.charToByte(hexChars[pos]) << 4 | DInfo.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDevCardNo() {
        return this.devCardNo;
    }

    public void setDevCardNo(String devCardNo) {
        this.devCardNo = devCardNo;
    }

    public String getDevPassword() {
        return this.devPassword;
    }

    public void setDevPassword(String devPassword) {
        this.devPassword = devPassword;
    }

    public String getGateCardNO() {
        return this.gateCardNO;
    }

    public void setGateCardNO(String gateCardNO) {
        this.gateCardNO = gateCardNO;
    }

    public String getAlgType() {
        return this.algType;
    }

    public void setAlgType(String algType) {
        this.algType = algType;
    }

    public String getIsSM2() {
        return this.isSM2;
    }

    public void setIsSM2(String isSM2) {
        this.isSM2 = isSM2;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getIsImsi() {
        return this.isImsi;
    }

    public void setIsImsi(String isImsi) {
        this.isImsi = isImsi;
    }

    public String getIsWritePersonInfo() {
        return this.isWritePersonInfo;
    }

    public void setIsWritePersonInfo(String isWritePersonInfo) {
        this.isWritePersonInfo = isWritePersonInfo;
    }

    public static void main(String[] args) {
        String s1 = "MIICATCCAaigAwIBAgIDBpJrMAoGCCqBHM9VAYN1MDgxCzAJBgNVBAYTAkNOMQswCQYDVQQIDAI4NTELMAkGA1UEBwwCMDAxDzANBgNVBAMMBllEWFpDQTAeFw0xODA2MjYxMDQ3MjhaFw0xODA3MjYxMDQ3MjhaMH8xCzAJBgNVBAYTAkNOMQswCQYDVQQIDAI0NDELMAkGA1UEBwwCMDAxCzAJBgNVBAcMAjAwMQswCQYDVQQKDAIwMDELMAkGA1UECwwCMDAxCzAJBgNVBAsMAjAwMSIwIAYDVQQDDBnlsI/mmI4gNDEwMjIyMTk5NTAxMDEyMjExMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEpYs7lhj6+KQM7dPtHNexJp4FFMcN8FOa3aPKkfGL6GGAihQapYrkKzZkJ/H+ru/gppQS0HpvKVW9dzcpL/ps9aNaMFgwHwYDVR0jBBgwFoAU2Sj8OFaLl9d0kBKWvgNa8Ekx9kgwCwYDVR0PBAQDAgQwMB0GA1UdDgQWBBSKMJ5hpiqWWLJOVbcDAMDd4IYLRDAJBgNVHRMEAjAAMAoGCCqBHM9VAYN1A0cAMEQCIHCXp/k/jwveJBnpHClicE4TJsZECxCXLUK4FY4cKEs2AiA0CeP820CKxAiIvzTdTmzm0X/0z9tq05EZC9GZzmchiw==";
        DInfo.getCertValidity(s1.toString());
        X509Certificate certificate = DInfo.getX509(s1);
        if (certificate == null) {
            System.out.println("null");
        }
        String dn = certificate.getSubjectDN().toString();
        System.out.println(dn);
        Object[] strMyList = dn.split(" ");
        System.out.println(Arrays.toString(strMyList));
        Object[] sfzhs = ((String)strMyList[1]).split(",");
        System.out.println(Arrays.toString(sfzhs));
        Object sfzh = sfzhs[0];
        System.out.println((String)sfzh);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

