/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.control;

import com.xdja.pams.bims.bean.PersonBean;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.commonException.WorkflowException;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.scms.bean.ApplyForm;
import com.xdja.pams.scms.bean.TaskListQueryForm;
import com.xdja.pams.scms.control.DeviceController;
import com.xdja.pams.scms.dao.DeviceWorkflowDao;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.entity.DeviceWorkflow;
import com.xdja.pams.scms.service.ApproveRecordService;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.service.DeviceWorkflowService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodeService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.wfms.bean.WorkflowFlowBean;
import com.xdja.pams.wfms.service.WorkflowUtilService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class DeviceApproveController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(DeviceController.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected DeviceWorkflowService workflowService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DeviceWorkflowDao dwd;
    @Autowired
    CommonCodeService commonCodeService;
    @Autowired
    WorkflowUtilService wus;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected ApproveRecordService approveRecordService;
    @Autowired
    private SystemConfigPbService scps;

    @RequestMapping(value={"scms/deviceapprovecontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            Date date = new Date();
            String fromDate = Util.getDate("yyyy-MM-dd", Util.relationMonth(date, -1));
            String ToDate = Util.getDate("yyyy-MM-dd", date);
            map.put((Object)"fromDate", (Object)fromDate);
            map.put((Object)"toDate", (Object)ToDate);
            sendUrl = this.menuLinkPage;
            map.put((Object)"personId", (Object)this.person.getId());
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"scms/deviceapprovecontroller/forwardrecord.do"})
    public String forwardrecord(HttpServletRequest request, HttpServletResponse response, ModelMap map, String taskId) {
        try {
            map.put((Object)"taskId", (Object)taskId);
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return "scms/approve/default/approverecord";
    }

    @RequestMapping(value={"scms/deviceapprovecontroller/query.do"})
    public void query(String id, PageParam pageParam, HttpServletResponse response, HttpServletRequest request) {
        Page page = new Page();
        page.setRp(Integer.parseInt(pageParam.getRows()));
        page.setPage(Integer.parseInt(pageParam.getPage()));
        ArrayList listmap = new ArrayList();
        DeviceWorkflow dw = this.deviceService.getDeviceWorkFlow(id);
        int operateResult = 0;
        try {
            List<Device> list = dw.getDeviceList();
            for (Device device : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", device.getId());
                map.put("name", device.getName());
                CommonCode cardtype = this.commonCodeService.getByCode(device.getType(), "2000");
                CommonCode commtype = this.commonCodeService.getByCode(device.getCommType(), "2015");
                CommonCode useType = this.commonCodeService.getByCode(device.getUseType(), "useType");
                if (device.getTerminal() != null) {
                    if (device.getMobile() != null) {
                        map.put("mobile", device.getMobile().getId());
                        map.put("mobileText", device.getMobile().getMobile());
                    }
                    map.put("terminalname", device.getTerminal().getTerminalname());
                    String terminaltype = this.commonCodeService.getCodeNameByCode(device.getTerminal().getTerminaltype(), "2020");
                    String terminalos = this.commonCodeService.getCodeNameByCode(device.getTerminal().getTerminalos(), "2022");
                    String terminalband = this.commonCodeService.getCodeNameByCode(device.getTerminal().getTerminalband(), "2021");
                    if (device.getTerminal().getTerminaltype() != null) {
                        map.put("terminaltype", device.getTerminal().getTerminaltype());
                        map.put("terminaltypeText", terminaltype);
                    } else {
                        map.put("terminaltype", "");
                    }
                    if (device.getTerminal().getTerminalos() != null) {
                        map.put("terminalos", device.getTerminal().getTerminalos());
                        map.put("terminalosText", terminalos);
                    } else {
                        map.put("terminalos", "");
                    }
                    if (device.getTerminal().getTerminalband() != null) {
                        map.put("terminalband", device.getTerminal().getTerminalband());
                        map.put("terminalbandText", terminalband);
                    } else {
                        map.put("terminalband", "");
                        map.put("terminalbandText", "");
                    }
                } else {
                    map.put("terminalname", "");
                    map.put("terminaltype", "");
                }
                if (device.getType() != null) {
                    map.put("cardType", device.getType());
                    map.put("cardTypeText", cardtype.getName());
                } else {
                    map.put("cardType", "");
                    map.put("cardTypeText", "");
                }
                if (device.getCommType() != null) {
                    map.put("commType", device.getCommType());
                    map.put("commTypeText", commtype.getName());
                } else {
                    map.put("commType", "");
                    map.put("commTypeText", "");
                }
                if (device.getUseType() != null) {
                    map.put("useType", device.getUseType());
                    map.put("useTypeText", useType.getName());
                } else {
                    map.put("useType", "");
                    map.put("useTypeText", "");
                }
                listmap.add(map);
                operateResult = 1;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(listmap.size()));
        map.put("rows", listmap);
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/deviceapprovecontroller/taskList.do"})
    public void taskList(TaskListQueryForm taskListQueryForm, HttpSession session, HttpServletRequest request, PageParam pageParam, HttpServletResponse response) {
        String jsonStr = "";
        int operateResult = 0;
        try {
            Page page = new Page(pageParam.getPage(), pageParam.getRows());
            ArrayList list = this.workflowService.findTodoTasks(this.person.getId(), page, taskListQueryForm);
            HashMap<String, Serializable> rtnMap = new HashMap<String, Serializable>();
            rtnMap.put("total", Integer.valueOf(page.getTotal()));
            rtnMap.put("rows", list == null ? new ArrayList() : list);
            jsonStr = Util.toJsonStr(rtnMap);
            operateResult = 1;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            jsonStr = "";
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, jsonStr);
    }

    @RequestMapping(value={"scms/deviceapprovecontroller/claim.do"})
    public void claim(String taskIds, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        ReturnResult rr = new ReturnResult();
        try {
            this.workflowService.taskClaim(taskIds, this.person.getId());
            rr.setRtnCode("0");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"scms/deviceapprovecontroller/getWorkflowFlow.do"})
    public void getWorkflowFlow(String taskId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HistoricTaskInstance task = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).singleResult();
        String procInstId = task.getProcessInstanceId();
        HashMap<String, String> map = new HashMap<String, String>();
        List<WorkflowFlowBean> wfbList = this.wus.getWorkFlowBtnList(procInstId);
        if (wfbList == null || wfbList.size() != 1) {
            map.put("workflowFlowBean", null);
        } else {
            map.put("workflowFlowBean", Util.toJsonStr(wfbList.get(0)));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/deviceapprovecontroller/getApproveRecord.do"})
    public void getApproveRecord(String taskId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String jsonStr = "";
        try {
            HistoricTaskInstance task = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).singleResult();
            String procInstId = task.getProcessInstanceId();
            ArrayList list = this.approveRecordService.query(procInstId);
            HashMap<String, Serializable> rtnMap = new HashMap<String, Serializable>();
            if (list == null || list.isEmpty()) {
                rtnMap.put("total", Integer.valueOf(0));
                rtnMap.put("rows", new ArrayList());
            } else {
                rtnMap.put("total", Integer.valueOf(list.size()));
                rtnMap.put("rows", list == null ? new ArrayList() : list);
            }
            jsonStr = Util.toJsonStr(rtnMap);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            jsonStr = "";
        }
        Util.writeUtf8Text(response, jsonStr);
    }

    @RequestMapping(value={"scms/deviceapprovecontroller/detail.do"})
    public String detail(String id, String taskId, String taskdefkey, HttpServletRequest request, ModelMap model) throws Exception {
        try {
            model.put((Object)"cardcount", (Object)this.scps.getValueByCode("cardcount"));
            DeviceWorkflow dw = this.deviceService.getDeviceWorkFlow(id);
            String deviceid = "";
            Map variables = this.taskService.getVariables(taskId);
            dw.setVariables(variables);
            Operator operator = (Operator)request.getSession().getAttribute("operator");
            Person person = operator.getPerson();
            model.put((Object)"applyDate", (Object)dw.getCreateDate());
            model.put((Object)"id", (Object)id);
            model.put((Object)"taskId", (Object)taskId);
            model.put((Object)"taskDefKey", (Object)taskdefkey);
            model.put((Object)"groupId", (Object)"countyManagerUser");
            model.put((Object)"powerId", (Object)"SCMS02");
            model.put((Object)"sysperson_id", (Object)person.getId());
            model.put((Object)"operatorperson_id", (Object)dw.getCreatorId());
            HistoricTaskInstance task = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).singleResult();
            String procInstId = task.getProcessInstanceId();
            List<WorkflowFlowBean> wfbList = this.wus.getWorkFlowBtnList(procInstId);
            if (wfbList == null || wfbList.size() != 1) {
                model.put((Object)"workflowFlowBean", null);
                model.put((Object)"btnName", null);
                model.put((Object)"taskType", null);
            } else {
                model.put((Object)"workflowFlowBean", (Object)Util.toJsonStr(wfbList.get(0)));
                model.put((Object)"btnName", (Object)wfbList.get(0).getBtnName());
                model.put((Object)"taskType", (Object)wfbList.get(0).getTaskType());
            }
            List<Device> devicelist = dw.getDeviceList();
            for (Device device : devicelist) {
                PersonBean personbean = this.userManageService.getPersonById(device.getPersonId());
                model.put((Object)"name", (Object)personbean.getNAME());
                model.put((Object)"code", (Object)personbean.getCODE());
                model.put((Object)"deptname", (Object)personbean.getDEPNAME());
                model.put((Object)"cost", (Object)device);
                model.put((Object)"person_id", (Object)device.getPersonId());
                deviceid = deviceid + device.getId() + ",";
                model.put((Object)"currentURL", (Object)"taskManager/task.action");
                if (!StringUtils.isNotBlank((CharSequence)deviceid)) continue;
                model.put((Object)"deviceid", (Object)deviceid.substring(0, deviceid.length() - 1));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return "scms/approve/default/viewForm";
    }

    @RequestMapping(value={"scms/deviceapprovecontroller/complete.do"})
    public void complete(ApplyForm deviceList, WorkflowFlowBean wfb, HttpSession session, HttpServletResponse response) {
        ReturnResult rr = new ReturnResult();
        try {
            Operator operator = (Operator)session.getAttribute("operator");
            Person person = operator.getPerson();
            if (deviceList == null || wfb == null) {
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "scms.device.apply.error.reqParameterError"));
                log.error(MessageManager.getProMessage(this.message, "scms.device.apply.error.reqParameterError"));
            } else {
                List<Person> depPersons = this.userManageService.getWorkFlowUserListByDep(wfb.getTaskGroupCode(), deviceList.getPersonId(), deviceList.getPowerId(), deviceList.getFlowDep());
                StringBuffer depPersonIds = new StringBuffer();
                if (depPersons != null) {
                    for (Person p : depPersons) {
                        depPersonIds.append(p.getId()).append(",");
                    }
                    if (deviceList.getFlowUser() != null) {
                        deviceList.setFlowUser(depPersonIds.toString() + deviceList.getFlowUser());
                    } else {
                        deviceList.setFlowUser(depPersonIds.toString());
                    }
                }
                boolean cardFlag = false;
                if (!Util.varCheckEmp(deviceList.getFlowDep()) && Util.varCheckEmp(deviceList.getFlowUser())) {
                    rr.setRtnCode("1");
                    rr.setRtnMsg(MessageManager.getProMessage(this.message, "scms.device.apply.error.nofindflowuserError"));
                    log.error(MessageManager.getProMessage(this.message, "scms.device.apply.error.nofindflowuserError"));
                    cardFlag = true;
                }
                if (!cardFlag) {
                    deviceList.setUserId(person.getId());
                    deviceList.setUserName(person.getName());
                    this.workflowService.saveApproveRecord(deviceList, wfb);
                    rr.setRtnCode("0");
                    rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                }
            }
        }
        catch (ActivitiException e) {
            if (e.getMessage().indexOf("no processes deployed with key") != -1) {
                log.error(MessageManager.getProMessage(this.message, "scms.device.apply.error.notWorkflow"), (Throwable)e);
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "scms.device.apply.error.notWorkflow"));
            } else {
                log.error(MessageManager.getProMessage(this.message, "scms.device.apply.error.startWorkflowError"), (Throwable)e);
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "scms.device.apply.error.startWorkflowError"));
            }
        }
        catch (WorkflowException e) {
            log.error("\u5b89\u5168\u5361\u5ba1\u6279\u5f02\u5e38", (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e.getMessage());
        }
        catch (Exception e) {
            log.error("\u5b89\u5168\u5361\u5ba1\u6279\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"scms/deviceapprovecontroller/batchComplete.do"})
    public void batchComplete(ApplyForm deviceList, WorkflowFlowBean wfb, HttpSession session, HttpServletResponse response) {
        ReturnResult rr = new ReturnResult();
        try {
            if (deviceList == null || wfb == null) {
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "scms.device.apply.error.reqParameterError"));
                log.error(MessageManager.getProMessage(this.message, "scms.device.apply.error.reqParameterError"));
            } else {
                List<Person> depPersons = this.userManageService.getWorkFlowUserListByDep(wfb.getTaskGroupCode(), deviceList.getPersonId(), deviceList.getPowerId(), deviceList.getFlowDep());
                StringBuffer depPersonIds = new StringBuffer();
                if (depPersons != null) {
                    for (Person p : depPersons) {
                        depPersonIds.append(p.getId()).append(",");
                    }
                    if (deviceList.getFlowUser() != null) {
                        deviceList.setFlowUser(depPersonIds.toString() + deviceList.getFlowUser());
                    } else {
                        deviceList.setFlowUser(depPersonIds.toString());
                    }
                }
                boolean cardFlag = false;
                if (!Util.varCheckEmp(deviceList.getFlowDep()) && Util.varCheckEmp(deviceList.getFlowUser())) {
                    rr.setRtnCode("1");
                    rr.setRtnMsg(MessageManager.getProMessage(this.message, "scms.device.apply.error.nofindflowuserError"));
                    log.error(MessageManager.getProMessage(this.message, "scms.device.apply.error.nofindflowuserError"));
                    cardFlag = true;
                }
                if (!cardFlag) {
                    deviceList.setUserId(this.person.getId());
                    deviceList.setUserName(this.person.getName());
                    this.workflowService.batchSaveApproveRecord(deviceList, wfb);
                    rr.setRtnCode("0");
                    rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                }
            }
        }
        catch (ActivitiException e) {
            if (e.getMessage().indexOf("no processes deployed with key") != -1) {
                log.error(MessageManager.getProMessage(this.message, "scms.device.apply.error.notWorkflow"), (Throwable)e);
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "scms.device.apply.error.notWorkflow"));
            } else {
                log.error(MessageManager.getProMessage(this.message, "scms.device.apply.error.startWorkflowError"), (Throwable)e);
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "scms.device.apply.error.startWorkflowError"));
            }
        }
        catch (WorkflowException e) {
            log.error("\u5b89\u5168\u5361\u5ba1\u6279\u5f02\u5e38", (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e.getMessage());
        }
        catch (Exception e) {
            log.error("\u5b89\u5168\u5361\u5ba1\u6279\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"/scms/deviceapprovecontroller/getMobile.do"})
    public void getMobile(String personid, HttpServletResponse response) {
        Person person = this.userManageService.queryPersonById(personid);
        List<Mobile> mobilelist = person.getMobiledList();
        ArrayList listmap = new ArrayList();
        for (Mobile code : mobilelist) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", code.getId());
            map.put("code", code.getId());
            map.put("name", code.getMobile());
            listmap.add(map);
        }
        String jsonlist = Util.toJsonStr(listmap);
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/scms/deviceapprovecontroller/toBatchApp.do"})
    public String toBatchApp(String ids, String taskId, String taskdefkey, HttpServletResponse response, ModelMap model) {
        model.put((Object)"ids", (Object)ids);
        model.put((Object)"taskDefKey", (Object)taskdefkey);
        model.put((Object)"groupId", (Object)"countyManagerUser");
        model.put((Object)"powerId", (Object)"SCMS02");
        return "scms/approve/default/batchApprove";
    }

    @RequestMapping(value={"/scms/deviceapprovecontroller/getbatchapps.do"})
    public void getBatchAppList(String ids, PageParam pageParam, HttpServletResponse response, ModelMap model) {
        ArrayList listmap = new ArrayList();
        Page page = new Page(pageParam.getPage(), pageParam.getRows());
        int operateResult = 0;
        try {
            String[] idAndTaskIds;
            ArrayList<Device> list = new ArrayList<Device>();
            for (String idAndTaskId : idAndTaskIds = ids.split(",")) {
                String id = idAndTaskId.split("\\|")[0];
                DeviceWorkflow dw = this.deviceService.getDeviceWorkFlow(id);
                if (dw == null) continue;
                list.addAll(dw.getDeviceList());
            }
            for (Device device : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", device.getId());
                map.put("name", device.getName());
                CommonCode cardtype = this.commonCodeService.getByCode(device.getType(), "2000");
                CommonCode commtype = this.commonCodeService.getByCode(device.getCommType(), "2015");
                if (device.getTerminal() != null) {
                    map.put("mobile", device.getMobile().getPerson().getId());
                    map.put("mobileText", device.getMobile().getMobile());
                    map.put("personname", device.getMobile().getPerson().getCode());
                    map.put("terminalname", device.getTerminal().getTerminalname());
                    CommonCode terminaltype = this.commonCodeService.getByCode(device.getTerminal().getTerminaltype(), "2020");
                    CommonCode terminalos = this.commonCodeService.getByCode(device.getTerminal().getTerminalos(), "2022");
                    CommonCode terminalband = this.commonCodeService.getByCode(device.getTerminal().getTerminalband(), "2021");
                    if (device.getTerminal().getTerminaltype() != null) {
                        map.put("terminaltype", device.getTerminal().getTerminaltype());
                        map.put("terminaltypeText", terminaltype.getName());
                    } else {
                        map.put("terminaltype", "");
                    }
                    if (device.getTerminal().getTerminalos() != null) {
                        map.put("terminalos", device.getTerminal().getTerminalos());
                        map.put("terminalosText", terminalos.getName());
                    } else {
                        map.put("terminalos", "");
                    }
                    if (device.getTerminal().getTerminalband() != null) {
                        map.put("terminalband", device.getTerminal().getTerminalband());
                        map.put("terminalbandText", terminalband.getName());
                    } else {
                        map.put("terminalband", "");
                        map.put("terminalbandText", "");
                    }
                } else {
                    map.put("terminalname", "");
                    map.put("terminaltype", "");
                }
                if (device.getType() != null) {
                    map.put("cardType", device.getType());
                    map.put("cardTypeText", cardtype.getName());
                } else {
                    map.put("cardType", "");
                    map.put("cardTypeText", "");
                }
                if (device.getCommType() != null) {
                    map.put("commType", device.getCommType());
                    map.put("commTypeText", commtype.getName());
                } else {
                    map.put("commType", "");
                    map.put("commTypeText", "");
                }
                listmap.add(map);
                operateResult = 1;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(listmap.size()));
        map.put("rows", listmap);
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    public void batchApp(String ids, HttpServletResponse response, ModelMap model) {
        String[] idarr = ids.split(",");
    }
}

