/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.control;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class DownloadController {
    private static final Logger log = LoggerFactory.getLogger(DownloadController.class);

    @RequestMapping(value={"scms/downloadcontroller/index.do"})
    public String index() {
        return "scms/download/default/index";
    }

    @RequestMapping(value={"scms/downloadcontroller/downloadcert.do"})
    public void downloadcert(String filename, HttpServletRequest request, HttpServletResponse response) {
        String filePath = "certuser";
        filename = filename + ".pfx";
        this.download(filename, request, response, filePath);
    }

    @RequestMapping(value={"scms/downloadcontroller/download.do"})
    public void download(String filename, HttpServletRequest request, HttpServletResponse response) {
        String exportDir = "download/";
        this.download(filename, request, response, exportDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(String filename, HttpServletRequest request, HttpServletResponse response, String dir) {
        String path = request.getSession().getServletContext().getRealPath(dir);
        String filepath = path + File.separator + filename;
        File file = null;
        OutputStream os = null;
        BufferedInputStream fin = null;
        try {
            response.setContentType("application/x-msdownload");
            response.setHeader("Content-Disposition", "attachment; filename=" + filename);
            file = new File(filepath);
            os = response.getOutputStream();
            if (file.exists()) {
                fin = new BufferedInputStream(new FileInputStream(file));
                if (fin != null) {
                    byte[] b = new byte[2048];
                    int i = 0;
                    while ((i = fin.read(b)) > 0) {
                        os.write(b, 0, i);
                    }
                }
                os.flush();
                os.close();
                fin.close();
                os = null;
                fin = null;
            } else {
                response.setContentType("text/plain;charset=UTF-8");
                os.write("<script type=text/javascript>alert('\u60a8\u4e0b\u8f7d\u7684\u6587\u4ef6\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u4e0a\u4f20\uff0c\\n\u8bf7\u70b9\u51fb\u786e\u5b9a\u7ee7\u7eed\u4e0b\u8f7d\uff01');window.location.href='index.do';</script>".getBytes("UTF-8"));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (fin != null) {
                    fin.close();
                }
                file = null;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

