/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.control;

import com.xdja.pams.bims.bean.PersonBean;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.scms.bean.DInfo;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.entity.Terminal;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigService;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class ReadCardController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(ReadCardController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private UserManageService userManagerService;
    @Autowired
    private CommonCodePbService commonCodeService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private SystemLogService systemLogService;

    @RequestMapping(value={"scms/readcardcontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            DInfo dInfo = this.systemConfigService.getDInfo();
            map.addAttribute("isSM2", (Object)dInfo.getIsSM2());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"scms/readcardcontroller/readcard.do"})
    public void readCard(String cardNO, HttpServletRequest request, PageParam page, HttpServletResponse response) {
        HashMap<String, String> p = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int operateResult = 0;
        try {
            Device device = this.deviceService.getByCardNO(cardNO);
            if (device != null) {
                Person person = this.userManagerService.queryPersonById(device.getPersonId());
                p.put("code", person.getCode());
                p.put("name", Util.cvNameByPersonType(person.getName(), person.getPersonType()));
                CommonCode gradeCode = this.commonCodeService.getByCode(person.getPosition(), "2011");
                p.put("grade", gradeCode != null ? gradeCode.getName() : "");
                p.put("identifier", person.getIdentifier());
                CommonCode sexCode = this.commonCodeService.getByCode(person.getSex(), "sex");
                p.put("sex", sexCode != null ? sexCode.getName() : "");
                CommonCode policecode = this.commonCodeService.getByCode(person.getPolice(), "2012");
                p.put("police", policecode != null ? policecode.getName() : "");
                p.put("depname", person.getDepartment().getName());
                p.put("mobile", device.getMobile() != null ? device.getMobile().getMobile() : "");
                p.put("personTypeName", this.commonCodeService.getCodeNameByCode(person.getPersonType(), "PERSON_TYPE"));
                CommonCode cardtypecode = this.commonCodeService.getByCode(device.getType(), "2000");
                p.put("cardtype", cardtypecode != null ? cardtypecode.getName() : "");
                map.put("flag", "1");
                map.put("obj", p);
            } else {
                map.put("flag", "0");
                map.put("", "");
            }
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u5b89\u5168\u5361\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            map.put("flag", 0);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/readcardcontroller/readCardIdentifier.do"})
    public void readCardIdentifier(String derCert, HttpServletRequest request, PageParam page, HttpServletResponse response) {
        HashMap<String, Object> p = new HashMap<String, Object>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int operateResult = 0;
        String dnIdentifier = null;
        try {
            if (derCert == null || derCert.length() < 100) {
                throw new RuntimeException("\u8bc1\u4e66\u5185\u5bb9\u4e3a\u7a7a");
            }
            X509Certificate cert = DInfo.getCertByDerString(derCert);
            if (cert == null) {
                throw new RuntimeException("\u8bc1\u4e66\u683c\u5f0f\u9519\u8bef\uff0c\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25");
            }
            String dn = cert.getSubjectDN().getName();
            if (dn != null && dn.length() > 0) {
                String[] dnarr;
                for (String tmp : dnarr = dn.split(",")) {
                    if (tmp == null || tmp.indexOf("CN=") < 0 || tmp.split(" ").length <= 1) continue;
                    dnIdentifier = tmp.split(" ")[1].replaceAll(" ", "");
                    break;
                }
            }
            if (dnIdentifier != null) {
                Person person = this.userManagerService.getUserByIdentifer(dnIdentifier);
                if (person != null) {
                    p.put("id", person.getId());
                    p.put("code", person.getCode());
                    p.put("name", Util.cvNameByPersonType(person.getName(), person.getPersonType()));
                    CommonCode gradeCode = this.commonCodeService.getByCode(person.getPosition(), "2011");
                    p.put("grade", gradeCode != null ? gradeCode.getName() : "");
                    p.put("identifier", person.getIdentifier());
                    CommonCode sexCode = this.commonCodeService.getByCode(person.getSex(), "sex");
                    p.put("sex", sexCode != null ? sexCode.getName() : "");
                    CommonCode policecode = this.commonCodeService.getByCode(person.getPolice(), "2012");
                    p.put("police", policecode != null ? policecode.getName() : "");
                    p.put("depname", person.getDepartment().getName());
                    p.put("personTypeName", this.commonCodeService.getCodeNameByCode(person.getPersonType(), "PERSON_TYPE"));
                    p.put("mobile", person.getMobiledList());
                    map.put("flag", "1");
                    map.put("obj", p);
                } else {
                    map.put("flag", "0");
                    map.put("obj", "\u8bc1\u4e66\u5173\u8054\u8eab\u4efd\u8bc1\u53f7[" + dnIdentifier + "]\u4e0d\u80fd\u5b58\u5728\uff0c\u8bf7\u6dfb\u52a0\u7528\u6237\u4fe1\u606f");
                }
            } else {
                map.put("flag", "0");
                map.put("obj", "\u8bc1\u4e66\u672a\u5173\u8054\u8eab\u4efd\u8bc1\u53f7");
            }
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u5b89\u5168\u5361\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            map.put("flag", 0);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/readcardcontroller/readcardinfo.do"})
    public void readCardNoLogin(String cardNO, HttpServletRequest request, PageParam page, HttpServletResponse response) {
        Device device = this.deviceService.getByCardNO(cardNO);
        HashMap<String, String> p = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean operateResult = false;
        try {
            if (device != null) {
                PersonBean person = this.userManagerService.getPersonById(device.getPersonId());
                p.put("code", person.getCODE());
                p.put("name", person.getNAME());
                p.put("grade", person.getGRADE());
                p.put("identifier", person.getIDENTIFIER());
                p.put("sex", person.getSEX());
                CommonCode policecode = this.commonCodeService.getByCode(person.getPOLICE(), "2012");
                p.put("police", policecode.getName());
                p.put("policeCode", person.getPOLICE());
                p.put("depName", person.getDEPNAME());
                p.put("depCode", person.getDEPCODE());
                p.put("mobile", device.getMobile() != null ? device.getMobile().getMobile() : "");
                CommonCode cardtypecode = this.commonCodeService.getByCode(device.getType(), "2000");
                p.put("cardtype", cardtypecode != null ? cardtypecode.getName() : "");
                map.put("flag", "1");
                map.put("obj", p);
            } else {
                map.put("flag", "0");
                map.put("obj", "");
            }
            operateResult = true;
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u5b89\u5168\u5361\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            map.put("flag", 0);
            map.put("obj", "");
        }
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/readcardcontroller/bindCard.do"})
    public void bindCard(HttpServletRequest request, HttpServletResponse response, String cardNO, String personId, String mobileStr, String cerDer, String cardType) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Device device0 = this.deviceService.getByCardNO(cardNO);
            if (device0 != null) {
                throw new RuntimeException("\u5b89\u5168\u5361\u5df2\u7ed1\u5b9a\uff0c\u4e0d\u80fd\u518d\u6b21\u7ed1\u5b9a");
            }
            if (cerDer == null || cerDer.length() < 100) {
                throw new RuntimeException("\u8bc1\u4e66\u5185\u5bb9\u4e3a\u7a7a");
            }
            X509Certificate cert = DInfo.getCertByDerString(cerDer);
            if (cert == null) {
                throw new RuntimeException("\u8bc1\u4e66\u683c\u5f0f\u9519\u8bef\uff0c\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25");
            }
            String dnIdentifier = null;
            String dn = cert.getSubjectDN().getName();
            if (dn != null && dn.length() > 0) {
                String[] dnarr;
                for (String tmp : dnarr = dn.split(",")) {
                    if (tmp == null || tmp.indexOf("CN=") < 0 || tmp.split(" ").length <= 1) continue;
                    dnIdentifier = tmp.split(" ")[1].replaceAll(" ", "");
                    break;
                }
            }
            if (dnIdentifier != null) {
                Person person = this.userManagerService.queryPersonById(personId);
                if (person == null) {
                    throw new RuntimeException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                if (!dnIdentifier.equals(person.getIdentifier())) {
                    throw new RuntimeException("\u7ed1\u5b9a\u7528\u6237\u548c\u53d1\u8bc1\u7528\u6237\u4e0d\u662f\u540c\u4e00\u4eba\uff0c\u4e0d\u80fd\u7ed1\u5b9a");
                }
            }
            String sn = cert.getSerialNumber().toString(16);
            String certificate = DInfo.getBase64FromCert(cert);
            certificate = certificate.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "").replaceAll("\r|\n", "");
            Device device = new Device();
            device.setAlgType("1");
            Date now = new Date();
            device.setApplyDate(now);
            device.setBindingDate(now);
            device.setCertificate(certificate);
            device.setCommType("1");
            device.setFlag("1");
            device.setHardNo(cardNO);
            device.setIccid(cardNO);
            Mobile mobile = this.userManagerService.getMobile(mobileStr);
            device.setMobile(mobile);
            device.setName("");
            device.setOpenDate(now);
            device.setPersonId(personId);
            device.setSn(sn);
            device.setState("3");
            Terminal terminal = new Terminal();
            terminal.setDevice(device);
            terminal.setPoliceAppVersion("0");
            terminal.setTerminalband("000");
            terminal.setTerminalname("");
            terminal.setTerminalos("001");
            terminal.setTerminaltype("1");
            terminal.setTestresult("0");
            device.setTerminal(terminal);
            device.setTimestamp(now.getTime());
            device.setType(cardType);
            device.setTerminal(terminal);
            device.setLockState("0");
            device.setBindingState("0");
            if ("2".equals(cardType)) {
                device.setUseType("1");
            } else {
                device.setUseType("0");
            }
            device.setWriteCardDate(now);
            this.deviceService.save(device);
            map.put("flag", "1");
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u7ed1\u5b9a\u5b89\u5168\u5361\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            map.put("flag", "0");
            map.put("msg", e.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }
}

