/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.control;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.scms.entity.TerminalLog;
import com.xdja.pams.scms.service.TerminalLogService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.HttpResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class TerminalLogController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(TerminalLogController.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private TerminalLogService terminalLogService;
    @Autowired
    private CommonCodePbService commonCodeService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private DepManageService depManagerService;

    @RequestMapping(value={"scms/terminallogcontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"scms/terminallogcontroller/query.do"})
    public void query(PageParam pageParm, HttpServletResponse response) {
        int operateResult = 0;
        ArrayList listmap = new ArrayList();
        HashMap<String, Serializable> map1 = new HashMap<String, Serializable>();
        try {
            Page p = new Page(pageParm.getPage(), pageParm.getRows());
            List<TerminalLog> list = this.terminalLogService.query(p);
            for (TerminalLog tl : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", tl.getId());
                map.put("name", tl.getName());
                map.put("code", tl.getCode());
                Department dep = this.depManagerService.getDepartmentByCode(tl.getDept());
                map.put("depname", dep != null ? dep.getName() : tl.getDept());
                map.put("identifier", tl.getIdentifier());
                map.put("mobile", tl.getMobile());
                CommonCode code = this.commonCodeService.getByCode(tl.getCardType(), "2000");
                map.put("cardType", code != null ? code.getName() : "");
                code = this.commonCodeService.getByCode(tl.getOpFlag(), "2023");
                map.put("opFlag", code != null ? code.getName() : "");
                listmap.add(map);
            }
            map1.put("total", Integer.valueOf(p.getTotal()));
            map1.put("rows", listmap);
            operateResult = 1;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(map1));
    }

    @RequestMapping(value={"scms/terminallogcontroller/submit.do"})
    public void submit(HttpServletRequest request, HttpServletResponse response) {
        int operateResult = 0;
        ReturnResult rr = new ReturnResult();
        try {
            this.terminalLogService.submit();
            rr.setRtnCode("0");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (ConnectException e) {
            log.error(e.getMessage(), (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "device.terminallog.error.timeout"));
        }
        catch (HttpResponseException e) {
            log.error(e.getMessage(), (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "device.terminallog.error.urlerror"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    public TerminalLogService getTerminalLogService() {
        return this.terminalLogService;
    }

    public void setTerminalLogService(TerminalLogService terminalLogService) {
        this.terminalLogService = terminalLogService;
    }

    public CommonCodePbService getCommonCodeService() {
        return this.commonCodeService;
    }

    public void setCommonCodeService(CommonCodePbService commonCodeService) {
        this.commonCodeService = commonCodeService;
    }

    public SystemLogService getSystemLogService() {
        return this.systemLogService;
    }

    public void setSystemLogService(SystemLogService systemLogService) {
        this.systemLogService = systemLogService;
    }

    public DepManageService getDepManagerService() {
        return this.depManagerService;
    }

    public void setDepManagerService(DepManageService depManagerService) {
        this.depManagerService = depManagerService;
    }
}

