/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.service.CommonTreeService;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.bean.TerminalBean;
import com.xdja.pams.scms.bean.TerminalPersonBean;
import com.xdja.pams.scms.service.TerminalPersonService;
import com.xdja.pams.scms.service.TerminalService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class TerminalManagerController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(TerminalManagerController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private TerminalPersonService terminalPersonService;
    @Autowired
    private TerminalService terminalService;
    @Autowired
    private CommonTreeService commonTreeService;

    @RequestMapping(value={"scms/terminalmanagercontroller/index"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"scms/terminalmanagercontroller/addPage"})
    public String showAddTerManPage(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        return "scms/terminalmanager/default/addTerminal";
    }

    @RequestMapping(value={"scms/terminalmanagercontroller/toEditPage"})
    public String toEditPage(HttpServletRequest request, HttpServletResponse response, ModelMap map, String terminalId) {
        TerminalPersonBean terminalPersonBean = new TerminalPersonBean();
        terminalPersonBean.setId(terminalId);
        List<TerminalPersonBean> terminalPersonBeanList = this.terminalPersonService.getTerminalPerson(terminalPersonBean, null);
        if (!terminalPersonBeanList.isEmpty()) {
            TerminalPersonBean tpBean = terminalPersonBeanList.get(0);
            map.put((Object)"terminalPerson", (Object)tpBean);
        }
        return "scms/terminalmanager/default/editTerminal";
    }

    @RequestMapping(value={"scms/terminalmanagercontroller/query"})
    public void getTerminalPerson(HttpServletRequest request, HttpServletResponse response, TerminalPersonBean terminalPersonBean, PageParam pageParam) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Page page = new Page();
            page.setRp(Integer.parseInt(pageParam.getRows()));
            page.setPage(Integer.parseInt(pageParam.getPage()));
            List<TerminalPersonBean> terminalPersonList = this.terminalPersonService.getTerminalPerson(terminalPersonBean, page);
            map.put("total", page.getTotal());
            map.put("rows", terminalPersonList);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/terminalmanagercontroller/save"})
    public void saveTerminalPerson(HttpServletRequest request, HttpServletResponse response, TerminalPersonBean terminalPersonBean) {
        ReturnResult returnResult = new ReturnResult();
        try {
            TerminalBean terminalBean = new TerminalBean();
            terminalBean.setTerminalband(terminalPersonBean.getTerminalBand());
            terminalBean.setTerminalname(terminalPersonBean.getTerminalName());
            List<TerminalBean> terminalBeanList = this.terminalService.getTerminal(terminalBean, null);
            if (terminalBeanList.isEmpty()) {
                returnResult.setRtnCode("1");
                returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + "\u4e0d\u5b58\u5728\u8be5\u6d4b\u8bd5\u901a\u8fc7\u7ec8\u7aef");
            } else {
                terminalPersonBean.setTerminalId(terminalBeanList.get(0).getId());
                this.terminalPersonService.save(terminalPersonBean);
                returnResult.setRtnCode("0");
                returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(returnResult));
    }

    @RequestMapping(value={"scms/terminalmanagercontroller/update"})
    public void updateTerminalPerson(HttpServletRequest request, HttpServletResponse response, TerminalPersonBean terminalPersonBean) {
        ReturnResult returnResult = new ReturnResult();
        try {
            TerminalBean terminalBean = new TerminalBean();
            terminalBean.setTerminalband(terminalPersonBean.getTerminalBand());
            terminalBean.setTerminalname(terminalPersonBean.getTerminalName());
            List<TerminalBean> terminalBeanList = this.terminalService.getTerminal(terminalBean, null);
            if (terminalBeanList.isEmpty()) {
                returnResult.setRtnCode("1");
                returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + "\u6ca1\u6709\u8be5\u6d4b\u8bd5\u901a\u8fc7\u7ec8\u7aef");
            } else {
                terminalPersonBean.setTerminalId(terminalBeanList.get(0).getId());
                this.terminalPersonService.update(terminalPersonBean);
                returnResult.setRtnCode("0");
                returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(returnResult));
    }

    @RequestMapping(value={"scms/terminalmanagercontroller/delete"})
    public void deleteTerminalPerson(HttpServletRequest request, HttpServletResponse response, String terminalId) {
        ReturnResult returnResult = new ReturnResult();
        try {
            TerminalPersonBean terminalPersonBean = new TerminalPersonBean();
            terminalPersonBean.setId(terminalId);
            this.terminalPersonService.delete(terminalPersonBean);
            returnResult.setRtnCode("0");
            returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(returnResult));
    }

    @RequestMapping(value={"scms/terminalmanagercontroller/getPass"})
    public void getList(String type, String code, HttpServletResponse response) throws IOException {
        String jsonlist = "";
        ArrayList<Map<Object, Object>> retList = new ArrayList<Map<Object, Object>>();
        HashMap<String, String> map0 = new HashMap<String, String>();
        map0.put("code", "");
        map0.put("name", MessageManager.getProMessage(this.message, "commontree.commoncode.select"));
        retList.add(map0);
        try {
            List<TerminalPersonBean> terminalBeanList = this.terminalPersonService.getTerminalPass(type, code);
            if (type.equals("0")) {
                List<Map<String, Object>> listmap = this.commonTreeService.getChild2("2021");
                for (TerminalPersonBean terminalPerson : terminalBeanList) {
                    for (Map<String, Object> map : listmap) {
                        Set<Map.Entry<String, Object>> set = map.entrySet();
                        Iterator<Map.Entry<String, Object>> it = set.iterator();
                        Map.Entry<String, Object> entry = null;
                        while (it.hasNext()) {
                            entry = it.next();
                            if (!entry.getKey().equals("code") || !entry.getValue().equals(terminalPerson.getTerminalBand())) continue;
                            retList.add(map);
                        }
                    }
                }
            } else if (type.equals("1")) {
                HashMap<String, String> map1 = new HashMap<String, String>();
                for (TerminalPersonBean terminalPerson : terminalBeanList) {
                    map1 = new HashMap();
                    map1.put("code", terminalPerson.getTerminalName());
                    map1.put("name", terminalPerson.getTerminalName());
                    retList.add(map1);
                }
            }
            jsonlist = Util.toJsonStr(retList);
        }
        catch (Exception e) {
            log.error("#\u83b7\u53d6\u7ec8\u7aef\u54c1\u724c\u6216\u578b\u53f7\u9519\u8bef:" + e.getMessage(), (Throwable)e);
        }
        Util.writeUtf8Text(response, jsonlist);
    }
}

