/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.dao.impl;

import com.xdja.pams.bims.util.BimsUtil;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.scms.bean.QueryForm;
import com.xdja.pams.scms.dao.DeviceHistoryDao;
import com.xdja.pams.scms.entity.DeviceHistory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class DeviceHistoryDaoImpl
implements DeviceHistoryDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    @Transactional
    public DeviceHistory save(DeviceHistory deviceHistory) {
        this.baseDao.create(deviceHistory);
        return deviceHistory;
    }

    @Override
    public List<DeviceHistory> query(QueryForm form, Page page) {
        StringBuilder select = new StringBuilder("from T_DEVICE_HISTORY d,T_PERSON p, T_Department dep where d.person_Id=p.id and p.dep_Id=dep.id and  dep.id  in (" + BimsUtil.getChildDepsSql(form.getControlDeps()) + ") ");
        ArrayList<String> list = new ArrayList<String>();
        if (form != null) {
            if (StringUtils.isNotBlank((CharSequence)form.getCode())) {
                select.append(" and p.code like ? ");
                list.add("%" + form.getCode() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)form.getName())) {
                select.append(" and p.name like ?");
                list.add("%" + form.getName() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)form.getMobile())) {
                select.append(" and d.mobile like ?");
                list.add("%" + form.getMobile() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)form.getPersonType())) {
                select.append(" and p.person_type=?");
                list.add(form.getPersonType());
            }
            if (StringUtils.isNotBlank((CharSequence)form.getDepId())) {
                select.append(" and dep.name  like ?");
                list.add("%" + form.getDepId() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)form.getCardType())) {
                select.append(" and d.type=?");
                list.add(form.getCardType());
            }
        }
        String selectCount = "select count(*) " + select.toString();
        Object[] values = null;
        if (list != null) {
            values = list.toArray(new String[0]);
        }
        return this.baseDao.getListBySQL(selectCount, "select d.* " + select.toString(), values, page, DeviceHistory.class);
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }
}

