/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.service.impl;

import com.xdja.pams.scms.dao.PersonKOALInfoDao;
import com.xdja.pams.scms.entity.PersonKOALInfo;
import com.xdja.pams.scms.service.PersonKOALInfoService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PersonKOALInfoServiceImpl
implements PersonKOALInfoService {
    @Autowired
    private PersonKOALInfoDao dao;

    @Override
    @Transactional
    public void save(String personId, String koalId, String note, String cardType) {
        PersonKOALInfo pkI = this.findByPerson(personId, cardType);
        if (pkI != null) {
            return;
        }
        PersonKOALInfo pk = new PersonKOALInfo();
        pk.setCreateDate(new Date());
        pk.setKoalId(koalId);
        pk.setNote(note);
        pk.setPersonId(personId);
        pk.setState("0");
        pk.setCardType(cardType);
        this.dao.save(pk);
    }

    @Override
    public PersonKOALInfo findByPerson(String personId, String cardType) {
        return this.dao.findByPersonId(personId, cardType);
    }

    @Override
    @Transactional
    public void updateState(String personId, String cardType) {
        PersonKOALInfo pki = this.findByPerson(personId, cardType);
        if (pki == null) {
            return;
        }
        pki.setState("1");
        this.dao.update(pki);
    }

    @Override
    @Transactional
    public void delete(PersonKOALInfo entity) {
        this.dao.delete(entity);
    }

    @Override
    public PersonKOALInfo findByDeviceId(String deviceId) {
        return this.dao.findByDeviceId(deviceId);
    }

    @Override
    @Transactional
    public PersonKOALInfo save(String personId, String deviceId, String koalId, String note, String cardType) {
        PersonKOALInfo pkI = this.findByDeviceId(deviceId);
        if (pkI != null) {
            pkI.setKoalId(koalId);
            this.dao.update(pkI);
            return pkI;
        }
        PersonKOALInfo pk = new PersonKOALInfo();
        pk.setCreateDate(new Date());
        pk.setKoalId(koalId);
        pk.setNote(note);
        pk.setPersonId(personId);
        pk.setState("0");
        pk.setCardType(cardType);
        pk.setDeviceId(deviceId);
        this.dao.save(pk);
        return pk;
    }

    @Override
    @Transactional
    public void updateState(String id) {
        PersonKOALInfo pki = this.dao.findById(id);
        if (pki == null) {
            return;
        }
        pki.setState("1");
        this.dao.update(pki);
    }

    @Override
    public void updatePki(PersonKOALInfo pki) {
        this.dao.update(pki);
    }
}

