/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.service.impl;

import com.xdja.pams.bims.bean.QueryDeviceBean;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.scms.bean.TRInfo;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.entity.Terminal;
import com.xdja.pams.scms.entity.TerminalLog;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.service.TerminalLogService;
import com.xdja.pams.scms.service.TerminalReportService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.webservice.client.CommonCascadeClient;
import com.xdja.pams.webservice.meta.TerminalBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TerminalReportServiceImpl
implements TerminalReportService {
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private TerminalLogService terminalLogService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    private static final Logger log = LoggerFactory.getLogger(TerminalReportServiceImpl.class);

    @Override
    public String report(TerminalLog terminalLog) throws Exception {
        TRInfo trInfo = this.systemConfigService.getTRInfo();
        TerminalBean terminal = new TerminalBean();
        terminal.setSn(terminalLog.getSn());
        terminal.setOperation(terminalLog.getOpFlag());
        terminal.setCardType(TRInfo.getCardType(terminalLog.getCardType()));
        terminal.setName(terminalLog.getName());
        terminal.setCode(terminalLog.getCode());
        terminal.setIdentifier(terminalLog.getIdentifier());
        terminal.setDeptCode(terminalLog.getDept());
        terminal.setAreaCode(terminal.getDeptCode().substring(0, 4));
        terminal.setTerminalName(terminalLog.getTerminalName());
        terminal.setTerminalOs(terminalLog.getTerminalOS());
        terminal.setTerminalOutLink(terminalLog.getTerminalOutlink());
        terminal.setTerminalBand(this.getCascadeTerminalBrand(terminalLog.getTerminalBand()));
        terminal.setCardId(terminalLog.getCardNumber());
        terminal.setMobile(terminalLog.getMobile());
        terminal.setCardName(trInfo.getCardName());
        terminal.setCardVersion(trInfo.getCardVersion());
        terminal.setPolice(terminalLog.getPolice());
        terminal.setGrade(terminalLog.getGrade());
        terminal.setMmpCode(trInfo.getMmcode());
        terminal.setTerminalType(terminalLog.getTerminalType());
        String rst = "";
        if ("1".equals(trInfo.getTrSwitch()) && "1".equals(rst = this.report(terminal, trInfo))) {
            terminalLog.setSynchoreFlag("1");
            this.terminalLogService.update(terminalLog);
        }
        return rst;
    }

    private String report(TerminalBean terminal, TRInfo trInfo) throws Exception {
        String rst = null;
        String synchroFLag = "0";
        ArrayList<TerminalBean> list = new ArrayList<TerminalBean>();
        list.add(terminal);
        List<String> rsts = CommonCascadeClient.terminalReport(trInfo.getUrl(), list);
        if (rsts != null && rsts.size() > 0 && "1".equals(rst = rsts.get(0))) {
            synchroFLag = "1";
        }
        return rst;
    }

    private String getCascadeTerminalBrand(String brand) {
        return brand;
    }

    @Override
    public void saveAndReportLog(Device device, String operateType) {
        try {
            TerminalLog terminalLog = this.deviceService.cvsDeviceToTerminalLog(device, operateType);
            this.terminalLogService.save(terminalLog);
            this.report(terminalLog);
        }
        catch (Exception e) {
            log.error("\u7ea7\u8054\u76d1\u63a7\u65e5\u5fd7\u4e0a\u62a5\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public boolean judgeIsReportForPerson(Person person, Person oldPerson) {
        if ("0".equals(this.systemConfigPbService.getValueByCode("person_report"))) {
            return false;
        }
        if (!this.deviceService.isWrite(person.getId())) {
            return false;
        }
        return !oldPerson.getCode().equals(person.getCode()) || !oldPerson.getDepId().equals(person.getDepId()) || !oldPerson.getIdentifier().equals(person.getIdentifier()) || !oldPerson.getName().equals(person.getName()) || !oldPerson.getPolice().equals(person.getPolice());
    }

    @Override
    public boolean jubgeIsReportForDevice(QueryDeviceBean device, Device oldDevice) {
        if (device.getState().equals("1") || device.getState().equals("0")) {
            return false;
        }
        Terminal terminal = oldDevice.getTerminal();
        if (terminal.getTerminalname() == null) {
            terminal.setTerminalname("$%#Wadfad*&");
        }
        if (device.getTerminalName() == null) {
            device.setTerminalName("$%#Wadfad*&");
        }
        if (oldDevice.getName() == null) {
            oldDevice.setName("");
        }
        return !terminal.getTerminalband().equals(device.getTerminalBrand()) || !terminal.getTerminalname().equals(device.getTerminalName()) || !terminal.getTerminalos().equals(device.getTerminalOs()) || !terminal.getTerminaltype().equals(device.getTerminalType()) || !oldDevice.getName().equals(device.getCardName());
    }

    @Override
    public void saveAndReportLogForEdit(Person person) {
        List<Device> deviceList = this.deviceService.getByPersonId(person.getId());
        for (Device device : deviceList) {
            if (device.getState().equals("1") || device.getState().equals("0")) continue;
            this.saveAndReportLog(device, "2");
        }
    }

    @Override
    public void saveAndReportLogForCardInfoEdit(QueryDeviceBean device) {
        this.saveAndReportLog(this.deviceService.get((Serializable)((Object)device.getCardId())), "2");
    }
}

