/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.bean.VideoBean;
import com.xdja.pams.scms.bean.VideoReq;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.service.VideoDeviceAPIService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VideoDeviceAPIServiceImpl
implements VideoDeviceAPIService {
    private static final Logger log = LoggerFactory.getLogger(VideoDeviceAPIServiceImpl.class);
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private UserManageService userManageService;

    @Override
    public String queryVideoInfo(String queryCondition) {
        log.debug(queryCondition);
        VideoReq videoReq = Util.readValue(queryCondition, VideoReq.class);
        if (videoReq == null) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u6709\u8bef\uff01");
        }
        if (videoReq.getCardId() != null && videoReq.getCardId().length() > 0) {
            VideoBean videoBean = this.queryByCardId(videoReq.getCardId());
            return Util.toJsonStr(videoBean);
        }
        String latestTimestamp = videoReq.getLatestTimestamp();
        String pageNum = videoReq.getPageNum();
        String pageSize = videoReq.getPageSize();
        if (latestTimestamp == null || latestTimestamp.length() < 1) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u6709\u8bef\uff01");
        }
        try {
            Long.parseLong(latestTimestamp);
        }
        catch (NumberFormatException e1) {
            log.error("\u9875\u7801\u8f6c\u6362\u5f02\u5e38", (Throwable)e1);
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u6709\u8bef\uff0c\u65f6\u95f4\u6233\u683c\u5f0f\u9519\u8bef\uff01");
        }
        Page page = new Page();
        try {
            page.setPage(Integer.parseInt(pageNum));
            page.setRp(Integer.parseInt(pageSize));
        }
        catch (NumberFormatException e) {
            log.error("\u9875\u7801\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u6709\u8bef\uff0c\u9875\u7801\u6216\u6bcf\u9875\u6570\u91cf\u9519\u8bef\uff01");
        }
        List<VideoBean> videoList = this.queryList(videoReq, page);
        HashMap<String, Object> rst = new HashMap<String, Object>();
        rst.put("total", page.getTotal());
        rst.put("pageSum", page.getPageCount());
        rst.put("rows", videoList);
        return Util.toJsonStr(rst);
    }

    private VideoBean queryByCardId(String cardId) {
        Device device = this.deviceService.getByCardNO(cardId);
        if (device == null) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u8bb0\u5f55\u4fe1\u606f\uff01");
        }
        VideoBean videoBean = new VideoBean();
        Person person = this.userManageService.queryPersonById(device.getPersonId());
        videoBean.setCode(person.getCode());
        videoBean.setDepartment(person.getDepartment().getName());
        videoBean.setDeviceID(device.getVideoDeviceNO());
        videoBean.setFlag(device.getVideoDeviceOpenState());
        videoBean.setName(person.getName());
        videoBean.setTimestamp(Long.toString(device.getTimestamp()));
        return videoBean;
    }

    private List<VideoBean> queryList(VideoReq videoReq, Page page) {
        List<Device> list = this.deviceService.queryVideoDeviceList(Long.parseLong(videoReq.getLatestTimestamp()), page);
        if (list == null || list.isEmpty()) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u8bb0\u5f55\u4fe1\u606f\uff01");
        }
        ArrayList<VideoBean> vl = new ArrayList<VideoBean>();
        for (Device device : list) {
            VideoBean videoBean = new VideoBean();
            Person person = this.userManageService.queryPersonById(device.getPersonId());
            videoBean.setCode(person.getCode());
            videoBean.setDepartment(person.getDepartment().getName());
            videoBean.setDeviceID(device.getVideoDeviceNO());
            videoBean.setFlag(device.getVideoDeviceOpenState());
            videoBean.setName(person.getName());
            videoBean.setTimestamp(Long.toString(device.getTimestamp()));
            vl.add(videoBean);
        }
        return vl;
    }
}

