/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.sms.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sms.bean.QueryForm;
import com.xdja.pams.sms.bean.SmsFormBean;
import com.xdja.pams.sms.dao.SmsDao;
import com.xdja.pams.sms.entity.Sms;
import com.xdja.pams.sms.service.SmsService;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.CommonCodeService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.tims.dao.MsgPushDao;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SmsServiceImpl
implements SmsService {
    @Autowired
    private SmsDao smsDao;
    @Autowired
    CommonCodePbService ccps;
    @Autowired
    private MsgPushDao msgPushDao;
    @Autowired
    private UserManageService userManagerService;
    @Autowired
    private CommonCodeService commonCodeService;
    @Autowired
    private SystemConfigPbService systemConfigService;

    @Override
    public List<Sms> query(QueryForm form, Page page) {
        List<Sms> tempList = this.smsDao.query(form, page);
        if (tempList != null && !tempList.isEmpty()) {
            for (Sms sms : tempList) {
                String smsState = this.ccps.getCodeNameByCode(sms.getFsbz(), "smsState");
                sms.setFsbzStr(smsState);
            }
        }
        return tempList;
    }

    @Override
    @Transactional
    public void saveSmsFormBean(String formBean, Person sender) {
        SmsFormBean smsForm = null;
        try {
            smsForm = Util.readValue(formBean, SmsFormBean.class);
        }
        catch (Exception e) {
            throw new RuntimeException("\u4fdd\u5355\u683c\u5f0f\u6709\u8bef", e);
        }
        Date scsjDate = new Date();
        HashSet<String> personIdSet = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)smsForm.getToId())) {
            String[] receiverArr;
            for (String personId : receiverArr = smsForm.getToId().split(",")) {
                personIdSet.add(personId);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)smsForm.getToDepId())) {
            String[] receiverDepIdArr;
            for (String depId : receiverDepIdArr = smsForm.getToDepId().split(",")) {
                List<String> depPersonId = this.smsDao.queryPersonIdByDepId(depId);
                personIdSet.addAll(depPersonId);
            }
        }
        HashSet<String> sjhSet = new HashSet<String>();
        for (String personId : personIdSet) {
            List<String> sjh = this.smsDao.querySjhByPersonId(personId);
            sjhSet.addAll(sjh);
        }
        for (String mobile : sjhSet) {
            Sms sms = new Sms();
            sms.setFsbz("0");
            sms.setScsj(scsjDate);
            sms.setDxnr(smsForm.getMessage());
            sms.setSjh(mobile);
            String yys = this.getYYS(mobile);
            String dkh = this.getDKH(yys);
            sms.setJh(sender.getCode());
            sms.setDkh(dkh);
            sms.setYysbh(yys);
            this.smsDao.save(sms);
        }
    }

    public String getYYS(String mobile) {
        String result = "3";
        String mobileSection = this.systemConfigService.getValueByCode("mobileSection");
        String[] section = mobileSection.split("#");
        for (int i = 0; i < section.length; ++i) {
            if (!mobile.startsWith(section[i])) continue;
            result = "1";
            return "1";
        }
        String unicomSection = this.systemConfigService.getValueByCode("mobileSection");
        String[] section2 = unicomSection.split("#");
        for (int i = 0; i < section2.length; ++i) {
            if (!mobile.startsWith(section2[i])) continue;
            result = "2";
            return "2";
        }
        String telecomSection = this.systemConfigService.getValueByCode("mobileSection");
        String[] section3 = telecomSection.split("#");
        for (int i = 0; i < section3.length; ++i) {
            if (!mobile.startsWith(section3[i])) continue;
            result = "3";
            return "3";
        }
        return result;
    }

    public String getDKH(String yys) {
        String result = "";
        if (yys.equals("1")) {
            result = this.systemConfigService.getValueByCode("mobileCode");
        }
        if (yys.equals("2")) {
            result = this.systemConfigService.getValueByCode("unicomCode");
        }
        if (yys.equals("3")) {
            result = this.systemConfigService.getValueByCode("telecomCode");
        }
        return result;
    }

    @Override
    public boolean checkKeyword(String content) {
        String[] strKeyWord = this.smsDao.getKeyWord();
        if (null != strKeyWord) {
            int size = strKeyWord.length;
            for (int i = 0; i < size; ++i) {
                if (content.indexOf(strKeyWord[i]) <= -1) continue;
                return false;
            }
        }
        return true;
    }
}

