/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.sso.service.impl;

import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.bean.AppDetailQueryInParams;
import com.xdja.pams.sso.bean.AppDetailQueryOutResult;
import com.xdja.pams.sso.bean.AppDetailQueryOutResultContent;
import com.xdja.pams.sso.bean.AppLimitQueryIn;
import com.xdja.pams.sso.bean.AppLimitQueryInParams;
import com.xdja.pams.sso.bean.AppLimitQueryOut;
import com.xdja.pams.sso.bean.AppLimitQueryOutResultContent;
import com.xdja.pams.sso.bean.AppQueryIn;
import com.xdja.pams.sso.bean.AppQueryOut;
import com.xdja.pams.sso.bean.AppRankingQueryInParams;
import com.xdja.pams.sso.bean.AppRankingQueryOutResult;
import com.xdja.pams.sso.bean.AppRankingQueryOutResultContent;
import com.xdja.pams.sso.bean.AppUsageQueryInParams;
import com.xdja.pams.sso.bean.AppUsageQueryOutResult;
import com.xdja.pams.sso.service.AppPlatformService;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppPlatformServiceImpl
implements AppPlatformService {
    @Autowired
    private SystemConfigPbService systemConfigService;
    private static final String METHOD_QUERY_PERSONLIMITS = "queryUserAppInfo";
    private static final String METHOD_QUERY_APPRANKING = "getAppRanking";
    private static final String METHDO_QUERY_APPDETAIL = "applicationDetail";
    private static final String METHDO_QUERY_USAGE = "getAppUsageStatistics";
    private static final String ID = "1";
    private static final String JSONRPC = "2.0";
    private static Logger log = Logger.getLogger(AppPlatformServiceImpl.class);

    @Override
    public List<String> getLimit(String id) {
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String appPlateFormUrl = this.systemConfigService.getValueByCode("sso_appplateformurl");
        AppLimitQueryIn queryIn = new AppLimitQueryIn();
        queryIn.setJsonrpc(JSONRPC);
        queryIn.setMethod(METHOD_QUERY_PERSONLIMITS);
        queryIn.setId(ID);
        AppLimitQueryInParams queryInParams = new AppLimitQueryInParams();
        queryInParams.setUserId(id);
        queryIn.setParams(queryInParams);
        String param = Util.toJsonStr(queryIn);
        String json = null;
        try {
            json = httpRequestUtil.post(appPlateFormUrl, param);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.debug((Object)("\u83b7\u53d6\u4eba\u5458\u6743\u9650\u8fd4\u56de\u7ed3\u679c\uff1a" + json));
        AppLimitQueryOut queryOut = Util.readValue(json, AppLimitQueryOut.class);
        ArrayList<String> list = new ArrayList<String>();
        if (queryOut != null) {
            for (AppLimitQueryOutResultContent content : queryOut.getResult().getContent()) {
                list.add(content.getAppName());
            }
        }
        list.add("com.xdja.jwt.hd.frame");
        return list;
    }

    @Override
    public List<String> getLimitAndType(String id) {
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String appPlateFormUrl = this.systemConfigService.getValueByCode("sso_appplateformurl");
        AppLimitQueryIn queryIn = new AppLimitQueryIn();
        queryIn.setJsonrpc(JSONRPC);
        queryIn.setMethod(METHOD_QUERY_PERSONLIMITS);
        queryIn.setId(ID);
        AppLimitQueryInParams queryInParams = new AppLimitQueryInParams();
        queryInParams.setUserId(id);
        queryIn.setParams(queryInParams);
        String param = Util.toJsonStr(queryIn);
        String json = null;
        try {
            json = httpRequestUtil.post(appPlateFormUrl, param);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.debug((Object)("\u83b7\u53d6\u4eba\u5458\u6743\u9650\u8fd4\u56de\u7ed3\u679c\uff1a" + json));
        AppLimitQueryOut queryOut = Util.readValue(json, AppLimitQueryOut.class);
        ArrayList<String> list = new ArrayList<String>();
        if (queryOut != null) {
            for (AppLimitQueryOutResultContent content : queryOut.getResult().getContent()) {
                list.add(content.getAppName() + "$" + content.getTypeId());
            }
        }
        return list;
    }

    public SystemConfigPbService getSystemConfigService() {
        return this.systemConfigService;
    }

    public void setSystemConfigService(SystemConfigPbService systemConfigService) {
        this.systemConfigService = systemConfigService;
    }

    @Override
    public List<AppRankingQueryOutResultContent> getAppRanking(String count, String type) {
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String appPlateFormUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL") + "/mamApi";
        AppQueryIn<AppRankingQueryInParams> queryIn = new AppQueryIn<AppRankingQueryInParams>();
        queryIn.setJsonrpc(JSONRPC);
        queryIn.setMethod(METHOD_QUERY_APPRANKING);
        queryIn.setId(ID);
        AppRankingQueryInParams queryInParams = new AppRankingQueryInParams();
        queryInParams.setCount(count);
        queryInParams.setType(type);
        queryIn.setParams(queryInParams);
        String param = Util.toJsonStr(queryIn);
        String json = null;
        try {
            json = httpRequestUtil.post(appPlateFormUrl, param);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        AppQueryOut queryOut = (AppQueryOut)Util.readValue(json, AppQueryOut.class, AppRankingQueryOutResult.class);
        return ((AppRankingQueryOutResult)queryOut.getResult()).getRankingList();
    }

    @Override
    public AppDetailQueryOutResultContent applicationDetail(String appId) {
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String appPlateFormUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL") + "/mamApi";
        AppQueryIn<AppDetailQueryInParams> queryIn = new AppQueryIn<AppDetailQueryInParams>();
        queryIn.setJsonrpc(JSONRPC);
        queryIn.setMethod(METHDO_QUERY_APPDETAIL);
        queryIn.setId(ID);
        AppDetailQueryInParams queryInParams = new AppDetailQueryInParams();
        queryInParams.setAppId(appId);
        queryIn.setParams(queryInParams);
        String param = Util.toJsonStr(queryIn);
        String json = null;
        try {
            json = httpRequestUtil.post(appPlateFormUrl, param);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        AppQueryOut queryOut = (AppQueryOut)Util.readValue(json, AppQueryOut.class, AppDetailQueryOutResult.class);
        return ((AppDetailQueryOutResult)queryOut.getResult()).getContent();
    }

    @Override
    public AppUsageQueryOutResult getAppUsageStatistics(String deptId, String type) {
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String appPlateFormUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL") + "/mamApi";
        AppQueryIn<AppUsageQueryInParams> queryIn = new AppQueryIn<AppUsageQueryInParams>();
        queryIn.setJsonrpc(JSONRPC);
        queryIn.setMethod(METHDO_QUERY_USAGE);
        queryIn.setId(ID);
        AppUsageQueryInParams queryInParams = new AppUsageQueryInParams();
        queryInParams.setDeptId(deptId);
        queryInParams.setType(type);
        queryIn.setParams(queryInParams);
        String param = Util.toJsonStr(queryIn);
        String json = null;
        try {
            json = httpRequestUtil.post(appPlateFormUrl, param);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        AppQueryOut queryOut = (AppQueryOut)Util.readValue(json, AppQueryOut.class, AppUsageQueryOutResult.class);
        return (AppUsageQueryOutResult)queryOut.getResult();
    }
}

