/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.sso.util;

import com.xdja.pams.common.util.Base64Encrypt;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertUtil {
    private static Logger log = Logger.getLogger(CertUtil.class);

    public static String getSignature(String msg, PrivateKey priKey, String algorithm) throws NoSuchAlgorithmException {
        String signature = null;
        byte[] digest = CertUtil.getDigest(msg, "SHA");
        signature = new Base64Encrypt().encodeStr(CertUtil.privateKeyEncrypt(digest, priKey, algorithm));
        signature = signature.replaceAll("\r", "").replace("\n", "");
        return signature;
    }

    public static byte[] getDigest(String msg, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        try {
            messageDigest.update(msg.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"\u83b7\u53d6\u6587\u672c\u6458\u8981\u5f02\u5e38", (Throwable)e);
        }
        byte[] bd = messageDigest.digest();
        return bd;
    }

    public static byte[] privateKeyEncrypt(byte[] bsSecure, PrivateKey privateKey, String algorithm) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(1, privateKey);
            byte[] bsPlain = cipher.doFinal(bsSecure);
            return bsPlain;
        }
        catch (Exception e) {
            log.error((Object)"\u79c1\u94a5\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static byte[] publicKeyDecrypt(byte[] bsSecure, PublicKey publicKey, String publicKeyAlg) {
        try {
            Cipher cipher = Cipher.getInstance(publicKeyAlg);
            cipher.init(2, publicKey);
            byte[] bsPlain = cipher.doFinal(bsSecure);
            return bsPlain;
        }
        catch (Exception e) {
            log.error((Object)"\u516c\u94a5\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static PrivateKey getPrivateKeyFromKeyKeyStory(String filePath, String passWord, String alias) throws Exception {
        RSAPrivateKey privateCrtKey = null;
        Security.addProvider((Provider)new BouncyCastleProvider());
        FileInputStream fis = new FileInputStream(new File(filePath));
        KeyStore store = KeyStore.getInstance("JKS");
        store.load(fis, passWord.toCharArray());
        privateCrtKey = (RSAPrivateKey)store.getKey(alias, passWord.toCharArray());
        return privateCrtKey;
    }

    public static PrivateKey getPrivateKey(String priKey, String algorithm) throws Exception {
        PrivateKey privateKey = null;
        PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(new Base64Encrypt().decode(priKey));
        KeyFactory keyf = KeyFactory.getInstance(algorithm);
        privateKey = keyf.generatePrivate(priPKCS8);
        return privateKey;
    }

    public static X509Certificate getCertFromStandFile(File file) {
        X509Certificate cert = null;
        CertificateFactory cf = null;
        FileInputStream fis = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            fis = new FileInputStream(file);
            cert = (X509Certificate)cf.generateCertificate(fis);
            return cert;
        }
        catch (Exception e) {
            log.error((Object)"\u4ece\u6807\u51c6\u8bc1\u4e66\u6587\u4ef6\u83b7\u53d6\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }
}

